/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.EditLogFileOutputStream;
import org.apache.hadoop.hdfs.server.namenode.EditLogOutputStream;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.JournalSet;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.PathUtils;
import org.apache.hadoop.util.ExitUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=Parameterized.class)
public class TestEditLogJournalFailures {
    private int editsPerformed = 0;
    private MiniDFSCluster cluster;
    private FileSystem fs;
    private boolean useAsyncEdits;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        params.add(new Object[]{Boolean.FALSE});
        params.add(new Object[]{Boolean.TRUE});
        return params;
    }

    public TestEditLogJournalFailures(boolean useAsyncEdits) {
        this.useAsyncEdits = useAsyncEdits;
    }

    private Configuration getConf() {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.namenode.edits.asynclogging", this.useAsyncEdits);
        return conf;
    }

    @Before
    public void setUpMiniCluster() throws IOException {
        this.setUpMiniCluster(this.getConf(), true);
    }

    public void setUpMiniCluster(Configuration conf, boolean manageNameDfsDirs) throws IOException {
        this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).manageNameDfsDirs(manageNameDfsDirs).checkExitOnShutdown(false).build();
        this.cluster.waitActive();
        this.fs = this.cluster.getFileSystem();
    }

    @After
    public void shutDownMiniCluster() throws IOException {
        if (this.fs != null) {
            this.fs.close();
            this.fs = null;
        }
        if (this.cluster != null) {
            try {
                this.cluster.shutdown();
                this.cluster = null;
            }
            catch (ExitUtil.ExitException exitException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testSingleFailedEditsDirOnFlush() throws IOException {
        Assert.assertTrue((boolean)this.doAnEdit());
        this.invalidateEditsDirAtIndex(0, true, false);
        Assert.assertTrue((boolean)this.doAnEdit());
        Assert.assertFalse((boolean)this.cluster.getNameNode().isInSafeMode());
    }

    @Test
    public void testAllEditsDirsFailOnFlush() throws IOException {
        Assert.assertTrue((boolean)this.doAnEdit());
        this.invalidateEditsDirAtIndex(0, true, false);
        this.invalidateEditsDirAtIndex(1, true, false);
        try {
            this.doAnEdit();
            Assert.fail((String)"The previous edit could not be synced to any persistent storage, should have halted the NN");
        }
        catch (RemoteException re) {
            Assert.assertTrue((boolean)re.getClassName().contains("ExitException"));
            GenericTestUtils.assertExceptionContains((String)"Could not sync enough journals to persistent storage. Unsynced transactions: 1", (Throwable)re);
        }
    }

    @Test
    public void testAllEditsDirFailOnWrite() throws IOException {
        Assert.assertTrue((boolean)this.doAnEdit());
        this.invalidateEditsDirAtIndex(0, true, true);
        this.invalidateEditsDirAtIndex(1, true, true);
        try {
            this.doAnEdit();
            Assert.fail((String)"The previous edit could not be synced to any persistent storage,  should have halted the NN");
        }
        catch (RemoteException re) {
            Assert.assertTrue((boolean)re.getClassName().contains("ExitException"));
            GenericTestUtils.assertExceptionContains((String)"Could not sync enough journals to persistent storage due to No journals available to flush. Unsynced transactions: 1", (Throwable)re);
        }
    }

    @Test
    public void testSingleFailedEditsDirOnSetReadyToFlush() throws IOException {
        Assert.assertTrue((boolean)this.doAnEdit());
        this.invalidateEditsDirAtIndex(0, false, false);
        Assert.assertTrue((boolean)this.doAnEdit());
        Assert.assertFalse((boolean)this.cluster.getNameNode().isInSafeMode());
    }

    @Test
    public void testSingleRequiredFailedEditsDirOnSetReadyToFlush() throws IOException {
        String[] editsDirs = this.cluster.getConfiguration(0).getTrimmedStrings("dfs.namenode.name.dir");
        this.shutDownMiniCluster();
        Configuration conf = this.getConf();
        conf.set("dfs.namenode.edits.dir.required", editsDirs[0]);
        conf.setInt("dfs.namenode.edits.dir.minimum", 0);
        conf.setInt("dfs.namenode.resource.checked.volumes.minimum", 0);
        this.setUpMiniCluster(conf, true);
        Assert.assertTrue((boolean)this.doAnEdit());
        this.invalidateEditsDirAtIndex(0, false, false);
        JournalSet.JournalAndStream nonRequiredJas = this.getJournalAndStream(1);
        EditLogFileOutputStream nonRequiredSpy = this.spyOnStream(nonRequiredJas);
        Assert.assertTrue((boolean)nonRequiredJas.isActive());
        try {
            this.doAnEdit();
            Assert.fail((String)"A single failure of a required journal should have halted the NN");
        }
        catch (RemoteException re) {
            Assert.assertTrue((boolean)re.getClassName().contains("ExitException"));
            GenericTestUtils.assertExceptionContains((String)"setReadyToFlush failed for required journal", (Throwable)re);
        }
        ((EditLogFileOutputStream)Mockito.verify((Object)nonRequiredSpy, (VerificationMode)Mockito.never())).setReadyToFlush();
        Assert.assertFalse((boolean)nonRequiredJas.isActive());
    }

    @Test
    public void testMultipleRedundantFailedEditsDirOnSetReadyToFlush() throws IOException {
        this.shutDownMiniCluster();
        Configuration conf = this.getConf();
        Object[] nameDirs = new String[4];
        for (int i = 0; i < nameDirs.length; ++i) {
            File nameDir = new File(PathUtils.getTestDir(this.getClass()), "name-dir" + i);
            nameDir.mkdirs();
            nameDirs[i] = nameDir.getAbsolutePath();
        }
        conf.set("dfs.namenode.name.dir", StringUtils.join((Object[])nameDirs, (String)","));
        conf.setInt("dfs.namenode.edits.dir.minimum", 2);
        this.setUpMiniCluster(conf, false);
        Assert.assertTrue((boolean)this.doAnEdit());
        this.invalidateEditsDirAtIndex(0, false, false);
        Assert.assertTrue((boolean)this.doAnEdit());
        this.invalidateEditsDirAtIndex(1, false, false);
        Assert.assertTrue((boolean)this.doAnEdit());
        this.invalidateEditsDirAtIndex(2, false, false);
        try {
            this.doAnEdit();
            Assert.fail((String)"A failure of more than the minimum number of redundant journals should have halted ");
        }
        catch (RemoteException re) {
            Assert.assertTrue((boolean)re.getClassName().contains("ExitException"));
            GenericTestUtils.assertExceptionContains((String)"Could not sync enough journals to persistent storage due to setReadyToFlush failed for too many journals. Unsynced transactions: 1", (Throwable)re);
        }
    }

    private void invalidateEditsDirAtIndex(int index, boolean failOnFlush, boolean failOnWrite) throws IOException {
        JournalSet.JournalAndStream jas = this.getJournalAndStream(index);
        EditLogFileOutputStream spyElos = this.spyOnStream(jas);
        if (failOnWrite) {
            ((EditLogFileOutputStream)Mockito.doThrow((Throwable)new IOException("fail on write()")).when((Object)spyElos)).write((FSEditLogOp)Matchers.any());
        }
        if (failOnFlush) {
            ((EditLogFileOutputStream)Mockito.doThrow((Throwable)new IOException("fail on flush()")).when((Object)spyElos)).flush();
        } else {
            ((EditLogFileOutputStream)Mockito.doThrow((Throwable)new IOException("fail on setReadyToFlush()")).when((Object)spyElos)).setReadyToFlush();
        }
    }

    private EditLogFileOutputStream spyOnStream(JournalSet.JournalAndStream jas) {
        EditLogFileOutputStream elos = (EditLogFileOutputStream)jas.getCurrentStream();
        EditLogFileOutputStream spyElos = (EditLogFileOutputStream)Mockito.spy((Object)elos);
        jas.setCurrentStreamForTests((EditLogOutputStream)spyElos);
        return spyElos;
    }

    private JournalSet.JournalAndStream getJournalAndStream(int index) {
        FSImage fsimage = this.cluster.getNamesystem().getFSImage();
        FSEditLog editLog = fsimage.getEditLog();
        return (JournalSet.JournalAndStream)editLog.getJournals().get(index);
    }

    private boolean doAnEdit() throws IOException {
        return this.fs.mkdirs(new Path("/tmp", Integer.toString(this.editsPerformed++)));
    }
}

