/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.namenode.Namesystem;

@InterfaceAudience.Private
@InterfaceStability.Evolving
class DecommissionManager {
    static final Log LOG = LogFactory.getLog(DecommissionManager.class);
    private final Namesystem namesystem;
    private final BlockManager blockmanager;

    DecommissionManager(Namesystem namesystem, BlockManager blockmanager) {
        this.namesystem = namesystem;
        this.blockmanager = blockmanager;
    }

    class Monitor
    implements Runnable {
        private final long recheckInterval;
        private final int numNodesPerCheck;
        private String firstkey = "";

        Monitor(int recheckIntervalInSecond, int numNodesPerCheck) {
            this.recheckInterval = (long)recheckIntervalInSecond * 1000L;
            this.numNodesPerCheck = numNodesPerCheck;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (DecommissionManager.this.namesystem.isRunning()) {
                DecommissionManager.this.namesystem.writeLock();
                try {
                    this.check();
                }
                finally {
                    DecommissionManager.this.namesystem.writeUnlock();
                }
                try {
                    Thread.sleep(this.recheckInterval);
                }
                catch (InterruptedException ie) {
                    LOG.warn((Object)(this.getClass().getSimpleName() + " interrupted: " + ie));
                }
            }
        }

        private void check() {
            DatanodeManager dm = DecommissionManager.this.blockmanager.getDatanodeManager();
            int count = 0;
            for (Map.Entry<String, DatanodeDescriptor> entry : dm.getDatanodeCyclicIteration(this.firstkey)) {
                DatanodeDescriptor d = entry.getValue();
                this.firstkey = entry.getKey();
                if (!d.isDecommissionInProgress()) continue;
                try {
                    dm.checkDecommissionState(d);
                }
                catch (Exception e) {
                    LOG.warn((Object)("entry=" + entry), (Throwable)e);
                }
                if (++count != this.numNodesPerCheck) continue;
                return;
            }
        }
    }
}

