/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.erasurecode;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.concurrent.Callable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.BlockReader;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.client.impl.BlockReaderRemote;
import org.apache.hadoop.hdfs.net.Peer;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.DataEncryptionKeyFactory;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.SaslDataTransferClient;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.server.datanode.CachingStrategy;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.erasurecode.StripedReader;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.token.Token;
import org.slf4j.Logger;

@InterfaceAudience.Private
class StripedBlockReader {
    private static final Logger LOG = DataNode.LOG;
    private StripedReader stripedReader;
    private final DataNode datanode;
    private final Configuration conf;
    private final short index;
    private final ExtendedBlock block;
    private final DatanodeInfo source;
    private BlockReader blockReader;
    private ByteBuffer buffer;
    private boolean isLocal;

    StripedBlockReader(StripedReader stripedReader, DataNode datanode, Configuration conf, short index, ExtendedBlock block, DatanodeInfo source, long offsetInBlock) {
        this.stripedReader = stripedReader;
        this.datanode = datanode;
        this.conf = conf;
        this.index = index;
        this.source = source;
        this.block = block;
        this.isLocal = false;
        BlockReader tmpBlockReader = this.createBlockReader(offsetInBlock);
        if (tmpBlockReader != null) {
            this.blockReader = tmpBlockReader;
        }
    }

    ByteBuffer getReadBuffer() {
        if (this.buffer == null) {
            this.buffer = this.stripedReader.allocateReadBuffer();
        }
        return this.buffer;
    }

    void freeReadBuffer() {
        this.buffer = null;
    }

    void resetBlockReader(long offsetInBlock) {
        this.blockReader = this.createBlockReader(offsetInBlock);
    }

    private BlockReader createBlockReader(long offsetInBlock) {
        if (offsetInBlock >= this.block.getNumBytes()) {
            return null;
        }
        Peer peer = null;
        try {
            InetSocketAddress dnAddr = this.stripedReader.getSocketAddress4Transfer(this.source);
            Token<BlockTokenIdentifier> blockToken = this.datanode.getBlockAccessToken(this.block, EnumSet.of(BlockTokenIdentifier.AccessMode.READ), StorageType.EMPTY_ARRAY, new String[0]);
            peer = this.newConnectedPeer(this.block, dnAddr, blockToken, (DatanodeID)this.source);
            if (peer.isLocal()) {
                this.isLocal = true;
            }
            return BlockReaderRemote.newBlockReader((String)"dummy", (ExtendedBlock)this.block, blockToken, (long)offsetInBlock, (long)(this.block.getNumBytes() - offsetInBlock), (boolean)true, (String)"", (Peer)peer, (DatanodeID)this.source, null, (CachingStrategy)this.stripedReader.getCachingStrategy(), (int)-1);
        }
        catch (IOException e) {
            LOG.info("Exception while creating remote block reader, datanode {}", (Object)this.source, (Object)e);
            IOUtils.closeStream(peer);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Peer newConnectedPeer(ExtendedBlock b, InetSocketAddress addr, Token<BlockTokenIdentifier> blockToken, DatanodeID datanodeId) throws IOException {
        Peer peer;
        block3: {
            Peer peer2 = null;
            boolean success = false;
            Socket sock = null;
            int socketTimeout = this.datanode.getDnConf().getSocketTimeout();
            try {
                sock = NetUtils.getDefaultSocketFactory((Configuration)this.conf).createSocket();
                NetUtils.connect((Socket)sock, (SocketAddress)addr, (int)socketTimeout);
                peer2 = DFSUtilClient.peerFromSocketAndKey((SaslDataTransferClient)this.datanode.getSaslClient(), (Socket)sock, (DataEncryptionKeyFactory)this.datanode.getDataEncryptionKeyFactoryForBlock(b), blockToken, (DatanodeID)datanodeId, (int)socketTimeout);
                success = true;
                peer = peer2;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.cleanup(null, (Closeable[])new Closeable[]{peer2});
                    IOUtils.closeSocket((Socket)sock);
                }
                throw throwable;
            }
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{peer2});
            IOUtils.closeSocket((Socket)sock);
        }
        return peer;
    }

    Callable<Void> readFromBlock(final int length, final DFSUtilClient.CorruptedBlocks corruptedBlocks) {
        return new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    StripedBlockReader.this.getReadBuffer().limit(length);
                    StripedBlockReader.this.actualReadFromBlock();
                    return null;
                }
                catch (ChecksumException e) {
                    LOG.warn("Found Checksum error for {} from {} at {}", new Object[]{StripedBlockReader.this.block, StripedBlockReader.this.source, e.getPos()});
                    corruptedBlocks.addCorruptedBlock(StripedBlockReader.this.block, StripedBlockReader.this.source);
                    throw e;
                }
                catch (IOException e) {
                    LOG.info(e.getMessage());
                    throw e;
                }
            }
        };
    }

    private void actualReadFromBlock() throws IOException {
        int nread;
        int len = this.buffer.remaining();
        for (int n = 0; n < len && (nread = this.blockReader.read(this.buffer)) > 0; n += nread) {
            this.stripedReader.getReconstructor().incrBytesRead(this.isLocal, nread);
        }
    }

    void closeBlockReader() {
        IOUtils.closeStream((Closeable)this.blockReader);
        this.blockReader = null;
    }

    short getIndex() {
        return this.index;
    }

    BlockReader getBlockReader() {
        return this.blockReader;
    }
}

