/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.common.HdfsConstants;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.StaticMapping;

public class MiniDFSClusterWithNodeGroup
extends MiniDFSCluster {
    private static String[] NODE_GROUPS = null;
    private static final Log LOG = LogFactory.getLog(MiniDFSClusterWithNodeGroup.class);

    public MiniDFSClusterWithNodeGroup(int nameNodePort, Configuration conf, int numDataNodes, boolean format, boolean manageDfsDirs, HdfsConstants.StartupOption operation, String[] racks, long[] simulatedCapacities) throws IOException {
        super(nameNodePort, conf, numDataNodes, format, manageDfsDirs, manageDfsDirs, operation, racks, null, simulatedCapacities);
    }

    public MiniDFSClusterWithNodeGroup(int nameNodePort, Configuration conf, int numDataNodes, boolean format, boolean manageDfsDirs, HdfsConstants.StartupOption operation, String[] racks, String[] hosts, long[] simulatedCapacities) throws IOException {
        super(nameNodePort, conf, numDataNodes, format, manageDfsDirs, manageDfsDirs, operation, racks, hosts, simulatedCapacities);
    }

    public static void setNodeGroups(String[] nodeGroups) {
        NODE_GROUPS = nodeGroups;
    }

    public synchronized void startDataNodes(Configuration conf, int numDataNodes, boolean manageDfsDirs, HdfsConstants.StartupOption operation, String[] racks, String[] nodeGroups, String[] hosts, long[] simulatedCapacities) throws IOException {
        String[] stringArray;
        conf.set("slave.host.name", "127.0.0.1");
        int curDatanodesNum = this.dataNodes.size();
        if (conf.get("dfs.blockreport.initialDelay") == null) {
            conf.setLong("dfs.blockreport.initialDelay", 0L);
        }
        if (this.nameNode != null) {
            InetSocketAddress nnAddr = this.nameNode.getNameNodeAddress();
            int nameNodePort = nnAddr.getPort();
            FileSystem.setDefaultUri((Configuration)conf, (String)("hdfs://" + nnAddr.getHostName() + ":" + Integer.toString(nameNodePort)));
        }
        if (racks != null && numDataNodes > racks.length) {
            throw new IllegalArgumentException("The length of racks [" + racks.length + "] is less than the number of datanodes [" + numDataNodes + "].");
        }
        if (nodeGroups != null && numDataNodes > nodeGroups.length) {
            throw new IllegalArgumentException("The length of nodeGroups [" + nodeGroups.length + "] is less than the number of datanodes [" + numDataNodes + "].");
        }
        if (hosts != null && numDataNodes > hosts.length) {
            throw new IllegalArgumentException("The length of hosts [" + hosts.length + "] is less than the number of datanodes [" + numDataNodes + "].");
        }
        if (racks != null && hosts == null) {
            hosts = new String[numDataNodes];
            for (int i = curDatanodesNum; i < curDatanodesNum + numDataNodes; ++i) {
                hosts[i - curDatanodesNum] = "host" + i + ".foo.com";
            }
        }
        if (simulatedCapacities != null && numDataNodes > simulatedCapacities.length) {
            throw new IllegalArgumentException("The length of simulatedCapacities [" + simulatedCapacities.length + "] is less than the number of datanodes [" + numDataNodes + "].");
        }
        conf.set("dfs.datanode.address", "127.0.0.1:0");
        conf.set("dfs.datanode.http.address", "127.0.0.1:0");
        conf.set("dfs.datanode.ipc.address", "127.0.0.1:0");
        if (operation == null || operation != HdfsConstants.StartupOption.ROLLBACK) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = operation.getName();
        }
        String[] dnArgs = stringArray;
        for (int i = curDatanodesNum; i < curDatanodesNum + numDataNodes; ++i) {
            DataNode dn;
            Configuration dnConf = new Configuration(conf);
            if (manageDfsDirs) {
                File dir1 = new File(this.data_dir, "data" + (2 * i + 1));
                File dir2 = new File(this.data_dir, "data" + (2 * i + 2));
                dir1.mkdirs();
                dir2.mkdirs();
                if (!dir1.isDirectory() || !dir2.isDirectory()) {
                    throw new IOException("Mkdirs failed to create directory for DataNode " + i + ": " + dir1 + " or " + dir2);
                }
                dnConf.set("dfs.data.dir", dir1.getPath() + "," + dir2.getPath());
            }
            if (simulatedCapacities != null) {
                dnConf.setBoolean("dfs.datanode.simulateddatastorage", true);
                dnConf.setLong("dfs.datanode.simulateddatastorage.capacity", simulatedCapacities[i - curDatanodesNum]);
            }
            LOG.info((Object)("Starting DataNode " + i + " with " + "dfs.datanode.data.dir" + ": " + dnConf.get("dfs.datanode.data.dir")));
            if (hosts != null) {
                dnConf.set("slave.host.name", hosts[i - curDatanodesNum]);
                LOG.info((Object)("Starting DataNode " + i + " with hostname set to: " + dnConf.get("slave.host.name")));
            }
            if (racks != null) {
                String name = hosts[i - curDatanodesNum];
                if (nodeGroups == null) {
                    LOG.info((Object)("Adding node with hostname : " + name + " to rack " + racks[i - curDatanodesNum]));
                    StaticMapping.addNodeToRack(name, racks[i - curDatanodesNum]);
                } else {
                    LOG.info((Object)("Adding node with hostname : " + name + " to serverGroup " + nodeGroups[i - curDatanodesNum] + " and rack " + racks[i - curDatanodesNum]));
                    StaticMapping.addNodeToRack(name, racks[i - curDatanodesNum] + nodeGroups[i - curDatanodesNum]);
                }
            }
            Configuration newconf = new Configuration(dnConf);
            if (hosts != null) {
                NetUtils.addStaticResolution((String)hosts[i - curDatanodesNum], (String)"localhost");
            }
            if ((dn = DataNode.instantiateDataNode((String[])dnArgs, (Configuration)dnConf)) == null) {
                throw new IOException("Cannot start DataNode in " + dnConf.get("dfs.datanode.data.dir"));
            }
            String ipAddr = dn.getSelfAddr().getAddress().getHostAddress();
            if (racks != null) {
                int port = dn.getSelfAddr().getPort();
                if (nodeGroups == null) {
                    LOG.info((Object)("Adding node with IP:port : " + ipAddr + ":" + port + " to rack " + racks[i - curDatanodesNum]));
                    StaticMapping.addNodeToRack(ipAddr + ":" + port, racks[i - curDatanodesNum]);
                } else {
                    LOG.info((Object)("Adding node with IP:port : " + ipAddr + ":" + port + " to nodeGroup " + nodeGroups[i - curDatanodesNum] + " and rack " + racks[i - curDatanodesNum]));
                    StaticMapping.addNodeToRack(ipAddr + ":" + port, racks[i - curDatanodesNum] + nodeGroups[i - curDatanodesNum]);
                }
            }
            DataNode.runDatanodeDaemon((DataNode)dn);
            this.dataNodes.add(new MiniDFSCluster.DataNodeProperties(dn, newconf, dnArgs));
        }
        curDatanodesNum += numDataNodes;
        this.numDataNodes += numDataNodes;
        this.waitActive();
    }

    public synchronized void startDataNodes(Configuration conf, int numDataNodes, boolean manageDfsDirs, HdfsConstants.StartupOption operation, String[] racks, String[] nodeGroups, String[] hosts, long[] simulatedCapacities, boolean setupHostsFile) throws IOException {
        this.startDataNodes(conf, numDataNodes, manageDfsDirs, operation, racks, nodeGroups, hosts, simulatedCapacities);
    }

    @Override
    public synchronized void startDataNodes(Configuration conf, int numDataNodes, boolean manageDfsDirs, HdfsConstants.StartupOption operation, String[] racks, String[] hosts, long[] simulatedCapacities) throws IOException {
        this.startDataNodes(conf, numDataNodes, manageDfsDirs, operation, racks, NODE_GROUPS, hosts, simulatedCapacities);
    }
}

