/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.security;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.namenode.web.resources.NamenodeWebHdfsMethods;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.WebHdfsTestUtil;
import org.apache.hadoop.hdfs.web.resources.DoAsParam;
import org.apache.hadoop.hdfs.web.resources.ExceptionHandler;
import org.apache.hadoop.hdfs.web.resources.GetOpParam;
import org.apache.hadoop.hdfs.web.resources.HttpOpParam;
import org.apache.hadoop.hdfs.web.resources.Param;
import org.apache.hadoop.hdfs.web.resources.PostOpParam;
import org.apache.hadoop.hdfs.web.resources.PutOpParam;
import org.apache.hadoop.security.TestDoAsEffectiveUser;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.security.token.Token;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDelegationTokenForProxyUser {
    private MiniDFSCluster cluster;
    Configuration config;
    private static final String GROUP1_NAME = "group1";
    private static final String GROUP2_NAME = "group2";
    private static final String[] GROUP_NAMES = new String[]{"group1", "group2"};
    private static final String REAL_USER = "RealUser";
    private static final String PROXY_USER = "ProxyUser";
    private static final Log LOG = LogFactory.getLog(TestDoAsEffectiveUser.class);

    private void configureSuperUserIPAddresses(Configuration conf, String superUserShortName) throws IOException {
        ArrayList<String> ipList = new ArrayList<String>();
        Enumeration<NetworkInterface> netInterfaceList = NetworkInterface.getNetworkInterfaces();
        while (netInterfaceList.hasMoreElements()) {
            NetworkInterface inf = netInterfaceList.nextElement();
            Enumeration<InetAddress> addrList = inf.getInetAddresses();
            while (addrList.hasMoreElements()) {
                InetAddress addr = addrList.nextElement();
                ipList.add(addr.getHostAddress());
            }
        }
        StringBuilder builder = new StringBuilder();
        for (String ip : ipList) {
            builder.append(ip);
            builder.append(',');
        }
        builder.append("127.0.1.1,");
        builder.append(InetAddress.getLocalHost().getCanonicalHostName());
        LOG.info((Object)("Local Ip addresses: " + builder.toString()));
        conf.setStrings(ProxyUsers.getProxySuperuserIpConfKey((String)superUserShortName), new String[]{builder.toString()});
    }

    @Before
    public void setUp() throws Exception {
        this.config = new Configuration();
        this.config.setBoolean("dfs.webhdfs.enabled", true);
        this.config.setBoolean("dfs.support.broken.append", true);
        this.config.setLong("dfs.namenode.delegation.token.max-lifetime", 10000L);
        this.config.setLong("dfs.namenode.delegation.token.renew-interval", 5000L);
        this.config.setStrings(ProxyUsers.getProxySuperuserGroupConfKey((String)REAL_USER), new String[]{GROUP1_NAME});
        this.configureSuperUserIPAddresses(this.config, REAL_USER);
        FileSystem.setDefaultUri((Configuration)this.config, (String)"hdfs://localhost:0");
        this.cluster = new MiniDFSCluster(0, this.config, 1, true, true, true, null, null, null, null);
        this.cluster.waitActive();
        this.cluster.getNameNode().getNamesystem().getDelegationTokenSecretManager().startThreads();
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)this.config);
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void testDelegationTokenWithRealUser() throws IOException {
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)REAL_USER);
        UserGroupInformation proxyUgi = UserGroupInformation.createProxyUserForTesting((String)PROXY_USER, (UserGroupInformation)ugi, (String[])GROUP_NAMES);
        try {
            Token token = (Token)proxyUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Token<DelegationTokenIdentifier>>(){

                @Override
                public Token<DelegationTokenIdentifier> run() throws IOException {
                    DistributedFileSystem dfs = (DistributedFileSystem)TestDelegationTokenForProxyUser.this.cluster.getFileSystem();
                    return dfs.getDelegationToken("RenewerUser");
                }
            });
            DelegationTokenIdentifier identifier = new DelegationTokenIdentifier();
            byte[] tokenId = token.getIdentifier();
            identifier.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(tokenId)));
            Assert.assertEquals((Object)identifier.getUser().getUserName(), (Object)PROXY_USER);
            Assert.assertEquals((Object)identifier.getUser().getRealUser().getUserName(), (Object)REAL_USER);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Test
    public void testWebHdfsDoAs() throws Exception {
        WebHdfsTestUtil.LOG.info((Object)"START: testWebHdfsDoAs()");
        ((Log4JLogger)NamenodeWebHdfsMethods.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)ExceptionHandler.LOG).getLogger().setLevel(Level.ALL);
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)REAL_USER);
        WebHdfsTestUtil.LOG.info((Object)("ugi.getShortUserName()=" + ugi.getShortUserName()));
        WebHdfsFileSystem webhdfs = WebHdfsTestUtil.getWebHdfsFileSystemAs(ugi, this.config);
        Path root = new Path("/");
        this.cluster.getFileSystem().setPermission(root, new FsPermission(511));
        URL url = WebHdfsTestUtil.toUrl(webhdfs, (HttpOpParam.Op)GetOpParam.Op.GETHOMEDIRECTORY, root, new Param[]{new DoAsParam(PROXY_USER)});
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        Map<?, ?> m = WebHdfsTestUtil.connectAndGetJson(conn, 200);
        conn.disconnect();
        Object responsePath = m.get(Path.class.getSimpleName());
        WebHdfsTestUtil.LOG.info((Object)("responsePath=" + responsePath));
        Assert.assertEquals((Object)"/user/ProxyUser", responsePath);
        url = WebHdfsTestUtil.toUrl(webhdfs, (HttpOpParam.Op)GetOpParam.Op.GETHOMEDIRECTORY, root, new Param[]{new DoAsParam(PROXY_USER){

            public String getName() {
                return "DOas";
            }
        }});
        conn = (HttpURLConnection)url.openConnection();
        m = WebHdfsTestUtil.connectAndGetJson(conn, 200);
        conn.disconnect();
        responsePath = m.get(Path.class.getSimpleName());
        WebHdfsTestUtil.LOG.info((Object)("responsePath=" + responsePath));
        Assert.assertEquals((Object)"/user/ProxyUser", responsePath);
        Path f = new Path("/testWebHdfsDoAs/a.txt");
        PutOpParam.Op op = PutOpParam.Op.CREATE;
        URL url2 = WebHdfsTestUtil.toUrl(webhdfs, (HttpOpParam.Op)op, f, new Param[]{new DoAsParam(PROXY_USER)});
        WebHdfsTestUtil.LOG.info((Object)("url=" + url2));
        HttpURLConnection conn2 = (HttpURLConnection)url2.openConnection();
        conn2 = WebHdfsTestUtil.twoStepWrite(webhdfs, (HttpOpParam.Op)op, conn2);
        FSDataOutputStream out = WebHdfsTestUtil.write(webhdfs, (HttpOpParam.Op)op, conn2, 4096);
        out.write("Hello, webhdfs user!".getBytes());
        out.close();
        FileStatus status = webhdfs.getFileStatus(f);
        WebHdfsTestUtil.LOG.info((Object)("status.getOwner()=" + status.getOwner()));
        Assert.assertEquals((Object)PROXY_USER, (Object)status.getOwner());
        op = PostOpParam.Op.APPEND;
        url2 = WebHdfsTestUtil.toUrl(webhdfs, (HttpOpParam.Op)op, f, new Param[]{new DoAsParam(PROXY_USER)});
        conn2 = (HttpURLConnection)url2.openConnection();
        conn2 = WebHdfsTestUtil.twoStepWrite(webhdfs, (HttpOpParam.Op)op, conn2);
        out = WebHdfsTestUtil.write(webhdfs, (HttpOpParam.Op)op, conn2, 4096);
        out.write("\nHello again!".getBytes());
        out.close();
        status = webhdfs.getFileStatus(f);
        WebHdfsTestUtil.LOG.info((Object)("status.getOwner()=" + status.getOwner()));
        WebHdfsTestUtil.LOG.info((Object)("status.getLen()  =" + status.getLen()));
        Assert.assertEquals((Object)PROXY_USER, (Object)status.getOwner());
    }
}

