/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.namenode.BlockPlacementPolicyDefault;
import org.apache.hadoop.hdfs.server.namenode.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.test.MetricsAsserts;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;

public class TestReplicationPolicy
extends TestCase {
    private static final int BLOCK_SIZE = 1024;
    private static final int NUM_OF_DATANODES = 6;
    private static final Configuration CONF;
    private static final NetworkTopology cluster;
    private static final NameNode namenode;
    private static final BlockPlacementPolicy replicator;
    private static final String filename = "/dummyfile.txt";
    private static final DatanodeDescriptor[] dataNodes;
    private static final long staleInterval = 30000L;
    private static final DatanodeDescriptor NODE;

    public void testChooseTarget1() throws Exception {
        dataNodes[0].updateHeartbeat(10240L, 0L, 5120L, 4);
        DatanodeDescriptor[] targets = replicator.chooseTarget(filename, 0, dataNodes[0], 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)0);
        targets = replicator.chooseTarget(filename, 1, dataNodes[0], 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)1);
        TestReplicationPolicy.assertEquals((Object)targets[0], (Object)dataNodes[0]);
        targets = replicator.chooseTarget(filename, 2, dataNodes[0], 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)2);
        TestReplicationPolicy.assertEquals((Object)targets[0], (Object)dataNodes[0]);
        TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[1]));
        targets = replicator.chooseTarget(filename, 3, dataNodes[0], 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)3);
        TestReplicationPolicy.assertEquals((Object)targets[0], (Object)dataNodes[0]);
        TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[1]));
        TestReplicationPolicy.assertTrue((boolean)cluster.isOnSameRack((Node)targets[1], (Node)targets[2]));
        targets = replicator.chooseTarget(filename, 4, dataNodes[0], 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)4);
        TestReplicationPolicy.assertEquals((Object)targets[0], (Object)dataNodes[0]);
        TestReplicationPolicy.assertTrue((cluster.isOnSameRack((Node)targets[1], (Node)targets[2]) || cluster.isOnSameRack((Node)targets[2], (Node)targets[3]) ? 1 : 0) != 0);
        TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[2]));
        dataNodes[0].updateHeartbeat(10240L, 0L, 5120L, 0);
    }

    public void testChooseTarget2() throws Exception {
        BlockPlacementPolicyDefault repl = (BlockPlacementPolicyDefault)replicator;
        ArrayList chosenNodes = new ArrayList();
        HashMap<DatanodeDescriptor, DatanodeDescriptor> excludedNodes = new HashMap<DatanodeDescriptor, DatanodeDescriptor>();
        excludedNodes.put(dataNodes[1], dataNodes[1]);
        DatanodeDescriptor[] targets = repl.chooseTarget(0, dataNodes[0], chosenNodes, excludedNodes, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)0);
        excludedNodes.clear();
        chosenNodes.clear();
        excludedNodes.put(dataNodes[1], dataNodes[1]);
        targets = repl.chooseTarget(1, dataNodes[0], chosenNodes, excludedNodes, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)1);
        TestReplicationPolicy.assertEquals((Object)targets[0], (Object)dataNodes[0]);
        excludedNodes.clear();
        chosenNodes.clear();
        excludedNodes.put(dataNodes[1], dataNodes[1]);
        targets = repl.chooseTarget(2, dataNodes[0], chosenNodes, excludedNodes, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)2);
        TestReplicationPolicy.assertEquals((Object)targets[0], (Object)dataNodes[0]);
        TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[1]));
        excludedNodes.clear();
        chosenNodes.clear();
        excludedNodes.put(dataNodes[1], dataNodes[1]);
        targets = repl.chooseTarget(3, dataNodes[0], chosenNodes, excludedNodes, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)3);
        TestReplicationPolicy.assertEquals((Object)targets[0], (Object)dataNodes[0]);
        TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[1]));
        TestReplicationPolicy.assertTrue((boolean)cluster.isOnSameRack((Node)targets[1], (Node)targets[2]));
        excludedNodes.clear();
        chosenNodes.clear();
        excludedNodes.put(dataNodes[1], dataNodes[1]);
        targets = repl.chooseTarget(4, dataNodes[0], chosenNodes, excludedNodes, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)4);
        TestReplicationPolicy.assertEquals((Object)targets[0], (Object)dataNodes[0]);
        for (int i = 1; i < 4; ++i) {
            TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[i]));
        }
        TestReplicationPolicy.assertTrue((cluster.isOnSameRack((Node)targets[1], (Node)targets[2]) || cluster.isOnSameRack((Node)targets[2], (Node)targets[3]) ? 1 : 0) != 0);
        TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)targets[1], (Node)targets[3]));
    }

    public void testChooseTarget3() throws Exception {
        dataNodes[0].updateHeartbeat(10240L, 0L, 4096L, 0);
        DatanodeDescriptor[] targets = replicator.chooseTarget(filename, 0, dataNodes[0], 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)0);
        targets = replicator.chooseTarget(filename, 1, dataNodes[0], 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)1);
        TestReplicationPolicy.assertEquals((Object)targets[0], (Object)dataNodes[1]);
        targets = replicator.chooseTarget(filename, 2, dataNodes[0], 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)2);
        TestReplicationPolicy.assertEquals((Object)targets[0], (Object)dataNodes[1]);
        TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[1]));
        targets = replicator.chooseTarget(filename, 3, dataNodes[0], 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)3);
        TestReplicationPolicy.assertEquals((Object)targets[0], (Object)dataNodes[1]);
        TestReplicationPolicy.assertTrue((boolean)cluster.isOnSameRack((Node)targets[1], (Node)targets[2]));
        TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[1]));
        targets = replicator.chooseTarget(filename, 4, dataNodes[0], 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)4);
        TestReplicationPolicy.assertEquals((Object)targets[0], (Object)dataNodes[1]);
        for (int i = 1; i < 4; ++i) {
            TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[i]));
        }
        TestReplicationPolicy.assertTrue((cluster.isOnSameRack((Node)targets[1], (Node)targets[2]) || cluster.isOnSameRack((Node)targets[2], (Node)targets[3]) ? 1 : 0) != 0);
        TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)targets[1], (Node)targets[3]));
        dataNodes[0].updateHeartbeat(10240L, 0L, 5120L, 0);
    }

    public void testChoooseTarget4() throws Exception {
        int i;
        for (int i2 = 0; i2 < 2; ++i2) {
            dataNodes[i2].updateHeartbeat(10240L, 0L, 4096L, 0);
        }
        DatanodeDescriptor[] targets = replicator.chooseTarget(filename, 0, dataNodes[0], 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)0);
        targets = replicator.chooseTarget(filename, 1, dataNodes[0], 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)1);
        TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)dataNodes[0]));
        targets = replicator.chooseTarget(filename, 2, dataNodes[0], 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)2);
        TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)dataNodes[0]));
        TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[1]));
        targets = replicator.chooseTarget(filename, 3, dataNodes[0], 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)3);
        for (i = 0; i < 3; ++i) {
            TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)targets[i], (Node)dataNodes[0]));
        }
        TestReplicationPolicy.assertTrue((cluster.isOnSameRack((Node)targets[0], (Node)targets[1]) || cluster.isOnSameRack((Node)targets[1], (Node)targets[2]) ? 1 : 0) != 0);
        TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[2]));
        for (i = 0; i < 2; ++i) {
            dataNodes[i].updateHeartbeat(10240L, 0L, 5120L, 0);
        }
    }

    public void testChooseTarget5() throws Exception {
        DatanodeDescriptor[] targets = replicator.chooseTarget(filename, 0, NODE, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)0);
        targets = replicator.chooseTarget(filename, 1, NODE, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)1);
        targets = replicator.chooseTarget(filename, 2, NODE, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)2);
        TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[1]));
        targets = replicator.chooseTarget(filename, 3, NODE, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)3);
        TestReplicationPolicy.assertTrue((boolean)cluster.isOnSameRack((Node)targets[1], (Node)targets[2]));
        TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[1]));
    }

    private boolean containsWithinRange(DatanodeDescriptor target, DatanodeDescriptor[] nodes, int startIndex, int endIndex) {
        assert (startIndex >= 0 && startIndex < nodes.length);
        assert (endIndex >= startIndex && endIndex < nodes.length);
        for (int i = startIndex; i <= endIndex; ++i) {
            if (!nodes[i].equals((Object)target)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testChooseTargetWithMoreThanAvailableNodesWithStaleness() throws Exception {
        try {
            namenode.getNamesystem().setNumStaleNodes(6);
            this.testChooseTargetWithMoreThanAvailableNodes();
        }
        finally {
            namenode.getNamesystem().setNumStaleNodes(0);
        }
    }

    public void testChooseTargetWithMoreThanAvailableNodes() throws Exception {
        for (int i = 0; i < 2; ++i) {
            dataNodes[i].updateHeartbeat(10240L, 0L, 4096L, 0);
        }
        TestAppender appender = new TestAppender();
        Logger logger = Logger.getRootLogger();
        logger.addAppender((Appender)appender);
        DatanodeDescriptor[] targets = replicator.chooseTarget(filename, 6, dataNodes[0], new ArrayList(), 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)4);
        List<LoggingEvent> log = appender.getLog();
        TestReplicationPolicy.assertNotNull(log);
        TestReplicationPolicy.assertFalse((log.size() == 0 ? 1 : 0) != 0);
        LoggingEvent lastLogEntry = log.get(log.size() - 1);
        TestReplicationPolicy.assertEquals((Object)lastLogEntry.getLevel(), (Object)Level.WARN);
        TestReplicationPolicy.assertTrue((boolean)((String)lastLogEntry.getMessage()).contains("in need of 2"));
        for (int i = 0; i < 2; ++i) {
            dataNodes[i].updateHeartbeat(10240L, 0L, 5120L, 0);
        }
    }

    public void testChooseTargetWithStaleNodes() throws Exception {
        dataNodes[0].setLastUpdate(System.currentTimeMillis() - 30000L - 1L);
        namenode.getNamesystem().heartbeatCheck();
        TestReplicationPolicy.assertTrue((boolean)namenode.getNamesystem().shouldAvoidStaleDataNodesForWrite());
        DatanodeDescriptor[] targets = replicator.chooseTarget(filename, 1, dataNodes[0], 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)1);
        TestReplicationPolicy.assertEquals((Object)targets[0], (Object)dataNodes[1]);
        HashMap<DatanodeDescriptor, DatanodeDescriptor> excludedNodes = new HashMap<DatanodeDescriptor, DatanodeDescriptor>();
        excludedNodes.put(dataNodes[1], dataNodes[1]);
        ArrayList chosenNodes = new ArrayList();
        targets = replicator.chooseTarget(filename, 1, dataNodes[0], chosenNodes, excludedNodes, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)1);
        TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)dataNodes[0]));
        dataNodes[0].setLastUpdate(System.currentTimeMillis());
        namenode.getNamesystem().heartbeatCheck();
    }

    public void testChooseTargetWithHalfStaleNodes() throws Exception {
        for (int i = 0; i < 3; ++i) {
            dataNodes[i].setLastUpdate(System.currentTimeMillis() - 30000L - 1L);
        }
        namenode.getNamesystem().heartbeatCheck();
        DatanodeDescriptor[] targets = replicator.chooseTarget(filename, 1, dataNodes[0], 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)1);
        TestReplicationPolicy.assertFalse((boolean)this.containsWithinRange(targets[0], dataNodes, 0, 2));
        targets = replicator.chooseTarget(filename, 2, dataNodes[0], 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)2);
        TestReplicationPolicy.assertFalse((boolean)this.containsWithinRange(targets[0], dataNodes, 0, 2));
        TestReplicationPolicy.assertFalse((boolean)this.containsWithinRange(targets[1], dataNodes, 0, 2));
        targets = replicator.chooseTarget(filename, 3, dataNodes[0], 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)3);
        TestReplicationPolicy.assertTrue((boolean)this.containsWithinRange(targets[0], dataNodes, 3, 5));
        TestReplicationPolicy.assertTrue((boolean)this.containsWithinRange(targets[1], dataNodes, 3, 5));
        TestReplicationPolicy.assertTrue((boolean)this.containsWithinRange(targets[2], dataNodes, 3, 5));
        targets = replicator.chooseTarget(filename, 4, dataNodes[0], 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)4);
        TestReplicationPolicy.assertTrue((boolean)this.containsWithinRange(dataNodes[3], targets, 0, 3));
        TestReplicationPolicy.assertTrue((boolean)this.containsWithinRange(dataNodes[4], targets, 0, 3));
        TestReplicationPolicy.assertTrue((boolean)this.containsWithinRange(dataNodes[5], targets, 0, 3));
        for (int i = 0; i < dataNodes.length; ++i) {
            dataNodes[i].setLastUpdate(System.currentTimeMillis());
        }
        namenode.getNamesystem().heartbeatCheck();
    }

    public void testRereplicate1() throws Exception {
        ArrayList<DatanodeDescriptor> chosenNodes = new ArrayList<DatanodeDescriptor>();
        chosenNodes.add(dataNodes[0]);
        DatanodeDescriptor[] targets = replicator.chooseTarget(filename, 0, dataNodes[0], chosenNodes, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)0);
        targets = replicator.chooseTarget(filename, 1, dataNodes[0], chosenNodes, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)1);
        TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)dataNodes[0], (Node)targets[0]));
        targets = replicator.chooseTarget(filename, 2, dataNodes[0], chosenNodes, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)2);
        TestReplicationPolicy.assertTrue((boolean)cluster.isOnSameRack((Node)dataNodes[0], (Node)targets[0]));
        TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[1]));
        targets = replicator.chooseTarget(filename, 3, dataNodes[0], chosenNodes, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)3);
        TestReplicationPolicy.assertTrue((boolean)cluster.isOnSameRack((Node)dataNodes[0], (Node)targets[0]));
        TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[2]));
    }

    public void testRereplicate2() throws Exception {
        ArrayList<DatanodeDescriptor> chosenNodes = new ArrayList<DatanodeDescriptor>();
        chosenNodes.add(dataNodes[0]);
        chosenNodes.add(dataNodes[1]);
        DatanodeDescriptor[] targets = replicator.chooseTarget(filename, 0, dataNodes[0], chosenNodes, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)0);
        targets = replicator.chooseTarget(filename, 1, dataNodes[0], chosenNodes, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)1);
        TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)dataNodes[0], (Node)targets[0]));
        targets = replicator.chooseTarget(filename, 2, dataNodes[0], chosenNodes, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)2);
        TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)dataNodes[0], (Node)targets[0]));
        TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)dataNodes[0], (Node)targets[1]));
    }

    public void testRereplicate3() throws Exception {
        ArrayList<DatanodeDescriptor> chosenNodes = new ArrayList<DatanodeDescriptor>();
        chosenNodes.add(dataNodes[0]);
        chosenNodes.add(dataNodes[2]);
        DatanodeDescriptor[] targets = replicator.chooseTarget(filename, 0, dataNodes[0], chosenNodes, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)0);
        targets = replicator.chooseTarget(filename, 1, dataNodes[0], chosenNodes, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)1);
        TestReplicationPolicy.assertTrue((boolean)cluster.isOnSameRack((Node)dataNodes[0], (Node)targets[0]));
        TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)dataNodes[2], (Node)targets[0]));
        targets = replicator.chooseTarget(filename, 1, dataNodes[2], chosenNodes, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)1);
        TestReplicationPolicy.assertTrue((boolean)cluster.isOnSameRack((Node)dataNodes[2], (Node)targets[0]));
        TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)dataNodes[0], (Node)targets[0]));
        targets = replicator.chooseTarget(filename, 2, dataNodes[0], chosenNodes, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)2);
        TestReplicationPolicy.assertTrue((boolean)cluster.isOnSameRack((Node)dataNodes[0], (Node)targets[0]));
        targets = replicator.chooseTarget(filename, 2, dataNodes[2], chosenNodes, 1024L);
        TestReplicationPolicy.assertEquals((int)targets.length, (int)2);
        TestReplicationPolicy.assertTrue((boolean)cluster.isOnSameRack((Node)dataNodes[2], (Node)targets[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testChooseTargetWithMoreThanHalfStaleNodes() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.namenode.avoid.read.stale.datanode", true);
        conf.setBoolean("dfs.namenode.avoid.write.stale.datanode", true);
        long heartbeatInterval = 900L;
        conf.setLong("dfs.heartbeat.interval", heartbeatInterval);
        long longStaleInterval = 3L * heartbeatInterval * 1000L;
        conf.setLong("dfs.namenode.stale.datanode.interval", longStaleInterval);
        String[] hosts = new String[]{"host1", "host2", "host3", "host4", "host5", "host6"};
        String[] racks = new String[]{"/d1/r1", "/d1/r1", "/d1/r2", "/d1/r2", "/d2/r3", "/d2/r3"};
        MiniDFSCluster miniCluster = new MiniDFSCluster(conf, hosts.length, true, racks, hosts);
        miniCluster.waitActive();
        try {
            DataNode dn;
            int i;
            for (int i2 = 0; i2 < 2; ++i2) {
                DataNode dn2 = miniCluster.getDataNodes().get(i2);
                miniCluster.getNameNode().getNamesystem().getDatanode((DatanodeID)dn2.dnRegistration).setLastUpdate(System.currentTimeMillis() - longStaleInterval - 1L);
            }
            miniCluster.getNameNode().getNamesystem().heartbeatCheck();
            int numStaleNodes = miniCluster.getNameNode().getNamesystem().getNumStaleNodes();
            TestReplicationPolicy.assertEquals((int)numStaleNodes, (int)2);
            TestReplicationPolicy.assertTrue((boolean)miniCluster.getNameNode().getNamesystem().shouldAvoidStaleDataNodesForWrite());
            MetricsAsserts.assertGauge("StaleDataNodes", numStaleNodes, (MetricsSource)miniCluster.getNameNode().getNamesystem());
            DatanodeDescriptor staleNodeInfo = miniCluster.getNameNode().getNamesystem().getDatanode((DatanodeID)miniCluster.getDataNodes().get((int)0).dnRegistration);
            BlockPlacementPolicy replicator = miniCluster.getNameNode().getNamesystem().replicator;
            DatanodeDescriptor[] targets = replicator.chooseTarget(filename, 3, staleNodeInfo, 1024L);
            TestReplicationPolicy.assertEquals((int)targets.length, (int)3);
            TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)staleNodeInfo));
            for (i = 0; i < 4; ++i) {
                dn = miniCluster.getDataNodes().get(i);
                miniCluster.getNameNode().getNamesystem().getDatanode((DatanodeID)dn.dnRegistration).setLastUpdate(System.currentTimeMillis() - longStaleInterval - 1L);
            }
            miniCluster.getNameNode().getNamesystem().heartbeatCheck();
            numStaleNodes = miniCluster.getNameNode().getNamesystem().getNumStaleNodes();
            TestReplicationPolicy.assertEquals((int)numStaleNodes, (int)4);
            TestReplicationPolicy.assertFalse((boolean)miniCluster.getNameNode().getNamesystem().shouldAvoidStaleDataNodesForWrite());
            MetricsAsserts.assertGauge("StaleDataNodes", numStaleNodes, (MetricsSource)miniCluster.getNameNode().getNamesystem());
            targets = replicator.chooseTarget(filename, 3, staleNodeInfo, 1024L);
            TestReplicationPolicy.assertEquals((int)targets.length, (int)3);
            TestReplicationPolicy.assertTrue((boolean)cluster.isOnSameRack((Node)targets[0], (Node)staleNodeInfo));
            for (i = 2; i < 4; ++i) {
                dn = miniCluster.getDataNodes().get(i);
                miniCluster.getNameNode().getNamesystem().getDatanode((DatanodeID)dn.dnRegistration).setLastUpdate(System.currentTimeMillis());
            }
            miniCluster.getNameNode().getNamesystem().heartbeatCheck();
            numStaleNodes = miniCluster.getNameNode().getNamesystem().getNumStaleNodes();
            TestReplicationPolicy.assertEquals((int)numStaleNodes, (int)2);
            TestReplicationPolicy.assertTrue((boolean)miniCluster.getNameNode().getNamesystem().shouldAvoidStaleDataNodesForWrite());
            MetricsAsserts.assertGauge("StaleDataNodes", numStaleNodes, (MetricsSource)miniCluster.getNameNode().getNamesystem());
            targets = replicator.chooseTarget(filename, 3, staleNodeInfo, 1024L);
            TestReplicationPolicy.assertEquals((int)targets.length, (int)3);
            TestReplicationPolicy.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)staleNodeInfo));
        }
        finally {
            miniCluster.shutdown();
        }
    }

    public void testGetInvalidateWorkPctPerIteration() {
        Configuration conf = new Configuration();
        float blocksInvalidateWorkPct = DFSUtil.getInvalidateWorkPctPerIteration((Configuration)conf);
        TestReplicationPolicy.assertTrue((blocksInvalidateWorkPct > 0.0f ? 1 : 0) != 0);
        conf.set("dfs.namenode.invalidate.work.pct.per.iteration", "0.0f");
        try {
            blocksInvalidateWorkPct = DFSUtil.getInvalidateWorkPctPerIteration((Configuration)conf);
            TestReplicationPolicy.fail((String)"Should throw IllegalArgumentException.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        conf.set("dfs.namenode.invalidate.work.pct.per.iteration", "1.5f");
        try {
            blocksInvalidateWorkPct = DFSUtil.getInvalidateWorkPctPerIteration((Configuration)conf);
            TestReplicationPolicy.fail((String)"Should throw IllegalArgumentException.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        conf.set("dfs.namenode.invalidate.work.pct.per.iteration", "-0.5f");
        try {
            blocksInvalidateWorkPct = DFSUtil.getInvalidateWorkPctPerIteration((Configuration)conf);
            TestReplicationPolicy.fail((String)"Should throw IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        conf.set("dfs.namenode.invalidate.work.pct.per.iteration", "0.5f");
        blocksInvalidateWorkPct = DFSUtil.getInvalidateWorkPctPerIteration((Configuration)conf);
        TestReplicationPolicy.assertEquals((Object)Float.valueOf(blocksInvalidateWorkPct), (Object)Float.valueOf(0.5f));
    }

    public void testGetReplWorkMultiplier() {
        Configuration conf = new Configuration();
        int blocksReplWorkMultiplier = DFSUtil.getReplWorkMultiplier((Configuration)conf);
        TestReplicationPolicy.assertTrue((blocksReplWorkMultiplier > 0 ? 1 : 0) != 0);
        conf.set("dfs.namenode.replication.work.multiplier.per.iteration", "-1");
        try {
            blocksReplWorkMultiplier = DFSUtil.getReplWorkMultiplier((Configuration)conf);
            TestReplicationPolicy.fail((String)"Should throw IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        conf.set("dfs.namenode.replication.work.multiplier.per.iteration", "3");
        blocksReplWorkMultiplier = DFSUtil.getReplWorkMultiplier((Configuration)conf);
        TestReplicationPolicy.assertEquals((int)blocksReplWorkMultiplier, (int)3);
    }

    public void testChooseReplicaToDelete() throws Exception {
        ArrayList<DatanodeDescriptor> replicaNodeList = new ArrayList<DatanodeDescriptor>();
        HashMap rackMap = new HashMap();
        dataNodes[0].setRemaining(0x400000L);
        replicaNodeList.add(dataNodes[0]);
        dataNodes[1].setRemaining(0x300000L);
        replicaNodeList.add(dataNodes[1]);
        dataNodes[2].setRemaining(0x200000L);
        replicaNodeList.add(dataNodes[2]);
        dataNodes[5].setRemaining(0x100000L);
        replicaNodeList.add(dataNodes[5]);
        ArrayList first = new ArrayList();
        ArrayList second = new ArrayList();
        replicator.splitNodesWithRack(replicaNodeList, rackMap, first, second);
        TestReplicationPolicy.assertEquals((int)2, (int)first.size());
        TestReplicationPolicy.assertEquals((int)2, (int)second.size());
        DatanodeDescriptor chosenNode = replicator.chooseReplicaToDelete(null, null, (short)3, first, second);
        TestReplicationPolicy.assertEquals((Object)chosenNode, (Object)dataNodes[1]);
        replicator.adjustSetsWithChosenReplica(rackMap, first, second, (DatanodeInfo)chosenNode);
        TestReplicationPolicy.assertEquals((int)0, (int)first.size());
        TestReplicationPolicy.assertEquals((int)3, (int)second.size());
        chosenNode = replicator.chooseReplicaToDelete(null, null, (short)2, first, second);
        TestReplicationPolicy.assertEquals((Object)chosenNode, (Object)dataNodes[5]);
    }

    static {
        int i;
        CONF = new Configuration();
        dataNodes = new DatanodeDescriptor[]{new DatanodeDescriptor(new DatanodeID("h1:5020"), "/d1/r1"), new DatanodeDescriptor(new DatanodeID("h2:5020"), "/d1/r1"), new DatanodeDescriptor(new DatanodeID("h3:5020"), "/d1/r2"), new DatanodeDescriptor(new DatanodeID("h4:5020"), "/d1/r2"), new DatanodeDescriptor(new DatanodeID("h5:5020"), "/d2/r3"), new DatanodeDescriptor(new DatanodeID("h6:5020"), "/d2/r3")};
        NODE = new DatanodeDescriptor(new DatanodeID("h7:5020"), "/d2/r4");
        try {
            FileSystem.setDefaultUri((Configuration)CONF, (String)"hdfs://localhost:0");
            CONF.set("dfs.http.address", "0.0.0.0:0");
            CONF.setBoolean("dfs.namenode.avoid.write.stale.datanode", true);
            NameNode.format((Configuration)CONF);
            namenode = new NameNode(CONF);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
        FSNamesystem fsNamesystem = FSNamesystem.getFSNamesystem();
        replicator = fsNamesystem.replicator;
        cluster = fsNamesystem.clusterMap;
        ArrayList heartbeats = fsNamesystem.heartbeats;
        for (i = 0; i < 6; ++i) {
            TestReplicationPolicy.dataNodes[i].isAlive = true;
            cluster.add((Node)dataNodes[i]);
            heartbeats.add(dataNodes[i]);
        }
        for (i = 0; i < 6; ++i) {
            dataNodes[i].updateHeartbeat(10240L, 0L, 10240L, 0);
        }
    }

    class TestAppender
    extends AppenderSkeleton {
        private final List<LoggingEvent> log = new ArrayList<LoggingEvent>();

        TestAppender() {
        }

        public boolean requiresLayout() {
            return false;
        }

        protected void append(LoggingEvent loggingEvent) {
            this.log.add(loggingEvent);
        }

        public void close() {
        }

        public List<LoggingEvent> getLog() {
            return new ArrayList<LoggingEvent>(this.log);
        }
    }
}

