/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.namenode.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;

public class TestUnderReplicatedBlocks
extends TestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetrepIncWithUnderReplicatedBlocks() throws Exception {
        Configuration conf = new Configuration();
        int REPLICATION_FACTOR = 2;
        String FILE_NAME = "/testFile";
        Path FILE_PATH = new Path("/testFile");
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 3, true, null);
        try {
            FileSystem fs = cluster.getFileSystem();
            DFSTestUtil.createFile(fs, FILE_PATH, 1L, (short)2, 1L);
            DFSTestUtil.waitReplication(fs, FILE_PATH, (short)2);
            FSNamesystem namesystem = cluster.getNameNode().getNamesystem();
            Block b = DFSTestUtil.getFirstBlock(fs, FILE_PATH);
            DatanodeDescriptor dn = (DatanodeDescriptor)namesystem.blocksMap.nodeIterator(b).next();
            namesystem.addToInvalidates(b, (DatanodeInfo)dn);
            namesystem.blocksMap.removeNode(b, dn);
            FsShell shell = new FsShell(conf);
            TestUnderReplicatedBlocks.assertEquals((int)0, (int)shell.run(new String[]{"-setrep", "-w", Integer.toString(3), "/testFile"}));
        }
        finally {
            cluster.shutdown();
        }
    }
}

