/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.text.ParseException;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.Task;

public class TestCounters
extends TestCase {
    private static final long MAX_VALUE = 10L;

    private Counters getEnumCounters(Enum[] keys) {
        Counters counters = new Counters();
        for (Enum key : keys) {
            for (long i = 0L; i < 10L; ++i) {
                counters.incrCounter(key, i);
            }
        }
        return counters;
    }

    private Counters getEnumCounters(String[] gNames, String[] cNames) {
        Counters counters = new Counters();
        for (String gName : gNames) {
            for (String cName : cNames) {
                for (long i = 0L; i < 10L; ++i) {
                    counters.incrCounter(gName, cName, i);
                }
            }
        }
        return counters;
    }

    private void testCounter(Counters counter) throws ParseException {
        String compactEscapedString = counter.makeEscapedCompactString();
        Counters recoveredCounter = Counters.fromEscapedCompactString((String)compactEscapedString);
        TestCounters.assertEquals((String)"Recovered counter does not match on content", (Object)counter, (Object)recoveredCounter);
        TestCounters.assertEquals((String)"recovered counter has wrong hash code", (int)counter.hashCode(), (int)recoveredCounter.hashCode());
    }

    public void testCounters() throws IOException {
        Enum[] keysWithResource = new Enum[]{Task.Counter.MAP_INPUT_BYTES, Task.Counter.MAP_OUTPUT_BYTES};
        Enum[] keysWithoutResource = new Enum[]{myCounters.TEST1, myCounters.TEST2};
        String[] groups = new String[]{"group1", "group2", "group{}()[]"};
        String[] counters = new String[]{"counter1", "counter2", "counter{}()[]"};
        try {
            this.testCounter(this.getEnumCounters(keysWithResource));
            this.testCounter(this.getEnumCounters(keysWithoutResource));
            this.testCounter(this.getEnumCounters(groups, counters));
        }
        catch (ParseException pe) {
            throw new IOException(pe);
        }
    }

    public void testCounterValue() {
        int NUMBER_TESTS = 100;
        int NUMBER_INC = 10;
        Random rand = new Random();
        for (int i = 0; i < 100; ++i) {
            long initValue;
            long expectedValue = initValue = (long)rand.nextInt();
            Counters.Counter counter = new Counters.Counter("foo", "bar", expectedValue);
            TestCounters.assertEquals((String)"Counter value is not initialized correctly", (long)expectedValue, (long)counter.getValue());
            for (int j = 0; j < 10; ++j) {
                int incValue = rand.nextInt();
                counter.increment((long)incValue);
                TestCounters.assertEquals((String)"Counter value is not incremented correctly", (long)(expectedValue += (long)incValue), (long)counter.getValue());
            }
            expectedValue = rand.nextInt();
            counter.setValue(expectedValue);
            TestCounters.assertEquals((String)"Counter value is not set correctly", (long)expectedValue, (long)counter.getValue());
        }
    }

    public static void main(String[] args) throws IOException {
        new TestCounters().testCounters();
    }

    static enum myCounters {
        TEST1,
        TEST2;

    }
}

