/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.QueueMetrics;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.test.MetricsAsserts;
import org.mockito.Mockito;

public class TestQueueMetrics
extends TestCase {
    QueueMetrics metrics = (QueueMetrics)Mockito.mock(QueueMetrics.class);
    static int jobIdCounter = 0;
    static final String jtIdentifier = "queue_jt";

    private static JobID getJobId() {
        return new JobID(jtIdentifier, jobIdCounter++);
    }

    public void testDefaultSingleQueueMetrics() {
        String queueName = "single";
        TaskAttemptID taskAttemptID = (TaskAttemptID)Mockito.mock(TaskAttemptID.class);
        Mockito.when((Object)taskAttemptID.getJobID()).thenReturn((Object)TestQueueMetrics.getJobId());
        QueueMetrics metrics = QueueMetrics.create((String)queueName, (Configuration)new Configuration());
        TestQueueMetrics.assertEquals((String)metrics.getQueueName(), (String)"single");
        metrics.launchMap(taskAttemptID);
        TestQueueMetrics.checkMaps(metrics, 1, 0, 0, 0, -1, 0);
        metrics.addWaitingMaps(taskAttemptID.getJobID(), 5);
        metrics.launchMap(taskAttemptID);
        TestQueueMetrics.checkMaps(metrics, 2, 0, 0, 0, 3, 0);
        TestQueueMetrics.checkReduces(metrics, 0, 0, 0, 0, 0, 0);
        metrics.completeMap(taskAttemptID);
        metrics.failedMap(taskAttemptID);
        TestQueueMetrics.checkMaps(metrics, 2, 1, 1, 0, 4, 0);
        TestQueueMetrics.checkReduces(metrics, 0, 0, 0, 0, 0, 0);
        metrics.launchReduce(taskAttemptID);
        metrics.completeReduce(taskAttemptID);
        metrics.failedReduce(taskAttemptID);
        TestQueueMetrics.checkMaps(metrics, 2, 1, 1, 0, 4, 0);
        TestQueueMetrics.checkReduces(metrics, 1, 1, 1, 0, 0, 0);
        metrics.addWaitingMaps(null, 20);
        metrics.decWaitingMaps(null, 10);
        metrics.addWaitingReduces(null, 20);
        metrics.decWaitingReduces(null, 10);
        TestQueueMetrics.checkMaps(metrics, 2, 1, 1, 0, 14, 0);
        TestQueueMetrics.checkReduces(metrics, 1, 1, 1, 0, 10, 0);
        metrics.addReservedMapSlots(10);
        metrics.addReservedReduceSlots(10);
        TestQueueMetrics.checkMaps(metrics, 2, 1, 1, 0, 14, 10);
        TestQueueMetrics.checkReduces(metrics, 1, 1, 1, 0, 10, 10);
        metrics.decReservedReduceSlots(5);
        metrics.decReservedMapSlots(5);
        TestQueueMetrics.checkMaps(metrics, 2, 1, 1, 0, 14, 5);
        TestQueueMetrics.checkReduces(metrics, 1, 1, 1, 0, 10, 5);
        metrics.killedMap(taskAttemptID);
        metrics.killedReduce(taskAttemptID);
        TestQueueMetrics.checkMaps(metrics, 2, 1, 1, 1, 14, 5);
        TestQueueMetrics.checkReduces(metrics, 1, 1, 1, 1, 10, 5);
        TestQueueMetrics.checkJobs(metrics, 0, 0, 0, 0, 0, 0);
        metrics.submitJob(null, null);
        metrics.completeJob(null, null);
        metrics.failedJob(null, null);
        metrics.killedJob(null, null);
        TestQueueMetrics.checkJobs(metrics, 1, 1, 1, 1, 0, 0);
        metrics.addPrepJob(null, null);
        metrics.addRunningJob(null, null);
        metrics.addPrepJob(null, null);
        metrics.addRunningJob(null, null);
        TestQueueMetrics.checkJobs(metrics, 1, 1, 1, 1, 2, 2);
        metrics.decPrepJob(null, null);
        metrics.decRunningJob(null, null);
        TestQueueMetrics.checkJobs(metrics, 1, 1, 1, 1, 1, 1);
        TestQueueMetrics.checkMaps(metrics, 2, 1, 1, 1, 14, 5);
        TestQueueMetrics.checkReduces(metrics, 1, 1, 1, 1, 10, 5);
    }

    public static void checkMaps(QueueMetrics metrics, int maps_launched, int maps_completed, int maps_failed, int maps_killed, int waiting_maps, int reserved_map_slots) {
        MetricsAsserts.assertCounter("maps_launched", maps_launched, (MetricsSource)metrics);
        MetricsAsserts.assertCounter("maps_completed", maps_completed, (MetricsSource)metrics);
        MetricsAsserts.assertCounter("maps_failed", maps_failed, (MetricsSource)metrics);
        MetricsAsserts.assertCounter("maps_killed", maps_killed, (MetricsSource)metrics);
        MetricsAsserts.assertGauge("waiting_maps", waiting_maps, (MetricsSource)metrics);
        MetricsAsserts.assertGauge("reserved_map_slots", reserved_map_slots, (MetricsSource)metrics);
    }

    public static void checkReduces(QueueMetrics metrics, int reduces_launched, int reduces_completed, int reduces_failed, int reduces_killed, int waiting_reduces, int reserved_reduce_slots) {
        MetricsAsserts.assertCounter("reduces_launched", reduces_launched, (MetricsSource)metrics);
        MetricsAsserts.assertCounter("reduces_completed", reduces_completed, (MetricsSource)metrics);
        MetricsAsserts.assertCounter("reduces_failed", reduces_failed, (MetricsSource)metrics);
        MetricsAsserts.assertCounter("reduces_killed", reduces_killed, (MetricsSource)metrics);
        MetricsAsserts.assertGauge("waiting_reduces", waiting_reduces, (MetricsSource)metrics);
        MetricsAsserts.assertGauge("reserved_reduce_slots", reserved_reduce_slots, (MetricsSource)metrics);
    }

    public static void checkJobs(QueueMetrics metrics, int jobs_submitted, int jobs_completed, int jobs_failed, int jobs_killed, int jobs_preparing, int jobs_running) {
        MetricsAsserts.assertCounter("jobs_submitted", jobs_submitted, (MetricsSource)metrics);
        MetricsAsserts.assertCounter("jobs_completed", jobs_completed, (MetricsSource)metrics);
        MetricsAsserts.assertCounter("jobs_failed", jobs_failed, (MetricsSource)metrics);
        MetricsAsserts.assertCounter("jobs_killed", jobs_killed, (MetricsSource)metrics);
        MetricsAsserts.assertGauge("jobs_preparing", jobs_preparing, (MetricsSource)metrics);
        MetricsAsserts.assertGauge("jobs_running", jobs_running, (MetricsSource)metrics);
    }
}

