/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.hadoop.mapred.ShuffleExceptionTracker;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestShuffleExceptionCount {
    static boolean abortCalled = false;
    private final float epsilon = 1.0E-5f;

    @BeforeClass
    public static void initialize() throws Exception {
        abortCalled = false;
    }

    @Test
    public void testCheckException() throws IOException, InterruptedException {
        String exceptionMsgRegex = "Broken pipe";
        String exceptionStackRegex = null;
        TestShuffleExceptionTracker shuffleExceptionTracker = new TestShuffleExceptionTracker(10, exceptionStackRegex, exceptionMsgRegex, 0.0f);
        IOException ie = new IOException("EOFException");
        shuffleExceptionTracker.checkException(ie);
        Assert.assertFalse((String)"abort called when set to off", (boolean)abortCalled);
        ie = new IOException("Broken pipe");
        exceptionStackRegex = null;
        shuffleExceptionTracker = new TestShuffleExceptionTracker(10, exceptionStackRegex, exceptionMsgRegex, 0.0f);
        shuffleExceptionTracker.checkException(ie);
        Assert.assertFalse((String)"abort called when set to off", (boolean)abortCalled);
        exceptionMsgRegex = null;
        exceptionStackRegex = null;
        shuffleExceptionTracker = new TestShuffleExceptionTracker(10, exceptionStackRegex, exceptionMsgRegex, 0.0f);
        shuffleExceptionTracker.checkException(ie);
        Assert.assertFalse((String)"abort called when set to off", (boolean)abortCalled);
        exceptionMsgRegex = null;
        exceptionStackRegex = ".*\\.doesnt\\$SelectSet\\.wakeup.*";
        ie.setStackTrace(this.constructStackTrace());
        shuffleExceptionTracker = new TestShuffleExceptionTracker(10, exceptionStackRegex, exceptionMsgRegex, 0.0f);
        shuffleExceptionTracker.checkException(ie);
        Assert.assertFalse((String)"abort called when set to off", (boolean)abortCalled);
        exceptionMsgRegex = null;
        exceptionStackRegex = ".*\\.SelectorManager\\$SelectSet\\.wakeup.*";
        shuffleExceptionTracker = new TestShuffleExceptionTracker(10, exceptionStackRegex, exceptionMsgRegex, 0.3f);
        shuffleExceptionTracker.checkException(ie);
        Assert.assertFalse((String)"abort called when set to off", (boolean)abortCalled);
        exceptionMsgRegex = "Broken pipe";
        ie.setStackTrace(this.constructStackTraceTwo());
        shuffleExceptionTracker = new TestShuffleExceptionTracker(10, exceptionStackRegex, exceptionMsgRegex, 0.3f);
        shuffleExceptionTracker.checkException(ie);
        Assert.assertFalse((String)"abort called when set to off", (boolean)abortCalled);
        exceptionStackRegex = ".*[1-9]+BOGUSREGEX";
        shuffleExceptionTracker = new TestShuffleExceptionTracker(10, exceptionStackRegex, exceptionMsgRegex, 0.3f);
        shuffleExceptionTracker.checkException(ie);
        Assert.assertFalse((String)"abort called when set to off", (boolean)abortCalled);
        exceptionStackRegex = ".*\\.SelectorManager\\$SelectSet\\.wakeup.*";
        exceptionMsgRegex = "EOFException";
        shuffleExceptionTracker = new TestShuffleExceptionTracker(10, exceptionStackRegex, exceptionMsgRegex, 0.3f);
        shuffleExceptionTracker.checkException(ie);
        Assert.assertFalse((String)"abort called when set to off", (boolean)abortCalled);
        exceptionMsgRegex = "Broken pipe";
        ie.setStackTrace(this.constructStackTraceTwo());
        shuffleExceptionTracker = new TestShuffleExceptionTracker(10, exceptionStackRegex, exceptionMsgRegex, 0.3f);
        shuffleExceptionTracker.checkException(ie);
        Assert.assertFalse((String)"abort called when set to off", (boolean)abortCalled);
    }

    @Test
    public void testExceptionCount() {
        String exceptionMsgRegex = "Broken pipe";
        String exceptionStackRegex = ".*\\.SelectorManager\\$SelectSet\\.wakeup.*";
        IOException ie = new IOException("Broken pipe");
        ie.setStackTrace(this.constructStackTraceTwo());
        TestShuffleExceptionTracker shuffleExceptionTracker = new TestShuffleExceptionTracker(10, exceptionStackRegex, exceptionMsgRegex, 0.3f);
        shuffleExceptionTracker.checkException(ie);
        Assert.assertFalse((String)"abort called when set to off", (boolean)abortCalled);
        Assert.assertEquals((String)"shuffleExceptionCount wrong", (double)0.1f, (double)shuffleExceptionTracker.getPercentExceptions(), (double)1.0E-5f);
        ie.setStackTrace(this.constructStackTraceThree());
        shuffleExceptionTracker.checkException(ie);
        Assert.assertFalse((String)"abort called when set to off", (boolean)abortCalled);
        Assert.assertEquals((String)"shuffleExceptionCount wrong", (double)0.1f, (double)shuffleExceptionTracker.getPercentExceptions(), (double)1.0E-5f);
        shuffleExceptionTracker.checkException(ie);
        Assert.assertFalse((String)"abort called when set to off", (boolean)abortCalled);
        Assert.assertEquals((String)"shuffleExceptionCount wrong", (double)0.1f, (double)shuffleExceptionTracker.getPercentExceptions(), (double)1.0E-5f);
        ie.setStackTrace(this.constructStackTrace());
        shuffleExceptionTracker.checkException(ie);
        Assert.assertFalse((String)"abort called when set to off", (boolean)abortCalled);
        Assert.assertEquals((String)"shuffleExceptionCount wrong", (double)0.2f, (double)shuffleExceptionTracker.getPercentExceptions(), (double)1.0E-5f);
        shuffleExceptionTracker.checkException(ie);
        Assert.assertTrue((String)"abort not called", (boolean)abortCalled);
        Assert.assertEquals((String)"shuffleExceptionCount wrong", (double)0.3f, (double)shuffleExceptionTracker.getPercentExceptions(), (double)1.0E-5f);
    }

    @Test
    public void testShuffleExceptionTrailing() {
        String exceptionStackRegex = ".*\\.SelectorManager\\$SelectSet\\.wakeup.*";
        String exceptionMsgRegex = "Broken pipe";
        int size = 5;
        ShuffleExceptionTracker tracker = new ShuffleExceptionTracker(size, exceptionStackRegex, exceptionMsgRegex, 0.3f);
        Assert.assertEquals((long)size, (long)tracker.getNumRequests());
        Assert.assertEquals((double)0.0, (double)tracker.getPercentExceptions(), (double)0.0);
        tracker.success();
        Assert.assertEquals((double)0.0, (double)tracker.getPercentExceptions(), (double)0.0);
        tracker.exception();
        Assert.assertEquals((double)(1.0f / (float)size), (double)tracker.getPercentExceptions(), (double)1.0E-5f);
        tracker.exception();
        tracker.exception();
        Assert.assertEquals((double)(3.0f / (float)size), (double)tracker.getPercentExceptions(), (double)1.0E-5f);
        tracker.exception();
        tracker.exception();
        tracker.exception();
        tracker.exception();
        Assert.assertEquals((double)(5.0f / (float)size), (double)tracker.getPercentExceptions(), (double)1.0E-5f);
        tracker.success();
        tracker.success();
        Assert.assertEquals((double)(3.0f / (float)size), (double)tracker.getPercentExceptions(), (double)1.0E-5f);
        tracker.exception();
        tracker.exception();
        tracker.exception();
        tracker.exception();
        tracker.exception();
        Assert.assertEquals((double)(5.0f / (float)size), (double)tracker.getPercentExceptions(), (double)1.0E-5f);
    }

    @Test
    public void testShuffleExceptionTrailingSize() {
        String exceptionStackRegex = ".*\\.SelectorManager\\$SelectSet\\.wakeup.*";
        String exceptionMsgRegex = "Broken pipe";
        int size = 1000;
        ShuffleExceptionTracker tracker = new ShuffleExceptionTracker(size, exceptionStackRegex, exceptionMsgRegex, 0.3f);
        Assert.assertEquals((long)size, (long)tracker.getNumRequests());
        tracker.success();
        tracker.success();
        tracker.exception();
        tracker.exception();
        Assert.assertEquals((double)(2.0f / (float)size), (double)tracker.getPercentExceptions(), (double)1.0E-5f);
    }

    private StackTraceElement[] constructStackTrace() {
        StackTraceElement[] stack = new StackTraceElement[]{new StackTraceElement("sun.nio.ch.EPollArrayWrapper", "interrupt", "", -2), new StackTraceElement("sun.nio.ch.EPollArrayWrapper", "interrupt", "EPollArrayWrapper.java", 256), new StackTraceElement("sun.nio.ch.EPollSelectorImpl", "wakeup", "EPollSelectorImpl.java", 175), new StackTraceElement("org.mortbay.io.nio.SelectorManager$SelectSet", "wakeup", "SelectorManager.java", 831), new StackTraceElement("org.mortbay.io.nio.SelectorManager$SelectSet", "doSelect", "SelectorManager.java", 709), new StackTraceElement("org.mortbay.io.nio.SelectorManager", "doSelect", "SelectorManager.java", 192), new StackTraceElement("org.mortbay.jetty.nio.SelectChannelConnector", "accept", "SelectChannelConnector.java", 124), new StackTraceElement("org.mortbay.jetty.AbstractConnector$Acceptor", "run", "AbstractConnector.java", 708), new StackTraceElement("org.mortbay.thread.QueuedThreadPool$PoolThread", "run", "QueuedThreadPool.java", 582)};
        return stack;
    }

    private StackTraceElement[] constructStackTraceTwo() {
        StackTraceElement[] stack = new StackTraceElement[]{new StackTraceElement("sun.nio.ch.EPollArrayWrapper", "interrupt", "", -2), new StackTraceElement("sun.nio.ch.EPollArrayWrapper", "interrupt", "EPollArrayWrapper.java", 256), new StackTraceElement("sun.nio.ch.EPollSelectorImpl", "wakeup", "EPollSelectorImpl.java", 175), new StackTraceElement("org.mortbay.io.nio.SelectorManager$SelectSet", "wakeup", "SelectorManager.java", 831), new StackTraceElement("org.mortbay.io.nio.SelectChannelEndPoint", "updateKey", "SelectChannelEndPoint.java", 335), new StackTraceElement("org.mortbay.io.nio.SelectChannelEndPoint", "blockWritable", "SelectChannelEndPoint.java", 278), new StackTraceElement("org.mortbay.jetty.AbstractGenerator$Output", "blockForOutput", "AbstractGenerator.java", 545), new StackTraceElement("org.mortbay.jetty.AbstractGenerator$Output", "flush", "AbstractGenerator.java", 572), new StackTraceElement("org.mortbay.jetty.HttpConnection$Output", "flush", "HttpConnection.java", 1012), new StackTraceElement("org.mortbay.jetty.AbstractGenerator$Output", "write", "AbstractGenerator.java", 651), new StackTraceElement("org.mortbay.jetty.AbstractGenerator$Output", "write", "AbstractGenerator.java", 580)};
        return stack;
    }

    private StackTraceElement[] constructStackTraceThree() {
        StackTraceElement[] stack = new StackTraceElement[]{new StackTraceElement("sun.nio.ch.EPollArrayWrapper", "interrupt", "", -2), new StackTraceElement("sun.nio.ch.EPollArrayWrapper", "interrupt", "EPollArrayWrapper.java", 256), new StackTraceElement("sun.nio.ch.EPollSelectorImpl", "wakeup", "EPollSelectorImpl.java", 175)};
        return stack;
    }

    public static class TestShuffleExceptionTracker
    extends ShuffleExceptionTracker {
        private static final long serialVersionUID = 1L;

        TestShuffleExceptionTracker(int size, String exceptionStackRegex, String exceptionMsgRegex, float shuffleExceptionLimit) {
            super(size, exceptionStackRegex, exceptionMsgRegex, shuffleExceptionLimit);
        }

        protected void doAbort() {
            abortCalled = true;
        }
    }
}

