/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.KillJobAction;
import org.apache.hadoop.mapred.KillTaskAction;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.mapred.TaskTrackerAction;
import org.junit.Before;
import org.junit.Test;

public class TestTaskTrackerActionCleanup
extends TestCase {
    String jtIdentifier = "201210122331";
    TestTaskTracker tt = null;

    @Before
    public void setUp() {
        this.tt = new TestTaskTracker();
    }

    @Test
    public void testDuplicateEntries() throws InterruptedException {
        KillJobAction action = new KillJobAction();
        this.tt.addActionToCleanup((TaskTrackerAction)action);
        this.tt.addActionToCleanup((TaskTrackerAction)action);
        this.checkItemCountInQueue(this.tt, 1, 1, 0);
    }

    @Test
    public void testLocalizingJobActions() throws InterruptedException, IOException {
        JobID jobId1 = new JobID(this.jtIdentifier, 1);
        JobID jobId2 = new JobID(this.jtIdentifier, 2);
        TaskAttemptID taskAttemptId1 = new TaskAttemptID(this.jtIdentifier, 3, true, 1, 1);
        TaskAttemptID taskAttemptId2 = new TaskAttemptID(this.jtIdentifier, 4, true, 1, 1);
        KillJobAction jAction1 = new KillJobAction(jobId1);
        TaskTracker.RunningJob rjob1 = new TaskTracker.RunningJob(jAction1.getJobID());
        rjob1.localizing = true;
        this.tt.runningJobs.put(jobId1, rjob1);
        this.tt.addActionToCleanup((TaskTrackerAction)jAction1);
        KillJobAction jAction2 = new KillJobAction(jobId2);
        TaskTracker.RunningJob rjob2 = new TaskTracker.RunningJob(jAction2.getJobID());
        rjob2.localizing = true;
        this.tt.runningJobs.put(jobId2, rjob2);
        this.tt.addActionToCleanup((TaskTrackerAction)jAction2);
        KillTaskAction tAction1 = new KillTaskAction(taskAttemptId1);
        TaskTracker.RunningJob rjob3 = new TaskTracker.RunningJob(tAction1.getTaskID().getJobID());
        this.tt.runningJobs.put(rjob3.getJobID(), rjob3);
        rjob3.localizing = true;
        this.tt.addActionToCleanup((TaskTrackerAction)tAction1);
        KillTaskAction tAction2 = new KillTaskAction(taskAttemptId2);
        TaskTracker.RunningJob rjob4 = new TaskTracker.RunningJob(tAction2.getTaskID().getJobID());
        rjob4.localizing = true;
        this.tt.runningJobs.put(rjob4.getJobID(), rjob4);
        this.tt.addActionToCleanup((TaskTrackerAction)tAction2);
        this.checkItemCountInQueue(this.tt, 4, 4, 0);
        this.tt.taskCleanUp();
        this.checkItemCountInQueue(this.tt, 4, 3, 1);
        this.tt.taskCleanUp();
        this.checkItemCountInQueue(this.tt, 4, 2, 2);
        this.tt.taskCleanUp();
        this.checkItemCountInQueue(this.tt, 4, 1, 3);
        this.tt.taskCleanUp();
        this.checkItemCountInQueue(this.tt, 4, 0, 4);
        this.tt.taskCleanUp();
        this.checkItemCountInQueue(this.tt, 4, 0, 4);
    }

    @Test
    public void testAllActiveJobActions() throws InterruptedException, IOException {
        JobID jobId1 = new JobID(this.jtIdentifier, 1);
        JobID jobId2 = new JobID(this.jtIdentifier, 2);
        TaskAttemptID taskAttemptId1 = new TaskAttemptID(this.jtIdentifier, 3, true, 1, 1);
        TaskAttemptID taskAttemptId2 = new TaskAttemptID(this.jtIdentifier, 4, true, 1, 1);
        KillJobAction jAction1 = new KillJobAction(jobId1);
        TaskTracker.RunningJob rjob1 = new TaskTracker.RunningJob(jAction1.getJobID());
        rjob1.localizing = false;
        this.tt.runningJobs.put(jobId1, rjob1);
        this.tt.addActionToCleanup((TaskTrackerAction)jAction1);
        KillJobAction jAction2 = new KillJobAction(jobId2);
        TaskTracker.RunningJob rjob2 = new TaskTracker.RunningJob(jAction2.getJobID());
        rjob2.localizing = false;
        this.tt.runningJobs.put(jobId2, rjob2);
        this.tt.addActionToCleanup((TaskTrackerAction)jAction2);
        KillTaskAction tAction1 = new KillTaskAction(taskAttemptId1);
        TaskTracker.RunningJob rjob3 = new TaskTracker.RunningJob(tAction1.getTaskID().getJobID());
        this.tt.runningJobs.put(rjob3.getJobID(), rjob3);
        rjob3.localizing = false;
        this.tt.addActionToCleanup((TaskTrackerAction)tAction1);
        KillTaskAction tAction2 = new KillTaskAction(taskAttemptId2);
        TaskTracker.RunningJob rjob4 = new TaskTracker.RunningJob(tAction2.getTaskID().getJobID());
        rjob4.localizing = false;
        this.tt.runningJobs.put(rjob4.getJobID(), rjob4);
        this.tt.addActionToCleanup((TaskTrackerAction)tAction2);
        this.checkItemCountInQueue(this.tt, 4, 4, 0);
        this.tt.taskCleanUp();
        this.checkItemCountInQueue(this.tt, 3, 3, 0);
        this.tt.taskCleanUp();
        this.checkItemCountInQueue(this.tt, 2, 2, 0);
        this.tt.taskCleanUp();
        this.checkItemCountInQueue(this.tt, 1, 1, 0);
        this.tt.taskCleanUp();
        this.checkItemCountInQueue(this.tt, 0, 0, 0);
        this.tt.taskCleanUp();
        this.checkItemCountInQueue(this.tt, 0, 0, 0);
    }

    @Test
    public void testMixedJobActions() throws InterruptedException, IOException {
        JobID jobId1 = new JobID(this.jtIdentifier, 1);
        JobID jobId2 = new JobID(this.jtIdentifier, 2);
        TaskAttemptID taskAttemptId1 = new TaskAttemptID(this.jtIdentifier, 3, true, 1, 1);
        TaskAttemptID taskAttemptId2 = new TaskAttemptID(this.jtIdentifier, 4, true, 1, 1);
        KillJobAction jAction1 = new KillJobAction(jobId1);
        TaskTracker.RunningJob rjob1 = new TaskTracker.RunningJob(jAction1.getJobID());
        rjob1.localizing = true;
        this.tt.runningJobs.put(jobId1, rjob1);
        this.tt.addActionToCleanup((TaskTrackerAction)jAction1);
        KillJobAction jAction2 = new KillJobAction(jobId2);
        TaskTracker.RunningJob rjob2 = new TaskTracker.RunningJob(jAction2.getJobID());
        rjob2.localizing = false;
        this.tt.runningJobs.put(jobId2, rjob2);
        this.tt.addActionToCleanup((TaskTrackerAction)jAction2);
        KillTaskAction tAction1 = new KillTaskAction(taskAttemptId1);
        TaskTracker.RunningJob rjob3 = new TaskTracker.RunningJob(tAction1.getTaskID().getJobID());
        this.tt.runningJobs.put(rjob3.getJobID(), rjob3);
        rjob3.localizing = true;
        this.tt.addActionToCleanup((TaskTrackerAction)tAction1);
        KillTaskAction tAction2 = new KillTaskAction(taskAttemptId2);
        TaskTracker.RunningJob rjob4 = new TaskTracker.RunningJob(tAction2.getTaskID().getJobID());
        rjob4.localizing = false;
        this.tt.runningJobs.put(rjob4.getJobID(), rjob4);
        this.tt.addActionToCleanup((TaskTrackerAction)tAction2);
        this.checkItemCountInQueue(this.tt, 4, 4, 0);
        this.tt.taskCleanUp();
        this.checkItemCountInQueue(this.tt, 4, 3, 1);
        this.tt.taskCleanUp();
        this.checkItemCountInQueue(this.tt, 3, 2, 1);
        this.tt.taskCleanUp();
        this.checkItemCountInQueue(this.tt, 3, 1, 2);
        this.tt.taskCleanUp();
        this.checkItemCountInQueue(this.tt, 2, 0, 2);
        this.tt.taskCleanUp();
        this.checkItemCountInQueue(this.tt, 2, 0, 2);
    }

    @Test
    public void testMixedJobActionsAndUpdateActions() throws InterruptedException, IOException {
        JobID jobId1 = new JobID(this.jtIdentifier, 1);
        JobID jobId2 = new JobID(this.jtIdentifier, 2);
        TaskAttemptID taskAttemptId1 = new TaskAttemptID(this.jtIdentifier, 3, true, 1, 1);
        TaskAttemptID taskAttemptId2 = new TaskAttemptID(this.jtIdentifier, 4, true, 1, 1);
        KillJobAction jAction1 = new KillJobAction(jobId1);
        TaskTracker.RunningJob rjob1 = new TaskTracker.RunningJob(jAction1.getJobID());
        rjob1.localizing = true;
        this.tt.runningJobs.put(jobId1, rjob1);
        this.tt.addActionToCleanup((TaskTrackerAction)jAction1);
        KillJobAction jAction2 = new KillJobAction(jobId2);
        TaskTracker.RunningJob rjob2 = new TaskTracker.RunningJob(jAction2.getJobID());
        rjob2.localizing = false;
        this.tt.runningJobs.put(jobId2, rjob2);
        this.tt.addActionToCleanup((TaskTrackerAction)jAction2);
        KillTaskAction tAction1 = new KillTaskAction(taskAttemptId1);
        TaskTracker.RunningJob rjob3 = new TaskTracker.RunningJob(tAction1.getTaskID().getJobID());
        this.tt.runningJobs.put(rjob3.getJobID(), rjob3);
        rjob3.localizing = true;
        this.tt.addActionToCleanup((TaskTrackerAction)tAction1);
        KillTaskAction tAction2 = new KillTaskAction(taskAttemptId2);
        TaskTracker.RunningJob rjob4 = new TaskTracker.RunningJob(tAction2.getTaskID().getJobID());
        rjob4.localizing = false;
        this.tt.runningJobs.put(rjob4.getJobID(), rjob4);
        this.tt.addActionToCleanup((TaskTrackerAction)tAction2);
        this.checkItemCountInQueue(this.tt, 4, 4, 0);
        this.tt.taskCleanUp();
        this.checkItemCountInQueue(this.tt, 4, 3, 1);
        rjob1.localizing = false;
        this.tt.taskCleanUp();
        this.checkItemCountInQueue(this.tt, 3, 3, 0);
        this.tt.taskCleanUp();
        this.checkItemCountInQueue(this.tt, 3, 2, 1);
        this.tt.taskCleanUp();
        this.checkItemCountInQueue(this.tt, 2, 1, 1);
    }

    private void checkItemCountInQueue(TaskTracker tt, int allSize, int activeSize, int inactiveSize) {
        TestTaskTrackerActionCleanup.assertEquals((String)("Size of allCleanUpActions is not " + allSize), (int)allSize, (int)tt.allCleanupActions.size());
        TestTaskTrackerActionCleanup.assertEquals((String)("Size of activeCleanUpActions is not " + activeSize), (int)activeSize, (int)tt.activeCleanupActions.size());
        TestTaskTrackerActionCleanup.assertEquals((String)("Size of inactiveCleanUpActions is not " + inactiveSize), (int)inactiveSize, (int)tt.inactiveCleanupActions.size());
    }

    class TestTaskTracker
    extends TaskTracker {
        TestTaskTracker() {
        }

        synchronized void purgeJob(KillJobAction action) throws IOException {
            LOG.info((Object)("Received 'KillJobAction' for job: " + action.getJobID()));
        }

        void processKillTaskAction(KillTaskAction killAction) throws IOException {
            LOG.info((Object)("Received KillTaskAction for task: " + killAction.getTaskID()));
        }
    }
}

