/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker.DockerCommand;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.runtime.ContainerExecutionException;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class DockerClient {
    private static final Log LOG = LogFactory.getLog(DockerClient.class);
    private static final String TMP_FILE_PREFIX = "docker.";
    private static final String TMP_FILE_SUFFIX = ".cmd";
    private final String tmpDirPath;

    public DockerClient(Configuration conf) throws ContainerExecutionException {
        String tmpDirBase = conf.get("hadoop.tmp.dir");
        if (tmpDirBase == null) {
            throw new ContainerExecutionException("hadoop.tmp.dir not set!");
        }
        this.tmpDirPath = tmpDirBase + "/nm-docker-cmds";
        File tmpDir = new File(this.tmpDirPath);
        if (!tmpDir.exists() && !tmpDir.mkdirs()) {
            LOG.warn((Object)("Unable to create directory: " + this.tmpDirPath));
            throw new ContainerExecutionException("Unable to create directory: " + this.tmpDirPath);
        }
    }

    public String writeCommandToTempFile(DockerCommand cmd, String filePrefix) throws ContainerExecutionException {
        File dockerCommandFile = null;
        try {
            dockerCommandFile = File.createTempFile(TMP_FILE_PREFIX + filePrefix, TMP_FILE_SUFFIX, new File(this.tmpDirPath));
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(dockerCommandFile), "UTF-8");
            PrintWriter printWriter = new PrintWriter(writer);
            printWriter.print(cmd.getCommandWithArguments());
            printWriter.close();
            return dockerCommandFile.getAbsolutePath();
        }
        catch (IOException e) {
            LOG.warn((Object)"Unable to write docker command to temporary file!");
            throw new ContainerExecutionException(e);
        }
    }
}

