/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.io.IOException;
import org.apache.hadoop.hbase.security.AbstractHBaseSaslRpcClient;
import org.apache.hadoop.hbase.security.AuthMethod;
import org.apache.hadoop.hbase.security.SaslUnwrapHandler;
import org.apache.hadoop.hbase.security.SaslWrapHandler;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandler;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelPipeline;
import org.apache.hbase.thirdparty.io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class NettyHBaseSaslRpcClient
extends AbstractHBaseSaslRpcClient {
    private static final Logger LOG = LoggerFactory.getLogger(NettyHBaseSaslRpcClient.class);

    public NettyHBaseSaslRpcClient(AuthMethod method, Token<? extends TokenIdentifier> token, String serverPrincipal, boolean fallbackAllowed, String rpcProtection) throws IOException {
        super(method, token, serverPrincipal, fallbackAllowed, rpcProtection);
    }

    public void setupSaslHandler(ChannelPipeline p) {
        String qop = (String)this.saslClient.getNegotiatedProperty("javax.security.sasl.qop");
        if (LOG.isDebugEnabled()) {
            LOG.debug("SASL client context established. Negotiated QoP: " + qop);
        }
        if (qop == null || "auth".equalsIgnoreCase(qop)) {
            return;
        }
        p.addFirst(new ChannelHandler[]{new SaslWrapHandler(this.saslClient), new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4, 0, 4), new SaslUnwrapHandler(this.saslClient)});
    }

    public String getSaslQOP() {
        return (String)this.saslClient.getNegotiatedProperty("javax.security.sasl.qop");
    }
}

