/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class NamespacePermission
extends Permission {
    private String namespace = NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR;

    NamespacePermission(String namespace, Permission.Action ... assigned) {
        super(assigned);
        this.namespace = namespace;
        this.scope = Permission.Scope.NAMESPACE;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public boolean implies(String namespace, Permission.Action action) {
        return namespace.equals(this.namespace) && this.implies(action);
    }

    @Override
    public boolean equalsExceptActions(Object obj) {
        if (!(obj instanceof NamespacePermission)) {
            return false;
        }
        NamespacePermission gp = (NamespacePermission)((Object)obj);
        return this.namespace.equals(gp.namespace);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.namespace) + super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this.equalsExceptActions(obj) && super.equals(obj);
    }

    @Override
    public String toString() {
        return "[NamespacePermission: " + this.rawExpression() + "]";
    }

    @Override
    protected String rawExpression() {
        StringBuilder raw = new StringBuilder("namespace=").append(this.namespace).append(", ");
        return raw.toString() + super.rawExpression();
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.namespace = Bytes.toString((byte[])Bytes.readByteArray((DataInput)in));
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        Bytes.writeByteArray((DataOutput)out, (byte[])Bytes.toBytes((String)this.namespace));
    }
}

