/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureException;
import org.apache.hadoop.hbase.protobuf.generated.ProcedureProtos;

@InterfaceAudience.Private
@InterfaceStability.Evolving
class RootProcedureState {
    private static final Log LOG = LogFactory.getLog(RootProcedureState.class);
    private ArrayList<Procedure> subprocedures = null;
    private State state = State.RUNNING;
    private int running = 0;

    RootProcedureState() {
    }

    public synchronized boolean isFailed() {
        switch (this.state) {
            case ROLLINGBACK: 
            case FAILED: {
                return true;
            }
        }
        return false;
    }

    public synchronized boolean isRollingback() {
        return this.state == State.ROLLINGBACK;
    }

    protected synchronized boolean setRollback() {
        if (this.running == 0 && this.state == State.FAILED) {
            this.state = State.ROLLINGBACK;
            return true;
        }
        return false;
    }

    protected synchronized void unsetRollback() {
        assert (this.state == State.ROLLINGBACK);
        this.state = State.FAILED;
    }

    protected synchronized List<Procedure> getSubprocedures() {
        return this.subprocedures;
    }

    protected synchronized RemoteProcedureException getException() {
        if (this.subprocedures != null) {
            for (Procedure proc : this.subprocedures) {
                if (!proc.hasException()) continue;
                return proc.getException();
            }
        }
        return null;
    }

    protected synchronized boolean acquire(Procedure proc) {
        if (this.state != State.RUNNING) {
            return false;
        }
        ++this.running;
        return true;
    }

    protected synchronized void release(Procedure proc) {
        --this.running;
    }

    protected synchronized void abort() {
        if (this.state == State.RUNNING) {
            this.state = State.FAILED;
        }
    }

    protected synchronized void addRollbackStep(Procedure proc) {
        if (proc.isFailed()) {
            this.state = State.FAILED;
        }
        if (this.subprocedures == null) {
            this.subprocedures = new ArrayList();
        }
        proc.addStackIndex(this.subprocedures.size());
        this.subprocedures.add(proc);
    }

    protected synchronized void loadStack(Procedure proc) {
        int[] stackIndexes = proc.getStackIndexes();
        if (stackIndexes != null) {
            int diff;
            if (this.subprocedures == null) {
                this.subprocedures = new ArrayList();
            }
            if ((diff = 1 + stackIndexes[stackIndexes.length - 1] - this.subprocedures.size()) > 0) {
                this.subprocedures.ensureCapacity(1 + stackIndexes[stackIndexes.length - 1]);
                while (diff-- > 0) {
                    this.subprocedures.add(null);
                }
            }
            for (int i = 0; i < stackIndexes.length; ++i) {
                this.subprocedures.set(stackIndexes[i], proc);
            }
        }
        if (proc.getState() == ProcedureProtos.ProcedureState.ROLLEDBACK) {
            this.state = State.ROLLINGBACK;
        } else if (proc.isFailed()) {
            this.state = State.FAILED;
        }
    }

    protected synchronized boolean isValid() {
        if (this.subprocedures != null) {
            for (Procedure proc : this.subprocedures) {
                if (proc != null) continue;
                return false;
            }
        }
        return true;
    }

    private static enum State {
        RUNNING,
        FAILED,
        ROLLINGBACK;

    }
}

