/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.namespace;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.namespace.NamespaceStateManager;
import org.apache.hadoop.hbase.namespace.NamespaceTableAndRegionInfo;
import org.apache.hadoop.hbase.quotas.QuotaExceededException;

@InterfaceAudience.Private
public class NamespaceAuditor {
    private static Log LOG = LogFactory.getLog(NamespaceAuditor.class);
    static final String NS_AUDITOR_INIT_TIMEOUT = "hbase.namespace.auditor.init.timeout";
    static final int DEFAULT_NS_AUDITOR_INIT_TIMEOUT = 120000;
    private NamespaceStateManager stateManager;
    private MasterServices masterServices;

    public NamespaceAuditor(MasterServices masterServices) {
        this.masterServices = masterServices;
        this.stateManager = new NamespaceStateManager(masterServices, masterServices.getZooKeeper());
    }

    public void start() throws IOException {
        this.stateManager.start();
        LOG.info((Object)"NamespaceAuditor started.");
    }

    public void checkQuotaToCreateTable(TableName tName, int regions) throws IOException {
        if (this.stateManager.isInitialized()) {
            if (MetaTableAccessor.tableExists((Connection)this.masterServices.getConnection(), (TableName)tName)) {
                throw new TableExistsException(tName);
            }
            this.stateManager.checkAndUpdateNamespaceTableCount(tName, regions);
        } else {
            this.checkTableTypeAndThrowException(tName);
        }
    }

    private void checkTableTypeAndThrowException(TableName name) throws IOException {
        if (!name.isSystemTable()) {
            throw new HBaseIOException(name + " is being created even before namespace auditor has been initialized.");
        }
        LOG.debug((Object)("Namespace auditor checks not performed for table " + name.getNameAsString()));
    }

    public void checkQuotaToSplitRegion(HRegionInfo hri) throws IOException {
        if (!this.stateManager.isInitialized()) {
            throw new IOException("Split operation is being performed even before namespace auditor is initialized.");
        }
        if (!this.stateManager.checkAndUpdateNamespaceRegionCount(hri.getTable(), hri.getRegionName(), 1)) {
            throw new QuotaExceededException("Region split not possible for :" + hri.getEncodedName() + " as quota limits are exceeded ");
        }
    }

    public void updateQuotaForRegionMerge(HRegionInfo hri) throws IOException {
        if (!this.stateManager.isInitialized()) {
            throw new IOException("Merge operation is being performed even before namespace auditor is initialized.");
        }
        if (!this.stateManager.checkAndUpdateNamespaceRegionCount(hri.getTable(), hri.getRegionName(), -1)) {
            throw new QuotaExceededException("Region split not possible for :" + hri.getEncodedName() + " as quota limits are exceeded ");
        }
    }

    public void addNamespace(NamespaceDescriptor ns) throws IOException {
        this.stateManager.addNamespace(ns.getName());
    }

    public void deleteNamespace(String namespace) throws IOException {
        this.stateManager.deleteNamespace(namespace);
    }

    public void removeFromNamespaceUsage(TableName tableName) throws IOException {
        this.stateManager.removeTable(tableName);
    }

    public void removeRegionFromNamespaceUsage(HRegionInfo hri) throws IOException {
        this.stateManager.removeRegionFromTable(hri);
    }

    @VisibleForTesting
    NamespaceTableAndRegionInfo getState(String namespace) {
        if (this.stateManager.isInitialized()) {
            return this.stateManager.getState(namespace);
        }
        return null;
    }

    public boolean isInitialized() {
        return this.stateManager.isInitialized();
    }
}

