/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.master.balancer.BaseLoadBalancer;
import org.apache.hadoop.hbase.master.balancer.StochasticLoadBalancer;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
abstract class CandidateGenerator {
    CandidateGenerator() {
    }

    abstract BaseLoadBalancer.Cluster.Action generate(BaseLoadBalancer.Cluster var1);

    int pickRandomRegion(BaseLoadBalancer.Cluster cluster, int server, double chanceOfNoSwap) {
        if (cluster.regionsPerServer[server].length == 0 || (double)StochasticLoadBalancer.RANDOM.nextFloat() < chanceOfNoSwap) {
            return -1;
        }
        int rand = StochasticLoadBalancer.RANDOM.nextInt(cluster.regionsPerServer[server].length);
        return cluster.regionsPerServer[server][rand];
    }

    int pickRandomServer(BaseLoadBalancer.Cluster cluster) {
        if (cluster.numServers < 1) {
            return -1;
        }
        return StochasticLoadBalancer.RANDOM.nextInt(cluster.numServers);
    }

    int pickRandomRack(BaseLoadBalancer.Cluster cluster) {
        if (cluster.numRacks < 1) {
            return -1;
        }
        return StochasticLoadBalancer.RANDOM.nextInt(cluster.numRacks);
    }

    int pickOtherRandomServer(BaseLoadBalancer.Cluster cluster, int serverIndex) {
        int otherServerIndex;
        if (cluster.numServers < 2) {
            return -1;
        }
        while ((otherServerIndex = this.pickRandomServer(cluster)) == serverIndex) {
        }
        return otherServerIndex;
    }

    int pickOtherRandomRack(BaseLoadBalancer.Cluster cluster, int rackIndex) {
        int otherRackIndex;
        if (cluster.numRacks < 2) {
            return -1;
        }
        while ((otherRackIndex = this.pickRandomRack(cluster)) == rackIndex) {
        }
        return otherRackIndex;
    }

    BaseLoadBalancer.Cluster.Action pickRandomRegions(BaseLoadBalancer.Cluster cluster, int thisServer, int otherServer) {
        int otherRegionCount;
        if (thisServer < 0 || otherServer < 0) {
            return BaseLoadBalancer.Cluster.NullAction;
        }
        int thisRegionCount = cluster.getNumRegions(thisServer);
        double thisChance = thisRegionCount > (otherRegionCount = cluster.getNumRegions(otherServer)) ? 0.0 : 0.5;
        double otherChance = thisRegionCount <= otherRegionCount ? 0.0 : 0.5;
        int thisRegion = this.pickRandomRegion(cluster, thisServer, thisChance);
        int otherRegion = this.pickRandomRegion(cluster, otherServer, otherChance);
        return this.getAction(thisServer, thisRegion, otherServer, otherRegion);
    }

    protected BaseLoadBalancer.Cluster.Action getAction(int fromServer, int fromRegion, int toServer, int toRegion) {
        if (fromServer < 0 || toServer < 0) {
            return BaseLoadBalancer.Cluster.NullAction;
        }
        if (fromRegion > 0 && toRegion > 0) {
            return new BaseLoadBalancer.Cluster.SwapRegionsAction(fromServer, fromRegion, toServer, toRegion);
        }
        if (fromRegion > 0) {
            return new BaseLoadBalancer.Cluster.MoveRegionAction(fromRegion, fromServer, toServer);
        }
        if (toRegion > 0) {
            return new BaseLoadBalancer.Cluster.MoveRegionAction(toRegion, toServer, fromServer);
        }
        return BaseLoadBalancer.Cluster.NullAction;
    }

    List<Integer> getRandomIterationOrder(int length) {
        ArrayList<Integer> order = new ArrayList<Integer>(length);
        for (int i = 0; i < length; ++i) {
            order.add(i);
        }
        Collections.shuffle(order);
        return order;
    }
}

