/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Size;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.balancer.BalanceAction;
import org.apache.hadoop.hbase.master.balancer.BalancerClusterState;
import org.apache.hadoop.hbase.master.balancer.BalancerRegionLoad;
import org.apache.hadoop.hbase.master.balancer.CandidateGenerator;
import org.apache.hadoop.hbase.master.balancer.CostFunction;
import org.apache.hadoop.hbase.master.balancer.DoubleArrayCost;
import org.apache.hadoop.hbase.master.balancer.LoadCandidateGenerator;
import org.apache.hadoop.hbase.master.balancer.StochasticLoadBalancer;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class CacheAwareLoadBalancer
extends StochasticLoadBalancer {
    private static final Logger LOG = LoggerFactory.getLogger(CacheAwareLoadBalancer.class);
    private Configuration configuration;

    @Override
    public synchronized void loadConf(Configuration configuration) {
        this.configuration = configuration;
        this.costFunctions = new ArrayList();
        super.loadConf(configuration);
    }

    @Override
    protected Map<Class<? extends CandidateGenerator>, CandidateGenerator> createCandidateGenerators() {
        HashMap<Class<? extends CandidateGenerator>, CandidateGenerator> candidateGenerators = new HashMap<Class<? extends CandidateGenerator>, CandidateGenerator>(2);
        candidateGenerators.put(CacheAwareSkewnessCandidateGenerator.class, new CacheAwareSkewnessCandidateGenerator());
        candidateGenerators.put(CacheAwareCandidateGenerator.class, new CacheAwareCandidateGenerator());
        return candidateGenerators;
    }

    @Override
    protected List<CostFunction> createCostFunctions(Configuration configuration) {
        ArrayList<CostFunction> costFunctions = new ArrayList<CostFunction>();
        this.addCostFunction(costFunctions, new CacheAwareRegionSkewnessCostFunction(configuration));
        this.addCostFunction(costFunctions, new CacheAwareCostFunction(configuration));
        return costFunctions;
    }

    private void addCostFunction(List<CostFunction> costFunctions, CostFunction costFunction) {
        if (costFunction.getMultiplier() > 0.0f) {
            costFunctions.add(costFunction);
        }
    }

    @Override
    public void updateClusterMetrics(ClusterMetrics clusterMetrics) {
        this.clusterStatus = clusterMetrics;
        this.updateRegionLoad();
    }

    private void updateRegionLoad() {
        this.loads = new HashMap();
        this.regionCacheRatioOnOldServerMap = new HashMap();
        HashMap regionCacheRatioOnCurrentServerMap = new HashMap();
        this.clusterStatus.getLiveServerMetrics().forEach((sn, sm) -> sm.getRegionMetrics().forEach((regionName, rm) -> {
            String regionEncodedName = RegionInfo.encodeRegionName((byte[])regionName);
            ArrayDeque<BalancerRegionLoad> rload = new ArrayDeque<BalancerRegionLoad>();
            int regionSizeMB = (int)rm.getRegionSizeMB().get(Size.Unit.MEGABYTE);
            rload.add(new BalancerRegionLoad((RegionMetrics)rm));
            regionCacheRatioOnCurrentServerMap.put(regionEncodedName, new Pair(sn, (Object)regionSizeMB));
            this.loads.put(regionEncodedName, rload);
        }));
        this.clusterStatus.getLiveServerMetrics().forEach((sn, sm) -> sm.getRegionCachedInfo().forEach((regionEncodedName, regionSizeInCache) -> {
            ServerName currentServer;
            if (regionCacheRatioOnCurrentServerMap.containsKey(regionEncodedName) && !ServerName.isSameAddress((ServerName)(currentServer = (ServerName)((Pair)regionCacheRatioOnCurrentServerMap.get(regionEncodedName)).getFirst()), (ServerName)sn)) {
                int regionSizeMB = (Integer)((Pair)regionCacheRatioOnCurrentServerMap.get(regionEncodedName)).getSecond();
                float regionCacheRatioOnOldServer = regionSizeMB == 0 ? 0.0f : (float)regionSizeInCache.intValue() / (float)regionSizeMB;
                this.regionCacheRatioOnOldServerMap.put(regionEncodedName, new Pair(sn, (Object)Float.valueOf(regionCacheRatioOnOldServer)));
            }
        }));
    }

    private RegionInfo getRegionInfoByEncodedName(BalancerClusterState cluster, String regionName) {
        Optional<RegionInfo> regionInfoOptional = Arrays.stream(cluster.regions).filter(ri -> regionName.equals(ri.getEncodedName())).findFirst();
        if (regionInfoOptional.isPresent()) {
            return regionInfoOptional.get();
        }
        return null;
    }

    static class CacheAwareCostFunction
    extends CostFunction {
        private static final String CACHE_COST_KEY = "hbase.master.balancer.stochastic.cacheCost";
        private double cacheRatio;
        private double bestCacheRatio;
        private static final float DEFAULT_CACHE_COST = 20.0f;

        CacheAwareCostFunction(Configuration conf) {
            boolean isPersistentCache = conf.get("hbase.bucketcache.persistent.path") != null;
            this.setMultiplier(!isPersistentCache ? 0.0f : conf.getFloat(CACHE_COST_KEY, 20.0f));
            this.bestCacheRatio = 0.0;
            this.cacheRatio = 0.0;
        }

        @Override
        void prepare(BalancerClusterState cluster) {
            super.prepare(cluster);
            this.cacheRatio = 0.0;
            this.bestCacheRatio = 0.0;
            for (int region = 0; region < cluster.numRegions; ++region) {
                this.cacheRatio += (double)cluster.getOrComputeWeightedRegionCacheRatio(region, cluster.regionIndexToServerIndex[region]);
                this.bestCacheRatio += (double)cluster.getOrComputeWeightedRegionCacheRatio(region, this.getServerWithBestCacheRatioForRegion(region));
            }
            double d = this.cacheRatio = this.bestCacheRatio == 0.0 ? 1.0 : this.cacheRatio / this.bestCacheRatio;
            if (LOG.isDebugEnabled()) {
                LOG.debug("CacheAwareCostFunction: Cost: {}", (Object)(1.0 - this.cacheRatio));
            }
        }

        @Override
        protected double cost() {
            return CacheAwareCostFunction.scale(0.0, 1.0, 1.0 - this.cacheRatio);
        }

        @Override
        protected void regionMoved(int region, int oldServer, int newServer) {
            double regionCacheRatioOnOldServer = this.cluster.getOrComputeWeightedRegionCacheRatio(region, oldServer);
            double regionCacheRatioOnNewServer = this.cluster.getOrComputeWeightedRegionCacheRatio(region, newServer);
            double cacheRatioDiff = regionCacheRatioOnNewServer - regionCacheRatioOnOldServer;
            double normalizedDelta = this.bestCacheRatio == 0.0 ? 0.0 : cacheRatioDiff / this.bestCacheRatio;
            this.cacheRatio += normalizedDelta;
            if (LOG.isDebugEnabled() && (this.cacheRatio < 0.0 || this.cacheRatio > 1.0)) {
                LOG.debug("CacheAwareCostFunction:regionMoved:region:{}:from:{}:to:{}:regionCacheRatioOnOldServer:{}:regionCacheRatioOnNewServer:{}:bestRegionCacheRatio:{}:cacheRatio:{}", new Object[]{this.cluster.regions[region].getEncodedName(), this.cluster.servers[oldServer].getHostname(), this.cluster.servers[newServer].getHostname(), regionCacheRatioOnOldServer, regionCacheRatioOnNewServer, this.bestCacheRatio, this.cacheRatio});
            }
        }

        private int getServerWithBestCacheRatioForRegion(int region) {
            return this.cluster.getOrComputeServerWithBestRegionCachedRatio()[region];
        }

        @Override
        public void updateWeight(Map<Class<? extends CandidateGenerator>, Double> weights) {
            weights.merge(LoadCandidateGenerator.class, this.cost(), Double::sum);
        }
    }

    static class CacheAwareRegionSkewnessCostFunction
    extends CostFunction {
        static final String REGION_COUNT_SKEW_COST_KEY = "hbase.master.balancer.stochastic.regionCountCost";
        static final float DEFAULT_REGION_COUNT_SKEW_COST = 20.0f;
        private final DoubleArrayCost cost = new DoubleArrayCost();

        CacheAwareRegionSkewnessCostFunction(Configuration conf) {
            this.setMultiplier(conf.getFloat(REGION_COUNT_SKEW_COST_KEY, 20.0f));
        }

        @Override
        void prepare(BalancerClusterState cluster) {
            super.prepare(cluster);
            this.cost.prepare(cluster.numServers);
            this.cost.applyCostsChange(costs -> {
                for (int i = 0; i < cluster.numServers; ++i) {
                    costs[i] = cluster.regionsPerServer[i].length;
                }
            });
        }

        @Override
        protected double cost() {
            return this.cost.cost();
        }

        @Override
        protected void regionMoved(int region, int oldServer, int newServer) {
            this.cost.applyCostsChange(costs -> {
                costs[oldServer] = this.cluster.regionsPerServer[oldServer].length;
                costs[newServer] = this.cluster.regionsPerServer[newServer].length;
            });
        }

        @Override
        public final void updateWeight(Map<Class<? extends CandidateGenerator>, Double> weights) {
            weights.merge(LoadCandidateGenerator.class, this.cost(), Double::sum);
        }
    }

    private class CacheAwareSkewnessCandidateGenerator
    extends LoadCandidateGenerator {
        private CacheAwareSkewnessCandidateGenerator() {
        }

        @Override
        BalanceAction pickRandomRegions(BalancerClusterState cluster, int thisServer, int otherServer) {
            if (!CacheAwareLoadBalancer.this.regionCacheRatioOnOldServerMap.isEmpty() && CacheAwareLoadBalancer.this.regionCacheRatioOnOldServerMap.entrySet().iterator().hasNext()) {
                Map.Entry regionEntry = CacheAwareLoadBalancer.this.regionCacheRatioOnOldServerMap.entrySet().iterator().next();
                String regionEncodedName = (String)regionEntry.getKey();
                RegionInfo regionInfo = CacheAwareLoadBalancer.this.getRegionInfoByEncodedName(cluster, regionEncodedName);
                if (regionInfo == null) {
                    LOG.warn("Region {} does not exist", (Object)regionEncodedName);
                    CacheAwareLoadBalancer.this.regionCacheRatioOnOldServerMap.remove(regionEncodedName);
                    return BalanceAction.NULL_ACTION;
                }
                if (regionInfo.isMetaRegion() || regionInfo.getTable().isSystemTable()) {
                    CacheAwareLoadBalancer.this.regionCacheRatioOnOldServerMap.remove(regionEncodedName);
                    return BalanceAction.NULL_ACTION;
                }
                int regionIndex = cluster.regionsToIndex.get(regionInfo);
                thisServer = cluster.regionIndexToServerIndex[regionIndex];
                otherServer = cluster.serversToIndex.get(((ServerName)((Pair)regionEntry.getValue()).getFirst()).getAddress());
                CacheAwareLoadBalancer.this.regionCacheRatioOnOldServerMap.remove(regionEncodedName);
                if (otherServer < 0) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("CacheAwareSkewnessCandidateGenerator: Region {} not moved to the old server {} as the server does not exist", (Object)regionEncodedName, (Object)((ServerName)((Pair)regionEntry.getValue()).getFirst()).getHostname());
                    }
                    return BalanceAction.NULL_ACTION;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("CacheAwareSkewnessCandidateGenerator: Region {} moved from {} to {} as it was hosted their earlier", new Object[]{regionEncodedName, cluster.servers[thisServer].getHostname(), cluster.servers[otherServer].getHostname()});
                }
                return this.getAction(thisServer, regionIndex, otherServer, -1);
            }
            if (thisServer < 0 || otherServer < 0) {
                return BalanceAction.NULL_ACTION;
            }
            int regionIndexToMove = this.pickLeastCachedRegion(cluster, thisServer);
            if (regionIndexToMove < 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("CacheAwareSkewnessCandidateGenerator: No region found for movement");
                }
                return BalanceAction.NULL_ACTION;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("CacheAwareSkewnessCandidateGenerator: Region {} moved from {} to {} as it is least cached on current server", new Object[]{cluster.regions[regionIndexToMove].getEncodedName(), cluster.servers[thisServer].getHostname(), cluster.servers[otherServer].getHostname()});
            }
            return this.getAction(thisServer, regionIndexToMove, otherServer, -1);
        }

        private int pickLeastCachedRegion(BalancerClusterState cluster, int thisServer) {
            float minCacheRatio = Float.MAX_VALUE;
            int leastCachedRegion = -1;
            for (int i = 0; i < cluster.regionsPerServer[thisServer].length; ++i) {
                int regionIndex = cluster.regionsPerServer[thisServer][i];
                float cacheRatioOnCurrentServer = cluster.getOrComputeRegionCacheRatio(regionIndex, thisServer);
                if (!(cacheRatioOnCurrentServer < minCacheRatio)) continue;
                minCacheRatio = cacheRatioOnCurrentServer;
                leastCachedRegion = regionIndex;
            }
            return leastCachedRegion;
        }
    }

    private class CacheAwareCandidateGenerator
    extends CandidateGenerator {
        private CacheAwareCandidateGenerator() {
        }

        @Override
        protected BalanceAction generate(BalancerClusterState cluster) {
            if (!CacheAwareLoadBalancer.this.regionCacheRatioOnOldServerMap.isEmpty() && CacheAwareLoadBalancer.this.regionCacheRatioOnOldServerMap.entrySet().iterator().hasNext()) {
                Map.Entry regionCacheRatioServerMap = CacheAwareLoadBalancer.this.regionCacheRatioOnOldServerMap.entrySet().iterator().next();
                String regionEncodedName = (String)regionCacheRatioServerMap.getKey();
                RegionInfo regionInfo = CacheAwareLoadBalancer.this.getRegionInfoByEncodedName(cluster, regionEncodedName);
                if (regionInfo == null) {
                    LOG.warn("Region {} not found", (Object)regionEncodedName);
                    CacheAwareLoadBalancer.this.regionCacheRatioOnOldServerMap.remove(regionEncodedName);
                    return BalanceAction.NULL_ACTION;
                }
                if (regionInfo.isMetaRegion() || regionInfo.getTable().isSystemTable()) {
                    CacheAwareLoadBalancer.this.regionCacheRatioOnOldServerMap.remove(regionEncodedName);
                    return BalanceAction.NULL_ACTION;
                }
                int regionIndex = cluster.regionsToIndex.get(regionInfo);
                int oldServerIndex = cluster.serversToIndex.get(((ServerName)((Pair)CacheAwareLoadBalancer.this.regionCacheRatioOnOldServerMap.get(regionEncodedName)).getFirst()).getAddress());
                if (oldServerIndex < 0) {
                    LOG.warn("Server previously hosting region {} not found", (Object)regionEncodedName);
                    CacheAwareLoadBalancer.this.regionCacheRatioOnOldServerMap.remove(regionEncodedName);
                    return BalanceAction.NULL_ACTION;
                }
                float oldRegionCacheRatio = cluster.getOrComputeRegionCacheRatio(regionIndex, oldServerIndex);
                int currentServerIndex = cluster.regionIndexToServerIndex[regionIndex];
                float currentRegionCacheRatio = cluster.getOrComputeRegionCacheRatio(regionIndex, currentServerIndex);
                BalanceAction action = this.generatePlan(cluster, regionIndex, currentServerIndex, currentRegionCacheRatio, oldServerIndex, oldRegionCacheRatio);
                CacheAwareLoadBalancer.this.regionCacheRatioOnOldServerMap.remove(regionEncodedName);
                return action;
            }
            return BalanceAction.NULL_ACTION;
        }

        private BalanceAction generatePlan(BalancerClusterState cluster, int regionIndex, int currentServerIndex, float cacheRatioOnCurrentServer, int oldServerIndex, float cacheRatioOnOldServer) {
            return this.moveRegionToOldServer(cluster, regionIndex, currentServerIndex, cacheRatioOnCurrentServer, oldServerIndex, cacheRatioOnOldServer) ? this.getAction(currentServerIndex, regionIndex, oldServerIndex, -1) : BalanceAction.NULL_ACTION;
        }

        private boolean moveRegionToOldServer(BalancerClusterState cluster, int regionIndex, int currentServerIndex, float cacheRatioOnCurrentServer, int oldServerIndex, float cacheRatioOnOldServer) {
            if (currentServerIndex < 0 || oldServerIndex < 0) {
                return false;
            }
            float cacheRatioDiffThreshold = 0.6f;
            if (cacheRatioOnOldServer == 1.0f) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Region {} moved to the old server {} as it is fully cached there", (Object)cluster.regions[regionIndex].getEncodedName(), (Object)cluster.servers[oldServerIndex]);
                }
                return true;
            }
            if (cacheRatioOnCurrentServer == cacheRatioOnOldServer) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Region {} moved from {} to {} as the region is cached {} equally on both servers", new Object[]{cluster.regions[regionIndex].getEncodedName(), cluster.servers[currentServerIndex], cluster.servers[oldServerIndex], Float.valueOf(cacheRatioOnCurrentServer)});
                }
                return true;
            }
            if (cacheRatioOnOldServer > 0.0f && cacheRatioOnCurrentServer / cacheRatioOnOldServer < cacheRatioDiffThreshold) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Region {} moved from {} to {} as region cache ratio {} is better than the current cache ratio {}", new Object[]{cluster.regions[regionIndex].getEncodedName(), cluster.servers[currentServerIndex], cluster.servers[oldServerIndex], Float.valueOf(cacheRatioOnCurrentServer), Float.valueOf(cacheRatioOnOldServer)});
                }
                return true;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Region {} not moved from {} to {} with current cache ratio {} and old cache ratio {}", new Object[]{cluster.regions[regionIndex], cluster.servers[currentServerIndex], cluster.servers[oldServerIndex], Float.valueOf(cacheRatioOnCurrentServer), Float.valueOf(cacheRatioOnOldServer)});
            }
            return false;
        }
    }

    public static enum GeneratorFunctionType {
        LOAD,
        CACHE_RATIO;

    }
}

