/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.security.sasl.SaslException;
import org.apache.hadoop.hbase.CallQueueTooBigException;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.exceptions.ConnectionClosedException;
import org.apache.hadoop.hbase.ipc.ServerNotRunningYetException;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.ServerListener;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureDispatcher;
import org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hbase.thirdparty.com.google.common.collect.ArrayListMultimap;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RSProcedureDispatcher
extends RemoteProcedureDispatcher<MasterProcedureEnv, ServerName>
implements ServerListener {
    private static final Logger LOG = LoggerFactory.getLogger(RSProcedureDispatcher.class);
    public static final String RS_RPC_STARTUP_WAIT_TIME_CONF_KEY = "hbase.regionserver.rpc.startup.waittime";
    private static final int DEFAULT_RS_RPC_STARTUP_WAIT_TIME = 60000;
    protected final MasterServices master;
    private final long rsStartupWaitTime;
    private MasterProcedureEnv procedureEnv;

    public RSProcedureDispatcher(MasterServices master) {
        super(master.getConfiguration());
        this.master = master;
        this.rsStartupWaitTime = master.getConfiguration().getLong(RS_RPC_STARTUP_WAIT_TIME_CONF_KEY, 60000L);
    }

    protected Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                LOG.error("Unexpected error caught, this may cause the procedure to hang forever", e);
            }
        };
    }

    public boolean start() {
        if (!super.start()) {
            return false;
        }
        this.setTimeoutExecutorUncaughtExceptionHandler(this::abort);
        if (this.master.isStopped()) {
            LOG.debug("Stopped");
            return false;
        }
        ServerManager sm = this.master.getServerManager();
        if (sm == null) {
            LOG.debug("ServerManager is null");
            return false;
        }
        sm.registerListener(this);
        ProcedureExecutor<MasterProcedureEnv> pe = this.master.getMasterProcedureExecutor();
        if (pe == null) {
            LOG.debug("ProcedureExecutor is null");
            return false;
        }
        this.procedureEnv = (MasterProcedureEnv)pe.getEnvironment();
        if (this.procedureEnv == null) {
            LOG.debug("ProcedureEnv is null; stopping={}", (Object)this.master.isStopping());
            return false;
        }
        try {
            for (ServerName serverName : sm.getOnlineServersList()) {
                this.addNode((Comparable)serverName);
            }
        }
        catch (Exception e) {
            LOG.info("Failed start", (Throwable)e);
            return false;
        }
        return true;
    }

    private void abort(Thread t, Throwable e) {
        LOG.error("Caught error", e);
        if (!(this.master.isStopped() || this.master.isStopping() || this.master.isAborted())) {
            this.master.abort("Aborting master", e);
        }
    }

    public boolean stop() {
        if (!super.stop()) {
            return false;
        }
        this.master.getServerManager().unregisterListener(this);
        return true;
    }

    protected void remoteDispatch(ServerName serverName, Set<RemoteProcedureDispatcher.RemoteProcedure> remoteProcedures) {
        if (!this.master.getServerManager().isServerOnline(serverName)) {
            this.submitTask(new DeadRSRemoteCall(serverName, remoteProcedures));
        } else {
            this.submitTask(new ExecuteProceduresRemoteCall(serverName, remoteProcedures));
        }
    }

    protected void abortPendingOperations(ServerName serverName, Set<RemoteProcedureDispatcher.RemoteProcedure> operations) {
        DoNotRetryIOException e = new DoNotRetryIOException("server not online " + serverName);
        for (RemoteProcedureDispatcher.RemoteProcedure proc : operations) {
            proc.remoteCallFailed((Object)this.procedureEnv, (Object)serverName, (IOException)((Object)e));
        }
    }

    @Override
    public void serverAdded(ServerName serverName) {
        this.addNode((Comparable)serverName);
    }

    @Override
    public void serverRemoved(ServerName serverName) {
        this.removeNode((Comparable)serverName);
    }

    public void splitAndResolveOperation(ServerName serverName, Set<RemoteProcedureDispatcher.RemoteProcedure> operations, RemoteProcedureResolver resolver) {
        List refreshOps;
        List closeOps;
        MasterProcedureEnv env = (MasterProcedureEnv)this.master.getMasterProcedureExecutor().getEnvironment();
        ArrayListMultimap reqsByType = this.buildAndGroupRequestByType(env, (Comparable)serverName, operations);
        List openOps = this.fetchType(reqsByType, RegionOpenOperation.class);
        if (!openOps.isEmpty()) {
            resolver.dispatchOpenRequests(env, openOps);
        }
        if (!(closeOps = this.fetchType(reqsByType, RegionCloseOperation.class)).isEmpty()) {
            resolver.dispatchCloseRequests(env, closeOps);
        }
        if (!(refreshOps = this.fetchType(reqsByType, ServerOperation.class)).isEmpty()) {
            resolver.dispatchServerOperations(env, refreshOps);
        }
        if (!reqsByType.isEmpty()) {
            LOG.warn("unknown request type in the queue: " + reqsByType);
        }
    }

    private static AdminProtos.OpenRegionRequest buildOpenRegionRequest(MasterProcedureEnv env, ServerName serverName, List<RegionOpenOperation> operations) {
        AdminProtos.OpenRegionRequest.Builder builder = AdminProtos.OpenRegionRequest.newBuilder();
        builder.setServerStartCode(serverName.getStartCode());
        operations.stream().map(RemoteProcedureDispatcher.RemoteOperation::getInitiatingMasterActiveTime).findAny().ifPresent(arg_0 -> ((AdminProtos.OpenRegionRequest.Builder)builder).setInitiatingMasterActiveTime(arg_0));
        builder.setMasterSystemTime(EnvironmentEdgeManager.currentTime());
        for (RegionOpenOperation op : operations) {
            builder.addOpenInfo(op.buildRegionOpenInfoRequest(env));
        }
        return builder.build();
    }

    public static class RegionCloseOperation
    extends RegionOperation {
        private final ServerName destinationServer;
        private boolean evictCache;

        public RegionCloseOperation(RemoteProcedureDispatcher.RemoteProcedure remoteProcedure, RegionInfo regionInfo, long procId, ServerName destinationServer, boolean evictCache, long initiatingMasterActiveTime) {
            super(remoteProcedure, regionInfo, procId, initiatingMasterActiveTime);
            this.destinationServer = destinationServer;
            this.evictCache = evictCache;
        }

        public ServerName getDestinationServer() {
            return this.destinationServer;
        }

        public AdminProtos.CloseRegionRequest buildCloseRegionRequest(ServerName serverName) {
            return ProtobufUtil.buildCloseRegionRequest((ServerName)serverName, (byte[])this.regionInfo.getRegionName(), (ServerName)this.getDestinationServer(), (long)this.procId, (boolean)this.evictCache, (long)this.getInitiatingMasterActiveTime());
        }
    }

    public static class RegionOpenOperation
    extends RegionOperation {
        public RegionOpenOperation(RemoteProcedureDispatcher.RemoteProcedure remoteProcedure, RegionInfo regionInfo, long procId, long initiatingMasterActiveTime) {
            super(remoteProcedure, regionInfo, procId, initiatingMasterActiveTime);
        }

        public AdminProtos.OpenRegionRequest.RegionOpenInfo buildRegionOpenInfoRequest(MasterProcedureEnv env) {
            return RequestConverter.buildRegionOpenInfo((RegionInfo)this.regionInfo, env.getAssignmentManager().getFavoredNodes(this.regionInfo), (long)this.procId);
        }
    }

    public static abstract class RegionOperation
    extends RemoteProcedureDispatcher.RemoteOperation {
        protected final RegionInfo regionInfo;
        protected final long procId;

        protected RegionOperation(RemoteProcedureDispatcher.RemoteProcedure remoteProcedure, RegionInfo regionInfo, long procId, long initiatingMasterActiveTime) {
            super(remoteProcedure, initiatingMasterActiveTime);
            this.regionInfo = regionInfo;
            this.procId = procId;
        }
    }

    public static final class ServerOperation
    extends RemoteProcedureDispatcher.RemoteOperation {
        private final long procId;
        private final Class<?> rsProcClass;
        private final byte[] rsProcData;

        public ServerOperation(RemoteProcedureDispatcher.RemoteProcedure remoteProcedure, long procId, Class<?> rsProcClass, byte[] rsProcData, long initiatingMasterActiveTime) {
            super(remoteProcedure, initiatingMasterActiveTime);
            this.procId = procId;
            this.rsProcClass = rsProcClass;
            this.rsProcData = rsProcData;
        }

        public AdminProtos.RemoteProcedureRequest buildRequest() {
            return AdminProtos.RemoteProcedureRequest.newBuilder().setProcId(this.procId).setProcClass(this.rsProcClass.getName()).setProcData(ByteString.copyFrom((byte[])this.rsProcData)).setInitiatingMasterActiveTime(this.getInitiatingMasterActiveTime()).build();
        }
    }

    protected class ExecuteProceduresRemoteCall
    implements RemoteProcedureResolver,
    Runnable {
        private final ServerName serverName;
        private final Set<RemoteProcedureDispatcher.RemoteProcedure> remoteProcedures;
        private int numberOfAttemptsSoFar = 0;
        private long maxWaitTime = -1L;
        private final long rsRpcRetryInterval;
        private static final String RS_RPC_RETRY_INTERVAL_CONF_KEY = "hbase.regionserver.rpc.retry.interval";
        private static final int DEFAULT_RS_RPC_RETRY_INTERVAL = 100;
        private static final String RS_REMOTE_PROC_FAIL_FAST_LIMIT = "hbase.master.rs.remote.proc.fail.fast.limit";
        private static final int DEFAULT_RS_REMOTE_PROC_RETRY_LIMIT = 5;
        private final int failFastRetryLimit;
        private AdminProtos.ExecuteProceduresRequest.Builder request = null;

        public ExecuteProceduresRemoteCall(ServerName serverName, Set<RemoteProcedureDispatcher.RemoteProcedure> remoteProcedures) {
            this.serverName = serverName;
            this.remoteProcedures = remoteProcedures;
            this.rsRpcRetryInterval = RSProcedureDispatcher.this.master.getConfiguration().getLong(RS_RPC_RETRY_INTERVAL_CONF_KEY, 100L);
            this.failFastRetryLimit = RSProcedureDispatcher.this.master.getConfiguration().getInt(RS_REMOTE_PROC_FAIL_FAST_LIMIT, 5);
        }

        private AdminProtos.AdminService.BlockingInterface getRsAdmin() throws IOException {
            AdminProtos.AdminService.BlockingInterface admin = RSProcedureDispatcher.this.master.getServerManager().getRsAdmin(this.serverName);
            if (admin == null) {
                throw new IOException("Attempting to send OPEN RPC to server " + this.getServerName() + " failed because no RPC connection found to this server");
            }
            return admin;
        }

        protected final ServerName getServerName() {
            return this.serverName;
        }

        private boolean scheduleForRetry(IOException e) {
            LOG.debug("Request to {} failed, try={}", new Object[]{this.serverName, this.numberOfAttemptsSoFar, e});
            if (e instanceof ServerNotRunningYetException) {
                long remainingTime = this.getMaxWaitTime() - EnvironmentEdgeManager.currentTime();
                if (remainingTime > 0L) {
                    LOG.warn("Waiting a little before retrying {}, try={}, can wait up to {}ms", new Object[]{this.serverName, this.numberOfAttemptsSoFar, remainingTime});
                    ++this.numberOfAttemptsSoFar;
                    RSProcedureDispatcher.this.submitTask(this, this.rsRpcRetryInterval, TimeUnit.MILLISECONDS);
                    return true;
                }
                LOG.warn("{} is throwing ServerNotRunningYetException for {}ms; trying another server", (Object)this.serverName, (Object)this.getMaxWaitTime());
                return false;
            }
            if (e instanceof DoNotRetryIOException) {
                LOG.warn("{} tells us DoNotRetry due to {}, try={}, give up", new Object[]{this.serverName, e.toString(), this.numberOfAttemptsSoFar});
                return false;
            }
            if (this.numberOfAttemptsSoFar == 0 && this.unableToConnectToServer(e)) {
                return false;
            }
            if (this.numberOfAttemptsSoFar >= this.failFastRetryLimit - 1 && this.isErrorTypeFailFast(e)) {
                LOG.warn("Number of retries {} exceeded limit {} for the given error type. Scheduling server crash for {}", new Object[]{this.numberOfAttemptsSoFar + 1, this.failFastRetryLimit, this.serverName, e});
                RSProcedureDispatcher.this.master.getServerManager().expireServer(this.serverName);
                return false;
            }
            if (!RSProcedureDispatcher.this.master.getServerManager().isServerOnline(this.serverName)) {
                LOG.warn("Request to {} failed due to {}, try={} and the server is not online, give up", new Object[]{this.serverName, e.toString(), this.numberOfAttemptsSoFar});
                return false;
            }
            if (e instanceof RegionServerStoppedException) {
                LOG.warn("{} is aborted or stopped, for safety we still need to wait until it is fully dead, try={}", (Object)this.serverName, (Object)this.numberOfAttemptsSoFar);
            } else {
                LOG.warn("request to {} failed due to {}, try={}, retrying... , request params: {}", new Object[]{this.serverName, e.toString(), this.numberOfAttemptsSoFar, this.request.build()});
            }
            ++this.numberOfAttemptsSoFar;
            RSProcedureDispatcher.this.submitTask(this, Math.min(this.rsRpcRetryInterval * ((long)this.numberOfAttemptsSoFar * (long)this.numberOfAttemptsSoFar), 10000L), TimeUnit.MILLISECONDS);
            return true;
        }

        private boolean unableToConnectToServer(IOException e) {
            if (e instanceof CallQueueTooBigException) {
                LOG.warn("request to {} failed due to {}, try={}, this usually because server is overloaded, give up", new Object[]{this.serverName, e, this.numberOfAttemptsSoFar});
                return true;
            }
            if (this.isSaslError(e)) {
                LOG.warn("{} is not reachable; give up after first attempt", (Object)this.serverName, (Object)e);
                return true;
            }
            return false;
        }

        private boolean isSaslError(IOException e) {
            Throwable cause = e;
            do {
                IOException unwrappedCause;
                if (!(cause instanceof IOException) || !((unwrappedCause = this.unwrapException((IOException)cause)) instanceof SaslException) && (unwrappedCause.getMessage() == null || !unwrappedCause.getMessage().contains("Can not send request because relogin is in progress."))) continue;
                return true;
            } while ((cause = cause.getCause()) != null);
            return false;
        }

        private boolean isConnectionClosedError(IOException e) {
            if (e instanceof ConnectionClosedException) {
                return true;
            }
            Throwable cause = e;
            do {
                IOException unwrappedCause;
                if (!(cause instanceof IOException) || !((unwrappedCause = this.unwrapException((IOException)cause)) instanceof ConnectionClosedException)) continue;
                return true;
            } while ((cause = cause.getCause()) != null);
            return false;
        }

        private boolean isErrorTypeFailFast(IOException e) {
            return e instanceof CallQueueTooBigException || this.isSaslError(e) || this.isConnectionClosedError(e);
        }

        private long getMaxWaitTime() {
            if (this.maxWaitTime < 0L) {
                this.maxWaitTime = EnvironmentEdgeManager.currentTime() + RSProcedureDispatcher.this.rsStartupWaitTime;
            }
            return this.maxWaitTime;
        }

        private IOException unwrapException(IOException e) {
            if (e instanceof RemoteException) {
                e = ((RemoteException)((Object)e)).unwrapRemoteException();
            }
            return e;
        }

        @Override
        public void run() {
            block3: {
                this.request = AdminProtos.ExecuteProceduresRequest.newBuilder();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Building request with operations count=" + this.remoteProcedures.size());
                }
                RSProcedureDispatcher.this.splitAndResolveOperation(this.getServerName(), this.remoteProcedures, this);
                try {
                    this.sendRequest(this.getServerName(), this.request.build());
                }
                catch (IOException e) {
                    e = this.unwrapException(e);
                    if (this.scheduleForRetry(e)) break block3;
                    this.remoteCallFailed(RSProcedureDispatcher.this.procedureEnv, e);
                }
            }
        }

        @Override
        public void dispatchOpenRequests(MasterProcedureEnv env, List<RegionOpenOperation> operations) {
            this.request.addOpenRegion(RSProcedureDispatcher.buildOpenRegionRequest(env, this.getServerName(), operations));
        }

        @Override
        public void dispatchCloseRequests(MasterProcedureEnv env, List<RegionCloseOperation> operations) {
            for (RegionCloseOperation op : operations) {
                this.request.addCloseRegion(op.buildCloseRegionRequest(this.getServerName()));
            }
        }

        @Override
        public void dispatchServerOperations(MasterProcedureEnv env, List<ServerOperation> operations) {
            operations.stream().map(ServerOperation::buildRequest).forEachOrdered(arg_0 -> ((AdminProtos.ExecuteProceduresRequest.Builder)this.request).addProc(arg_0));
        }

        protected AdminProtos.ExecuteProceduresResponse sendRequest(ServerName serverName, AdminProtos.ExecuteProceduresRequest request) throws IOException {
            try {
                return this.getRsAdmin().executeProcedures(null, request);
            }
            catch (ServiceException se) {
                throw ProtobufUtil.getRemoteException((ServiceException)se);
            }
        }

        protected final void remoteCallFailed(MasterProcedureEnv env, IOException e) {
            for (RemoteProcedureDispatcher.RemoteProcedure proc : this.remoteProcedures) {
                proc.remoteCallFailed((Object)env, (Object)this.getServerName(), e);
            }
        }
    }

    private class DeadRSRemoteCall
    extends ExecuteProceduresRemoteCall {
        public DeadRSRemoteCall(ServerName serverName, Set<RemoteProcedureDispatcher.RemoteProcedure> remoteProcedures) {
            super(serverName, remoteProcedures);
        }

        @Override
        public void run() {
            this.remoteCallFailed(RSProcedureDispatcher.this.procedureEnv, (IOException)new RegionServerStoppedException("Server " + this.getServerName() + " is not online"));
        }
    }

    private static interface RemoteProcedureResolver {
        public void dispatchOpenRequests(MasterProcedureEnv var1, List<RegionOpenOperation> var2);

        public void dispatchCloseRequests(MasterProcedureEnv var1, List<RegionCloseOperation> var2);

        public void dispatchServerOperations(MasterProcedureEnv var1, List<ServerOperation> var2);
    }
}

