/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import org.apache.hadoop.hbase.quotas.RateLimiter;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class FixedIntervalRateLimiter
extends RateLimiter {
    public static final String RATE_LIMITER_REFILL_INTERVAL_MS = "hbase.quota.rate.limiter.refill.interval.ms";
    private long nextRefillTime = -1L;
    private final long refillInterval;

    public FixedIntervalRateLimiter() {
        this(1000L);
    }

    public FixedIntervalRateLimiter(long refillInterval) {
        Preconditions.checkArgument((this.getTimeUnitInMillis() >= refillInterval ? 1 : 0) != 0, (Object)String.format("Refill interval %s must be less than or equal to TimeUnit millis %s", refillInterval, this.getTimeUnitInMillis()));
        this.refillInterval = refillInterval;
    }

    @Override
    public long refill(long limit) {
        long now = EnvironmentEdgeManager.currentTime();
        if (this.nextRefillTime == -1L) {
            this.nextRefillTime = now + this.refillInterval;
            return limit;
        }
        if (now < this.nextRefillTime) {
            return 0L;
        }
        long diff = this.refillInterval + now - this.nextRefillTime;
        long refills = diff / this.refillInterval;
        this.nextRefillTime = now + this.refillInterval;
        long refillAmount = refills * this.getRefillIntervalAdjustedLimit(limit);
        return Math.min(limit, refillAmount);
    }

    @Override
    public long getWaitInterval(long limit, long available, long amount) {
        limit = this.getRefillIntervalAdjustedLimit(limit);
        if (this.nextRefillTime == -1L) {
            return 0L;
        }
        long now = EnvironmentEdgeManager.currentTime();
        long refillTime = this.nextRefillTime;
        long diff = amount - available;
        long nextRefillInterval = refillTime - now;
        if (diff <= limit) {
            return nextRefillInterval;
        }
        long extraRefillsNecessary = diff / limit;
        if (diff % limit == 0L) {
            --extraRefillsNecessary;
        }
        return nextRefillInterval + extraRefillsNecessary * this.refillInterval;
    }

    private long getRefillIntervalAdjustedLimit(long limit) {
        return (long)Math.ceil((double)this.refillInterval / (double)this.getTimeUnitInMillis() * (double)limit);
    }

    @Override
    public void setNextRefillTime(long nextRefillTime) {
        this.nextRefillTime = nextRefillTime;
    }

    @Override
    public long getNextRefillTime() {
        return this.nextRefillTime;
    }
}

