/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.quotas.RpcThrottlingException;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public interface OperationQuota {
    public static final String USE_RESULT_SIZE_BYTES = "hbase.quota.use.result.size.bytes";
    public static final boolean USE_RESULT_SIZE_BYTES_DEFAULT = false;

    public void checkBatchQuota(int var1, int var2) throws RpcThrottlingException;

    public void checkScanQuota(ClientProtos.ScanRequest var1, long var2, long var4, long var6) throws RpcThrottlingException;

    public void close();

    public void addGetResult(Result var1);

    public void addScanResult(List<Result> var1);

    public void addScanResultCells(List<Cell> var1);

    public void addMutation(Mutation var1);

    public long getReadAvailable();

    public long getReadConsumed();

    default public long getMaxResultSize() {
        return Math.max(this.getReadAvailable(), this.getReadConsumed());
    }

    public static enum OperationType {
        MUTATE,
        GET,
        SCAN,
        CHECK_AND_MUTATE;

    }
}

