/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.errorprone.annotations.RestrictedApi;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.Service;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.lang.reflect.Constructor;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.management.MalformedObjectNameException;
import javax.servlet.http.HttpServlet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.CacheEvictionStats;
import org.apache.hadoop.hbase.CallQueueTooBigException;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.ClockOutOfSyncException;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.FailedCloseWALAfterInitializedErrorException;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.HealthCheckChore;
import org.apache.hadoop.hbase.MetaRegionLocationCache;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.PleaseHoldException;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableDescriptors;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.YouAreDeadException;
import org.apache.hadoop.hbase.ZNodeClearer;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.CompactionState;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionServerRegistry;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.ServerConnectionUtils;
import org.apache.hadoop.hbase.client.locking.EntityLock;
import org.apache.hadoop.hbase.client.locking.LockServiceClient;
import org.apache.hadoop.hbase.conf.ConfigurationManager;
import org.apache.hadoop.hbase.conf.ConfigurationObserver;
import org.apache.hadoop.hbase.coordination.ZkCoordinatedStateManager;
import org.apache.hadoop.hbase.coprocessor.CoprocessorHost;
import org.apache.hadoop.hbase.exceptions.RegionMovedException;
import org.apache.hadoop.hbase.exceptions.RegionOpeningException;
import org.apache.hadoop.hbase.exceptions.UnknownProtocolException;
import org.apache.hadoop.hbase.executor.ExecutorService;
import org.apache.hadoop.hbase.executor.ExecutorType;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.http.InfoServer;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockCacheFactory;
import org.apache.hadoop.hbase.io.hfile.CombinedBlockCache;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketCache;
import org.apache.hadoop.hbase.io.util.MemorySizeUtil;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.hadoop.hbase.ipc.DecommissionedHostRejectedException;
import org.apache.hadoop.hbase.ipc.NettyRpcClientConfigHelper;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.RpcClientFactory;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hadoop.hbase.ipc.ServerNotRunningYetException;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.log.HBaseMarkers;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.MasterRpcServices;
import org.apache.hadoop.hbase.metrics.JvmPauseMonitorSource;
import org.apache.hadoop.hbase.mob.MobFileCache;
import org.apache.hadoop.hbase.mob.RSMobFileCleanerChore;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.namequeues.NamedQueueRecorder;
import org.apache.hadoop.hbase.namequeues.NamedQueueServiceChore;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.procedure.RegionServerProcedureManagerHost;
import org.apache.hadoop.hbase.procedure2.RSProcedureCallable;
import org.apache.hadoop.hbase.quotas.FileSystemUtilizationChore;
import org.apache.hadoop.hbase.quotas.QuotaUtil;
import org.apache.hadoop.hbase.quotas.RegionServerRpcQuotaManager;
import org.apache.hadoop.hbase.quotas.RegionServerSpaceQuotaManager;
import org.apache.hadoop.hbase.quotas.RegionSize;
import org.apache.hadoop.hbase.quotas.RegionSizeStore;
import org.apache.hadoop.hbase.regionserver.BootstrapNodeManager;
import org.apache.hadoop.hbase.regionserver.BrokenStoreFileCleaner;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.regionserver.CompactSplit;
import org.apache.hadoop.hbase.regionserver.CompactedHFilesDischarger;
import org.apache.hadoop.hbase.regionserver.DumpRegionServerMetrics;
import org.apache.hadoop.hbase.regionserver.FlushRequester;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServerCommandLine;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HeapMemoryManager;
import org.apache.hadoop.hbase.regionserver.LastSequenceId;
import org.apache.hadoop.hbase.regionserver.LeaseManager;
import org.apache.hadoop.hbase.regionserver.LogRoller;
import org.apache.hadoop.hbase.regionserver.MemStoreFlusher;
import org.apache.hadoop.hbase.regionserver.MemStoreLAB;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServer;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapper;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapperImpl;
import org.apache.hadoop.hbase.regionserver.MetricsTable;
import org.apache.hadoop.hbase.regionserver.MetricsTableWrapperAggregateImpl;
import org.apache.hadoop.hbase.regionserver.MetricsUserAggregateSource;
import org.apache.hadoop.hbase.regionserver.MetricsUserSource;
import org.apache.hadoop.hbase.regionserver.PrefetchExecutorNotifier;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.regionserver.RSSnapshotVerifier;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionServerAccounting;
import org.apache.hadoop.hbase.regionserver.RegionServerCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionServerRunningException;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.RemoteProcedureResultReporter;
import org.apache.hadoop.hbase.regionserver.ReplicationService;
import org.apache.hadoop.hbase.regionserver.ReplicationSinkService;
import org.apache.hadoop.hbase.regionserver.ReplicationSourceService;
import org.apache.hadoop.hbase.regionserver.SecureBulkLoadManager;
import org.apache.hadoop.hbase.regionserver.ServerNonceManager;
import org.apache.hadoop.hbase.regionserver.ShutdownHook;
import org.apache.hadoop.hbase.regionserver.SplitLogWorker;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StorefileRefresherChore;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionProgress;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequester;
import org.apache.hadoop.hbase.regionserver.handler.CloseMetaHandler;
import org.apache.hadoop.hbase.regionserver.handler.CloseRegionHandler;
import org.apache.hadoop.hbase.regionserver.handler.RSProcedureHandler;
import org.apache.hadoop.hbase.regionserver.handler.RegionReplicaFlushHandler;
import org.apache.hadoop.hbase.regionserver.http.RSDumpServlet;
import org.apache.hadoop.hbase.regionserver.http.RSStatusServlet;
import org.apache.hadoop.hbase.regionserver.throttle.FlushThroughputControllerFactory;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.regionserver.wal.WALEventTrackerListener;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationLoad;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationMarkerChore;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceInterface;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationStatus;
import org.apache.hadoop.hbase.security.Superusers;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.security.access.AccessChecker;
import org.apache.hadoop.hbase.security.access.ZKPermissionWatcher;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.LockServiceProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.trace.TraceUtil;
import org.apache.hadoop.hbase.unsafe.HBasePlatformDependent;
import org.apache.hadoop.hbase.util.Addressing;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.CompressionTest;
import org.apache.hadoop.hbase.util.CoprocessorConfigurationUtil;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.JvmPauseMonitor;
import org.apache.hadoop.hbase.util.NettyEventLoopGroupConfig;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.RetryCounter;
import org.apache.hadoop.hbase.util.RetryCounterFactory;
import org.apache.hadoop.hbase.util.ServerRegionReplicaUtil;
import org.apache.hadoop.hbase.util.Sleeper;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hadoop.hbase.wal.NettyAsyncFSWALConfigHelper;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.zookeeper.ClusterStatusTracker;
import org.apache.hadoop.hbase.zookeeper.MasterAddressTracker;
import org.apache.hadoop.hbase.zookeeper.ZKAuthentication;
import org.apache.hadoop.hbase.zookeeper.ZKClusterId;
import org.apache.hadoop.hbase.zookeeper.ZKNodeTracker;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.common.base.Throwables;
import org.apache.hbase.thirdparty.com.google.common.cache.Cache;
import org.apache.hbase.thirdparty.com.google.common.cache.CacheBuilder;
import org.apache.hbase.thirdparty.com.google.common.collect.Maps;
import org.apache.hbase.thirdparty.com.google.common.net.InetAddresses;
import org.apache.hbase.thirdparty.com.google.protobuf.BlockingRpcChannel;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.hbase.thirdparty.com.google.protobuf.MessageOrBuilder;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.apache.hbase.thirdparty.com.google.protobuf.TextFormat;
import org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.apache.hbase.thirdparty.io.netty.channel.EventLoopGroup;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Tools"})
public class HRegionServer
extends Thread
implements RegionServerServices,
LastSequenceId,
ConfigurationObserver {
    private static final Logger LOG = LoggerFactory.getLogger(HRegionServer.class);
    int unitMB = 0x100000;
    int unitKB = 1024;
    @InterfaceAudience.Private
    @SuppressWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static boolean TEST_SKIP_REPORTING_TRANSITION = false;
    private final ConcurrentMap<byte[], Boolean> regionsInTransitionInRS = new ConcurrentSkipListMap<byte[], Boolean>(Bytes.BYTES_COMPARATOR);
    private final ConcurrentMap<Long, Long> submittedRegionProcedures = new ConcurrentHashMap<Long, Long>();
    private final Cache<Long, Long> executedRegionProcedures = CacheBuilder.newBuilder().expireAfterAccess(600L, TimeUnit.SECONDS).build();
    private final Cache<String, MovedRegionInfo> movedRegionInfoCache = CacheBuilder.newBuilder().expireAfterWrite((long)this.movedRegionCacheExpiredTime(), TimeUnit.MILLISECONDS).build();
    private MemStoreFlusher cacheFlusher;
    private HeapMemoryManager hMemManager;
    protected ClusterConnection clusterConnection;
    protected TableDescriptors tableDescriptors;
    private ReplicationSourceService replicationSourceHandler;
    private ReplicationSinkService replicationSinkHandler;
    private CompactSplit compactSplitThread;
    private final Map<String, HRegion> onlineRegions = new ConcurrentHashMap<String, HRegion>();
    private final ReentrantReadWriteLock onlineRegionsLock = new ReentrantReadWriteLock();
    private final Map<String, Address[]> regionFavoredNodesMap = new ConcurrentHashMap<String, Address[]>();
    private LeaseManager leaseManager;
    protected ExecutorService executorService;
    private volatile boolean dataFsOk;
    private HFileSystem dataFs;
    private HFileSystem walFs;
    private volatile boolean stopped = false;
    private boolean isShutdownHookInstalled = false;
    private AtomicBoolean abortRequested;
    static final String ABORT_TIMEOUT = "hbase.regionserver.abort.timeout";
    private static final long DEFAULT_ABORT_TIMEOUT = 1200000L;
    static final String ABORT_TIMEOUT_TASK = "hbase.regionserver.abort.timeout.task";
    private boolean stopping = false;
    private volatile boolean killed = false;
    private volatile boolean shutDown = false;
    protected final Configuration conf;
    private Path dataRootDir;
    private Path walRootDir;
    private final int threadWakeFrequency;
    final int msgInterval;
    private static final String PERIOD_COMPACTION = "hbase.regionserver.compaction.check.period";
    private final int compactionCheckFrequency;
    private static final String PERIOD_FLUSH = "hbase.regionserver.flush.check.period";
    private final int flushCheckFrequency;
    private volatile RegionServerStatusProtos.RegionServerStatusService.BlockingInterface rssStub;
    private volatile LockServiceProtos.LockService.BlockingInterface lockStub;
    private RpcClient rpcClient;
    private RpcRetryingCallerFactory rpcRetryingCallerFactory;
    private RpcControllerFactory rpcControllerFactory;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    protected InfoServer infoServer;
    private JvmPauseMonitor pauseMonitor;
    private RSSnapshotVerifier rsSnapshotVerifier;
    public static final String REGIONSERVER = "regionserver";
    private MetricsRegionServer metricsRegionServer;
    MetricsRegionServerWrapperImpl metricsRegionServerImpl;
    private ChoreService choreService;
    private ScheduledChore compactionChecker;
    private ScheduledChore periodicFlusher;
    private volatile WALFactory walFactory;
    private LogRoller walRoller;
    private RemoteProcedureResultReporter procedureResultReporter;
    final AtomicBoolean online = new AtomicBoolean(false);
    protected final ZKWatcher zooKeeper;
    private final MasterAddressTracker masterAddressTracker;
    private final MetaRegionLocationCache metaRegionLocationCache;
    protected final ClusterStatusTracker clusterStatusTracker;
    private SplitLogWorker splitLogWorker;
    protected final Sleeper sleeper;
    private final int operationTimeout;
    private final int shortOperationTimeout;
    private final long retryPauseTime;
    private final RegionServerAccounting regionServerAccounting;
    private NamedQueueServiceChore namedQueueServiceChore = null;
    private BlockCache blockCache;
    private MobFileCache mobFileCache;
    private HealthCheckChore healthCheckChore;
    private ScheduledChore nonceManagerChore;
    private Map<String, Service> coprocessorServiceHandlers = Maps.newHashMap();
    protected ServerName serverName;
    protected String useThisHostnameInstead;
    @Deprecated
    @InterfaceAudience.LimitedPrivate(value={"Configuration"})
    static final String RS_HOSTNAME_DISABLE_MASTER_REVERSEDNS_KEY = "hbase.regionserver.hostname.disable.master.reversedns";
    @InterfaceAudience.LimitedPrivate(value={"Configuration"})
    static final String UNSAFE_RS_HOSTNAME_DISABLE_MASTER_REVERSEDNS_KEY = "hbase.unsafe.regionserver.hostname.disable.master.reversedns";
    protected final long startcode;
    protected String clusterId;
    private StorefileRefresherChore storefileRefresher;
    private volatile RegionServerCoprocessorHost rsHost;
    private RegionServerProcedureManagerHost rspmHost;
    private RegionServerRpcQuotaManager rsQuotaManager;
    private RegionServerSpaceQuotaManager rsSpaceQuotaManager;
    final ServerNonceManager nonceManager;
    private UserProvider userProvider;
    protected final RSRpcServices rpcServices;
    private CoordinatedStateManager csm;
    protected final ConfigurationManager configurationManager;
    private BrokenStoreFileCleaner brokenStoreFileCleaner;
    private RSMobFileCleanerChore rsMobFileCleanerChore;
    @InterfaceAudience.Private
    CompactedHFilesDischarger compactedFileDischarger;
    private volatile ThroughputController flushThroughputController;
    private SecureBulkLoadManager secureBulkLoadManager;
    private FileSystemUtilizationChore fsUtilizationChore;
    private final NettyEventLoopGroupConfig eventLoopGroupConfig;
    private NamedQueueRecorder namedQueueRecorder = null;
    private BootstrapNodeManager bootstrapNodeManager;
    private final boolean masterless;
    private static final String MASTERLESS_CONFIG_NAME = "hbase.masterless";
    private static final String REGIONSERVER_CODEC = "hbase.regionserver.codecs";
    private Timer abortMonitor;
    private ReplicationMarkerChore replicationMarkerChore;
    private PrefetchExecutorNotifier prefetchExecutorNotifier;
    private static final int TIMEOUT_REGION_MOVED = 120000;

    public HRegionServer(Configuration conf) throws IOException {
        super("RegionServer");
        Span span = TraceUtil.createSpan((String)"HRegionServer.cxtor");
        try (Scope ignored = span.makeCurrent();){
            boolean isMasterNotCarryTable;
            this.startcode = EnvironmentEdgeManager.currentTime();
            this.conf = conf;
            this.dataFsOk = true;
            this.masterless = conf.getBoolean(MASTERLESS_CONFIG_NAME, false);
            this.eventLoopGroupConfig = HRegionServer.setupNetty(this.conf);
            MemorySizeUtil.checkForClusterFreeHeapMemoryLimit(this.conf);
            HFile.checkHFileVersion(this.conf);
            HRegionServer.checkCodecs(this.conf);
            this.userProvider = UserProvider.instantiate((Configuration)conf);
            FSUtils.setupShortCircuitRead(this.conf);
            this.conf.setBoolean("hbase.meta.replicas.use", false);
            this.threadWakeFrequency = conf.getInt("hbase.server.thread.wakefrequency", 10000);
            this.compactionCheckFrequency = conf.getInt(PERIOD_COMPACTION, this.threadWakeFrequency);
            this.flushCheckFrequency = conf.getInt(PERIOD_FLUSH, this.threadWakeFrequency);
            this.msgInterval = conf.getInt("hbase.regionserver.msginterval", 3000);
            this.sleeper = new Sleeper(this.msgInterval, (Stoppable)this);
            boolean isNoncesEnabled = conf.getBoolean("hbase.regionserver.nonces.enabled", true);
            this.nonceManager = isNoncesEnabled ? new ServerNonceManager(this.conf) : null;
            this.operationTimeout = conf.getInt("hbase.client.operation.timeout", 1200000);
            this.shortOperationTimeout = conf.getInt("hbase.rpc.shortoperation.timeout", 10000);
            this.retryPauseTime = conf.getLong("hbase.rpc.shortoperation.retry.pause.time", 1000L);
            this.abortRequested = new AtomicBoolean(false);
            this.stopped = false;
            this.namedQueueRecorder = NamedQueueRecorder.getInstance(this.conf);
            this.rpcServices = this.createRpcServices();
            this.useThisHostnameInstead = this.getUseThisHostnameInstead(conf);
            boolean useIp = conf.getBoolean("hbase.server.useip.enabled", false);
            String isaHostName = useIp ? this.rpcServices.isa.getAddress().getHostAddress() : this.rpcServices.isa.getHostName();
            String hostName = StringUtils.isBlank((CharSequence)this.useThisHostnameInstead) ? isaHostName : this.useThisHostnameInstead;
            this.serverName = ServerName.valueOf((String)hostName, (int)this.rpcServices.isa.getPort(), (long)this.startcode);
            this.rpcControllerFactory = RpcControllerFactory.instantiate((Configuration)this.conf);
            this.rpcRetryingCallerFactory = RpcRetryingCallerFactory.instantiate((Configuration)this.conf, this.clusterConnection == null ? null : this.clusterConnection.getConnectionMetrics());
            ZKAuthentication.loginClient((Configuration)this.conf, (String)"hbase.zookeeper.client.keytab.file", (String)"hbase.zookeeper.client.kerberos.principal", (String)hostName);
            this.login(this.userProvider, hostName);
            Superusers.initialize((Configuration)conf);
            this.regionServerAccounting = new RegionServerAccounting(conf);
            boolean bl = isMasterNotCarryTable = this instanceof HMaster && !LoadBalancer.isTablesOnMaster(conf);
            if (!isMasterNotCarryTable) {
                this.blockCache = BlockCacheFactory.createBlockCache(conf);
                this.mobFileCache = new MobFileCache(conf);
            }
            this.rsSnapshotVerifier = new RSSnapshotVerifier(conf);
            this.uncaughtExceptionHandler = (t, e) -> this.abort("Uncaught exception in executorService thread " + t.getName(), e);
            this.initializeFileSystem();
            this.configurationManager = new ConfigurationManager();
            this.setupSignalHandlers();
            this.zooKeeper = new ZKWatcher(conf, this.getProcessName() + ":" + this.rpcServices.isa.getPort(), (Abortable)this, this.canCreateBaseZNode());
            if (!this.masterless) {
                if (conf.getBoolean("hbase.split.wal.zk.coordinated", false)) {
                    this.csm = new ZkCoordinatedStateManager(this);
                }
                this.masterAddressTracker = new MasterAddressTracker(this.getZooKeeper(), (Abortable)this);
                this.masterAddressTracker.start();
                this.clusterStatusTracker = new ClusterStatusTracker(this.zooKeeper, (Abortable)this);
                this.clusterStatusTracker.start();
            } else {
                this.masterAddressTracker = null;
                this.clusterStatusTracker = null;
            }
            this.rpcServices.start(this.zooKeeper);
            this.metaRegionLocationCache = new MetaRegionLocationCache(this.zooKeeper);
            int choreServiceInitialSize = conf.getInt("hbase.choreservice.initial.pool.size", 1);
            this.choreService = new ChoreService(this.getName(), choreServiceInitialSize, true);
            this.executorService = new ExecutorService(this.getName());
            this.putUpWebUI();
            span.setStatus(StatusCode.OK);
        }
        catch (Throwable t2) {
            TraceUtil.setError((Span)span, (Throwable)t2);
            LOG.error("Failed construction RegionServer", t2);
            throw t2;
        }
        finally {
            span.end();
        }
    }

    protected String getUseThisHostnameInstead(Configuration conf) throws IOException {
        String hostname = conf.get("hbase.unsafe.regionserver.hostname");
        if (conf.getBoolean(UNSAFE_RS_HOSTNAME_DISABLE_MASTER_REVERSEDNS_KEY, false)) {
            if (!StringUtils.isBlank((CharSequence)hostname)) {
                String msg = "hbase.unsafe.regionserver.hostname.disable.master.reversedns and hbase.unsafe.regionserver.hostname are mutually exclusive. Do not set hbase.unsafe.regionserver.hostname.disable.master.reversedns to true while hbase.unsafe.regionserver.hostname is used";
                throw new IOException(msg);
            }
            return this.rpcServices.isa.getHostName();
        }
        return hostname;
    }

    private void setupSignalHandlers() {
        if (!SystemUtils.IS_OS_WINDOWS) {
            HBasePlatformDependent.handle((String)"HUP", (number, name) -> {
                try {
                    this.updateConfiguration();
                }
                catch (IOException e) {
                    LOG.error("Problem while reloading configuration", (Throwable)e);
                }
            });
        }
    }

    private static NettyEventLoopGroupConfig setupNetty(Configuration conf) {
        NettyEventLoopGroupConfig nelgc = new NettyEventLoopGroupConfig(conf, "RS-EventLoopGroup");
        NettyRpcClientConfigHelper.setEventLoopConfig((Configuration)conf, (EventLoopGroup)nelgc.group(), nelgc.clientChannelClass());
        NettyAsyncFSWALConfigHelper.setEventLoopConfig(conf, nelgc.group(), nelgc.clientChannelClass());
        return nelgc;
    }

    private void initializeFileSystem() throws IOException {
        boolean useHBaseChecksum = this.conf.getBoolean("hbase.regionserver.checksum.verify", true);
        String walDirUri = CommonFSUtils.getDirUri((Configuration)this.conf, (Path)new Path(this.conf.get("hbase.wal.dir", this.conf.get("hbase.rootdir"))));
        if (walDirUri != null) {
            CommonFSUtils.setFsDefault((Configuration)this.conf, (String)walDirUri);
        }
        this.walFs = new HFileSystem(this.conf, useHBaseChecksum);
        this.walRootDir = CommonFSUtils.getWALRootDir((Configuration)this.conf);
        String rootDirUri = CommonFSUtils.getDirUri((Configuration)this.conf, (Path)new Path(this.conf.get("hbase.rootdir")));
        if (rootDirUri != null) {
            CommonFSUtils.setFsDefault((Configuration)this.conf, (String)rootDirUri);
        }
        this.dataFs = new HFileSystem(this.conf, useHBaseChecksum);
        this.dataRootDir = CommonFSUtils.getRootDir((Configuration)this.conf);
        this.tableDescriptors = new FSTableDescriptors((FileSystem)this.dataFs, this.dataRootDir, !this.canUpdateTableDescriptor(), this.cacheTableDescriptor());
    }

    protected void login(UserProvider user, String host) throws IOException {
        user.login("hbase.regionserver.keytab.file", "hbase.regionserver.kerberos.principal", host);
    }

    protected void waitForMasterActive() {
    }

    protected String getProcessName() {
        return REGIONSERVER;
    }

    protected boolean canCreateBaseZNode() {
        return this.masterless;
    }

    protected boolean canUpdateTableDescriptor() {
        return false;
    }

    protected boolean cacheTableDescriptor() {
        return false;
    }

    protected RSRpcServices createRpcServices() throws IOException {
        return new RSRpcServices(this);
    }

    protected void configureInfoServer() {
        this.infoServer.addUnprivilegedServlet("rs-status", "/rs-status", RSStatusServlet.class);
        this.infoServer.setAttribute(REGIONSERVER, (Object)this);
    }

    protected Class<? extends HttpServlet> getDumpServlet() {
        return RSDumpServlet.class;
    }

    public void dumpRowLocks(PrintWriter out) {
        StringBuilder sb = new StringBuilder();
        for (HRegion region : this.getRegions()) {
            if (region.getLockedRows().size() <= 0) continue;
            for (HRegion.RowLockContext rowLockContext : region.getLockedRows().values()) {
                sb.setLength(0);
                sb.append(region.getTableDescriptor().getTableName()).append(",").append(region.getRegionInfo().getEncodedName()).append(",");
                sb.append(rowLockContext.toString());
                out.println(sb);
            }
        }
    }

    @Override
    public boolean registerService(Service instance) {
        Descriptors.ServiceDescriptor serviceDesc = instance.getDescriptorForType();
        String serviceName = CoprocessorRpcUtils.getServiceName((Descriptors.ServiceDescriptor)serviceDesc);
        if (this.coprocessorServiceHandlers.containsKey(serviceName)) {
            LOG.error("Coprocessor executorService " + serviceName + " already registered, rejecting request from " + instance);
            return false;
        }
        this.coprocessorServiceHandlers.put(serviceName, instance);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Registered regionserver coprocessor executorService: executorService=" + serviceName);
        }
        return true;
    }

    protected ClusterConnection createClusterConnection() throws IOException {
        return ServerConnectionUtils.createShortCircuitConnection(this.conf, this.userProvider.getCurrent(), this.serverName, this.rpcServices, this.rpcServices, new RegionServerRegistry(this));
    }

    private static void checkCodecs(Configuration c) throws IOException {
        String[] codecs = c.getStrings(REGIONSERVER_CODEC, (String[])null);
        if (codecs == null) {
            return;
        }
        for (String codec : codecs) {
            if (CompressionTest.testCompression(codec)) continue;
            throw new IOException("Compression codec " + codec + " not supported, aborting RS construction");
        }
    }

    public String getClusterId() {
        return this.clusterId;
    }

    protected synchronized void setupClusterConnection() throws IOException {
        if (this.clusterConnection == null) {
            this.clusterConnection = this.createClusterConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preRegistrationInitialization() {
        Span span = TraceUtil.createSpan((String)"HRegionServer.preRegistrationInitialization");
        try (Scope ignored = span.makeCurrent();){
            this.initializeZooKeeper();
            this.setupClusterConnection();
            if (!(this instanceof HMaster)) {
                this.bootstrapNodeManager = new BootstrapNodeManager(this.clusterConnection, this.masterAddressTracker);
            }
            this.rpcClient = RpcClientFactory.createClient((Configuration)this.conf, (String)this.clusterId, (SocketAddress)new InetSocketAddress(this.rpcServices.isa.getAddress(), 0), (MetricsConnection)this.clusterConnection.getConnectionMetrics(), Collections.emptyMap());
            span.setStatus(StatusCode.OK);
        }
        catch (Throwable t) {
            TraceUtil.setError((Span)span, (Throwable)t);
            this.rpcServices.stop();
            this.abort("Initialization of RS failed.  Hence aborting RS.", t);
        }
        finally {
            span.end();
        }
    }

    @SuppressWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"}, justification="cluster Id znode read would give us correct response")
    private void initializeZooKeeper() throws IOException, InterruptedException {
        if (this.masterless) {
            return;
        }
        this.blockAndCheckIfStopped((ZKNodeTracker)this.masterAddressTracker);
        this.blockAndCheckIfStopped((ZKNodeTracker)this.clusterStatusTracker);
        if (this.clusterId == null) {
            try {
                this.clusterId = ZKClusterId.readClusterIdZNode((ZKWatcher)this.zooKeeper);
                if (this.clusterId == null) {
                    this.abort("Cluster ID has not been set");
                }
                LOG.info("ClusterId : " + this.clusterId);
            }
            catch (KeeperException e) {
                this.abort("Failed to retrieve Cluster ID", e);
            }
        }
        this.waitForMasterActive();
        if (this.isStopped() || this.isAborted()) {
            return;
        }
        try {
            this.rspmHost = new RegionServerProcedureManagerHost();
            this.rspmHost.loadProcedures(this.conf);
            this.rspmHost.initialize(this);
        }
        catch (KeeperException e) {
            this.abort("Failed to reach coordination cluster when creating procedure handler.", e);
        }
    }

    private void blockAndCheckIfStopped(ZKNodeTracker tracker) throws IOException, InterruptedException {
        while (tracker.blockUntilAvailable((long)this.msgInterval, false) == null) {
            if (!this.stopped) continue;
            throw new IOException("Received the shutdown message while waiting.");
        }
    }

    @Override
    public boolean isClusterUp() {
        return this.masterless || this.clusterStatusTracker != null && this.clusterStatusTracker.isClusterUp();
    }

    private void initializeReplicationMarkerChore() {
        boolean replicationMarkerEnabled = this.conf.getBoolean("hbase.regionserver.replication.marker.enabled", false);
        if (replicationMarkerEnabled) {
            int period = this.conf.getInt("hbase.regionserver.replication.marker.chore.duration", 30000);
            this.replicationMarkerChore = new ReplicationMarkerChore(this, this, period);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block67: {
            if (this.isStopped()) {
                LOG.info("Skipping run; stopped");
                return;
            }
            try {
                this.installShutdownHook();
                this.preRegistrationInitialization();
            }
            catch (Throwable e) {
                this.abort("Fatal exception during initialization", e);
            }
            try {
                if (!this.isStopped() && !this.isAborted()) {
                    this.rsHost = new RegionServerCoprocessorHost(this, this.conf);
                    LOG.debug("About to register with Master.");
                    TraceUtil.trace(() -> {
                        RetryCounterFactory rcf = new RetryCounterFactory(Integer.MAX_VALUE, this.sleeper.getPeriod(), 300000);
                        RetryCounter rc = rcf.create();
                        while (this.keepLooping()) {
                            RegionServerStatusProtos.RegionServerStartupResponse w = this.reportForDuty();
                            if (w == null) {
                                long sleepTime = rc.getBackoffTimeAndIncrementAttempts();
                                LOG.warn("reportForDuty failed; sleeping {} ms and then retrying.", (Object)sleepTime);
                                this.sleeper.sleep(sleepTime);
                                continue;
                            }
                            this.handleReportForDutyResponse(w);
                            break;
                        }
                    }, (String)"HRegionServer.registerWithMaster");
                }
                if (!this.isStopped() && this.isHealthy()) {
                    TraceUtil.trace(() -> {
                        if (this.rspmHost != null) {
                            this.rspmHost.start();
                        }
                        if (this.rsQuotaManager != null) {
                            this.rsQuotaManager.start(this.getRpcServer().getScheduler());
                        }
                        if (this.rsSpaceQuotaManager != null) {
                            this.rsSpaceQuotaManager.start();
                        }
                    }, (String)"HRegionServer.startup");
                }
                long lastMsg = EnvironmentEdgeManager.currentTime();
                long oldRequestCount = -1L;
                while (!this.isStopped() && this.isHealthy()) {
                    long now;
                    if (!this.isClusterUp()) {
                        if (this.onlineRegions.isEmpty()) {
                            this.stop("Exiting; cluster shutdown set and not carrying any regions");
                        } else if (!this.stopping) {
                            this.stopping = true;
                            LOG.info("Closing user regions");
                            this.closeUserRegions(this.abortRequested.get());
                        } else {
                            boolean allUserRegionsOffline = this.areAllUserRegionsOffline();
                            if (allUserRegionsOffline) {
                                if (oldRequestCount == this.getWriteRequestCount()) {
                                    this.stop("Stopped; only catalog regions remaining online");
                                    break;
                                }
                                oldRequestCount = this.getWriteRequestCount();
                            } else {
                                this.closeUserRegions(this.abortRequested.get());
                            }
                            LOG.debug("Waiting on " + this.getOnlineRegionsAsPrintableString());
                        }
                    }
                    if ((now = EnvironmentEdgeManager.currentTime()) - lastMsg >= (long)this.msgInterval) {
                        this.tryRegionServerReport(lastMsg, now);
                        lastMsg = EnvironmentEdgeManager.currentTime();
                    }
                    if (this.isStopped() || this.isAborted()) continue;
                    this.sleeper.sleep();
                }
            }
            catch (Throwable t) {
                if (this.rpcServices.checkOOME(t)) break block67;
                String prefix = t instanceof YouAreDeadException ? "" : "Unhandled: ";
                this.abort(prefix + t.getMessage(), t);
            }
        }
        Span span = TraceUtil.createSpan((String)"HRegionServer exiting main loop");
        try (Scope ignored = span.makeCurrent();){
            if (this.leaseManager != null) {
                this.leaseManager.closeAfterLeasesExpire();
            }
            if (this.splitLogWorker != null) {
                this.splitLogWorker.stop();
            }
            if (this.infoServer != null) {
                LOG.info("Stopping infoServer");
                try {
                    this.infoServer.stop();
                }
                catch (Exception e) {
                    LOG.error("Failed to stop infoServer", (Throwable)e);
                }
            }
            if (this.blockCache != null) {
                this.blockCache.shutdown();
            }
            if (this.mobFileCache != null) {
                this.mobFileCache.shutdown();
            }
            if (this.hMemManager != null) {
                this.hMemManager.stop();
            }
            if (this.cacheFlusher != null) {
                this.cacheFlusher.interruptIfNecessary();
            }
            if (this.compactSplitThread != null) {
                this.compactSplitThread.interruptIfNecessary();
            }
            if (this.rspmHost != null) {
                this.rspmHost.stop(this.abortRequested.get() || this.killed);
            }
            if (!this.killed) {
                if (this.abortRequested.get()) {
                    if (this.dataFsOk) {
                        this.closeUserRegions(this.abortRequested.get());
                    }
                    LOG.info("aborting server " + this.serverName);
                } else {
                    this.closeUserRegions(this.abortRequested.get());
                    LOG.info("stopping server " + this.serverName);
                }
            }
            if (this.clusterConnection != null && !this.clusterConnection.isClosed()) {
                try {
                    this.clusterConnection.close();
                }
                catch (IOException e) {
                    LOG.warn("Attempt to close server's short circuit ClusterConnection failed.", (Throwable)e);
                }
            }
            if (!this.killed && this.containsMetaTableRegions() && (!this.abortRequested.get() || this.dataFsOk)) {
                if (this.compactSplitThread != null) {
                    this.compactSplitThread.join();
                    this.compactSplitThread = null;
                }
                this.closeMetaTableRegions(this.abortRequested.get());
            }
            if (!this.killed && this.dataFsOk) {
                this.waitOnAllRegionsToClose(this.abortRequested.get());
                LOG.info("stopping server " + this.serverName + "; all regions closed.");
            }
            if (this.rsQuotaManager != null) {
                this.rsQuotaManager.stop();
            }
            if (this.rsSpaceQuotaManager != null) {
                this.rsSpaceQuotaManager.stop();
                this.rsSpaceQuotaManager = null;
            }
            if (this.dataFsOk) {
                this.shutdownWAL(!this.abortRequested.get());
            }
            if (this.rssStub != null) {
                this.rssStub = null;
            }
            if (this.lockStub != null) {
                this.lockStub = null;
            }
            if (this.rpcClient != null) {
                this.rpcClient.close();
            }
            if (this.leaseManager != null) {
                this.leaseManager.close();
            }
            if (this.pauseMonitor != null) {
                this.pauseMonitor.stop();
            }
            if (!this.killed) {
                this.stopServiceThreads();
            }
            if (this.rpcServices != null) {
                this.rpcServices.stop();
            }
            try {
                this.deleteMyEphemeralNode();
            }
            catch (KeeperException.NoNodeException e) {
            }
            catch (KeeperException e) {
                LOG.warn("Failed deleting my ephemeral node", (Throwable)e);
            }
            ZNodeClearer.deleteMyEphemeralNodeOnDisk();
            if (this.zooKeeper != null) {
                this.zooKeeper.close();
            }
            this.shutDown = true;
            LOG.info("Exiting; stopping=" + this.serverName + "; zookeeper connection closed.");
            span.setStatus(StatusCode.OK);
        }
        finally {
            span.end();
        }
    }

    private void installShutdownHook() {
        ShutdownHook.install(this.conf, (FileSystem)this.dataFs, this, Thread.currentThread());
        this.isShutdownHookInstalled = true;
    }

    public boolean isShutdownHookInstalled() {
        return this.isShutdownHookInstalled;
    }

    private boolean containsMetaTableRegions() {
        return this.onlineRegions.containsKey(RegionInfoBuilder.FIRST_META_REGIONINFO.getEncodedName());
    }

    private boolean areAllUserRegionsOffline() {
        if (this.getNumberOfOnlineRegions() > 2) {
            return false;
        }
        boolean allUserRegionsOffline = true;
        for (Map.Entry<String, HRegion> e : this.onlineRegions.entrySet()) {
            if (e.getValue().getRegionInfo().isMetaRegion()) continue;
            allUserRegionsOffline = false;
            break;
        }
        return allUserRegionsOffline;
    }

    private long getWriteRequestCount() {
        long writeCount = 0L;
        for (Map.Entry<String, HRegion> e : this.onlineRegions.entrySet()) {
            writeCount += e.getValue().getWriteRequestsCount();
        }
        return writeCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    protected void tryRegionServerReport(long reportStartTime, long reportEndTime) throws IOException {
        RegionServerStatusProtos.RegionServerStatusService.BlockingInterface rss = this.rssStub;
        if (rss == null) {
            return;
        }
        ClusterStatusProtos.ServerLoad sl = this.buildServerLoad(reportStartTime, reportEndTime);
        Span span = TraceUtil.createSpan((String)"HRegionServer.tryRegionServerReport");
        try (Scope ignored = span.makeCurrent();){
            RegionServerStatusProtos.RegionServerReportRequest.Builder request = RegionServerStatusProtos.RegionServerReportRequest.newBuilder();
            request.setServer(ProtobufUtil.toServerName((ServerName)this.serverName));
            request.setLoad(sl);
            rss.regionServerReport(null, request.build());
            span.setStatus(StatusCode.OK);
        }
        catch (ServiceException se) {
            IOException ioe = ProtobufUtil.getRemoteException((ServiceException)se);
            if (ioe instanceof YouAreDeadException) {
                TraceUtil.setError((Span)span, (Throwable)ioe);
                throw ioe;
            }
            if (this.rssStub == rss) {
                this.rssStub = null;
            }
            TraceUtil.setError((Span)span, (Throwable)se);
            this.createRegionServerStatusStub(true);
        }
        finally {
            span.end();
        }
    }

    @Override
    public boolean reportRegionSizesForQuotas(RegionSizeStore regionSizeStore) {
        RegionServerStatusProtos.RegionServerStatusService.BlockingInterface rss = this.rssStub;
        if (rss == null) {
            LOG.trace("Skipping Region size report to HMaster as stub is null");
            return true;
        }
        try {
            this.buildReportAndSend(rss, regionSizeStore);
        }
        catch (ServiceException se) {
            Throwable t;
            DoNotRetryIOException doNotRetryEx;
            IOException ioe = ProtobufUtil.getRemoteException((ServiceException)se);
            if (ioe instanceof PleaseHoldException) {
                LOG.trace("Failed to report region sizes to Master because it is initializing. This will be retried.", (Throwable)ioe);
                return true;
            }
            if (this.rssStub == rss) {
                this.rssStub = null;
            }
            this.createRegionServerStatusStub(true);
            if (ioe instanceof DoNotRetryIOException && (doNotRetryEx = (DoNotRetryIOException)((Object)ioe)).getCause() != null && (t = doNotRetryEx.getCause()) instanceof UnsupportedOperationException) {
                LOG.debug("master doesn't support ReportRegionSpaceUse, pause before retrying");
                return false;
            }
            LOG.debug("Failed to report region sizes to Master. This will be retried.", (Throwable)ioe);
        }
        return true;
    }

    private void buildReportAndSend(RegionServerStatusProtos.RegionServerStatusService.BlockingInterface rss, RegionSizeStore regionSizeStore) throws ServiceException {
        RegionServerStatusProtos.RegionSpaceUseReportRequest request = this.buildRegionSpaceUseReportRequest(Objects.requireNonNull(regionSizeStore));
        rss.reportRegionSpaceUse(null, request);
        if (this.metricsRegionServer != null) {
            this.metricsRegionServer.incrementNumRegionSizeReportsSent(regionSizeStore.size());
        }
    }

    RegionServerStatusProtos.RegionSpaceUseReportRequest buildRegionSpaceUseReportRequest(RegionSizeStore regionSizes) {
        RegionServerStatusProtos.RegionSpaceUseReportRequest.Builder request = RegionServerStatusProtos.RegionSpaceUseReportRequest.newBuilder();
        for (Map.Entry entry : regionSizes) {
            request.addSpaceUse(this.convertRegionSize((RegionInfo)entry.getKey(), ((RegionSize)entry.getValue()).getSize()));
        }
        return request.build();
    }

    RegionServerStatusProtos.RegionSpaceUse convertRegionSize(RegionInfo regionInfo, Long sizeInBytes) {
        return RegionServerStatusProtos.RegionSpaceUse.newBuilder().setRegionInfo(ProtobufUtil.toRegionInfo((RegionInfo)Objects.requireNonNull(regionInfo))).setRegionSize(Objects.requireNonNull(sizeInBytes).longValue()).build();
    }

    private ClusterStatusProtos.ServerLoad buildServerLoad(long reportStartTime, long reportEndTime) throws IOException {
        ReplicationLoad rLoad;
        ReplicationSourceService rsources;
        MetricsRegionServerWrapper regionServerWrapper = this.metricsRegionServer.getRegionServerWrapper();
        Collection<HRegion> regions = this.getOnlineRegionsLocalContext();
        long usedMemory = -1L;
        long maxMemory = -1L;
        MemoryUsage usage = MemorySizeUtil.safeGetHeapMemoryUsage();
        if (usage != null) {
            usedMemory = usage.getUsed();
            maxMemory = usage.getMax();
        }
        ClusterStatusProtos.ServerLoad.Builder serverLoad = ClusterStatusProtos.ServerLoad.newBuilder();
        serverLoad.setNumberOfRequests((long)((int)regionServerWrapper.getRequestsPerSecond()));
        serverLoad.setTotalNumberOfRequests(regionServerWrapper.getTotalRequestCount());
        serverLoad.setUsedHeapMB((int)(usedMemory / 1024L / 1024L));
        serverLoad.setMaxHeapMB((int)(maxMemory / 1024L / 1024L));
        Set<String> coprocessors = this.getWAL(null).getCoprocessorHost().getCoprocessors();
        HBaseProtos.Coprocessor.Builder coprocessorBuilder = HBaseProtos.Coprocessor.newBuilder();
        for (String coprocessor : coprocessors) {
            serverLoad.addCoprocessors(coprocessorBuilder.setName(coprocessor).build());
        }
        ClusterStatusProtos.RegionLoad.Builder regionLoadBldr = ClusterStatusProtos.RegionLoad.newBuilder();
        HBaseProtos.RegionSpecifier.Builder regionSpecifier = HBaseProtos.RegionSpecifier.newBuilder();
        for (HRegion region : regions) {
            if (region.getCoprocessorHost() != null) {
                Iterator regionCoprocessors = region.getCoprocessorHost().getCoprocessors();
                Iterator<String> iterator = regionCoprocessors.iterator();
                while (iterator.hasNext()) {
                    String regionCoprocessor = iterator.next();
                    serverLoad.addCoprocessors(coprocessorBuilder.setName(regionCoprocessor).build());
                }
            }
            serverLoad.addRegionLoads(this.createRegionLoad(region, regionLoadBldr, regionSpecifier));
            for (String coprocessor : this.getWAL(region.getRegionInfo()).getCoprocessorHost().getCoprocessors()) {
                serverLoad.addCoprocessors(coprocessorBuilder.setName(coprocessor).build());
            }
        }
        this.getBlockCache().ifPresent(cache -> cache.getRegionCachedInfo().ifPresent(regionCachedInfo -> regionCachedInfo.forEach((regionName, prefetchSize) -> serverLoad.putRegionCachedInfo(regionName, HRegionServer.roundSize(prefetchSize, this.unitMB)))));
        serverLoad.setReportStartTime(reportStartTime);
        serverLoad.setReportEndTime(reportEndTime);
        if (this.infoServer != null) {
            serverLoad.setInfoServerPort(this.infoServer.getPort());
        } else {
            serverLoad.setInfoServerPort(-1);
        }
        MetricsUserAggregateSource userSource = this.metricsRegionServer.getMetricsUserAggregate().getSource();
        if (userSource != null) {
            Map userMetricMap = userSource.getUserSources();
            for (Map.Entry entry : userMetricMap.entrySet()) {
                serverLoad.addUserLoads(this.createUserLoad((String)entry.getKey(), (MetricsUserSource)entry.getValue()));
            }
        }
        if ((rsources = this.getReplicationSourceService()) != null && (rLoad = rsources.refreshAndGetReplicationLoad()) != null) {
            serverLoad.setReplLoadSink(rLoad.getReplicationLoadSink());
            for (ClusterStatusProtos.ReplicationLoadSource rLS : rLoad.getReplicationLoadSourceEntries()) {
                serverLoad.addReplLoadSource(rLS);
            }
        }
        TaskMonitor.get().getTasks().forEach(task -> serverLoad.addTasks(ClusterStatusProtos.ServerTask.newBuilder().setDescription(task.getDescription()).setStatus(task.getStatus() != null ? task.getStatus() : "").setState(ClusterStatusProtos.ServerTask.State.valueOf((String)task.getState().name())).setStartTime(task.getStartTime()).setCompletionTime(task.getCompletionTimestamp()).build()));
        return serverLoad.build();
    }

    private String getOnlineRegionsAsPrintableString() {
        StringBuilder sb = new StringBuilder();
        for (Region region : this.onlineRegions.values()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(region.getRegionInfo().getEncodedName());
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitOnAllRegionsToClose(boolean abort) {
        int lastCount = -1;
        long previousLogTime = 0L;
        HashSet<String> closedRegions = new HashSet<String>();
        boolean interrupted = false;
        try {
            while (!this.onlineRegions.isEmpty()) {
                int count = this.getNumberOfOnlineRegions();
                if (count != lastCount && EnvironmentEdgeManager.currentTime() > previousLogTime + 1000L) {
                    previousLogTime = EnvironmentEdgeManager.currentTime();
                    lastCount = count;
                    LOG.info("Waiting on " + count + " regions to close");
                    if (count < 10 && LOG.isDebugEnabled()) {
                        LOG.debug("Online Regions=" + this.onlineRegions);
                    }
                }
                for (Map.Entry<String, HRegion> e2 : this.onlineRegions.entrySet()) {
                    RegionInfo hri = e2.getValue().getRegionInfo();
                    if (this.regionsInTransitionInRS.containsKey(hri.getEncodedNameAsBytes()) || closedRegions.contains(hri.getEncodedName())) continue;
                    closedRegions.add(hri.getEncodedName());
                    this.closeRegionIgnoreErrors(hri, abort);
                }
                if (this.regionsInTransitionInRS.isEmpty()) {
                    if (!this.onlineRegions.isEmpty()) {
                        LOG.info("We were exiting though online regions are not empty, because some regions failed closing");
                    }
                    break;
                }
                LOG.debug("Waiting on {}", (Object)this.regionsInTransitionInRS.keySet().stream().map(e -> Bytes.toString((byte[])e)).collect(Collectors.joining(", ")));
                if (!HRegionServer.sleepInterrupted(200L)) continue;
                interrupted = true;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static boolean sleepInterrupted(long millis) {
        boolean interrupted = false;
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while sleeping");
            interrupted = true;
        }
        return interrupted;
    }

    private void shutdownWAL(boolean close) {
        if (this.walFactory != null) {
            try {
                if (close) {
                    this.walFactory.close();
                } else {
                    this.walFactory.shutdown();
                }
            }
            catch (Throwable e) {
                e = e instanceof RemoteException ? ((RemoteException)e).unwrapRemoteException() : e;
                LOG.error("Shutdown / close of WAL failed: " + e);
                LOG.debug("Shutdown / close exception details:", e);
            }
        }
    }

    public NamedQueueRecorder getNamedQueueRecorder() {
        return this.namedQueueRecorder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleReportForDutyResponse(RegionServerStatusProtos.RegionServerStartupResponse c) throws IOException {
        try {
            boolean updateRootDir = false;
            for (HBaseProtos.NameStringPair e : c.getMapEntriesList()) {
                String key = e.getName();
                if (key.equals("hbase.regionserver.hostname.seen.by.master")) {
                    boolean isHostnameConsist;
                    String hostnameFromMasterPOV = e.getValue();
                    this.serverName = ServerName.valueOf((String)hostnameFromMasterPOV, (int)this.rpcServices.getSocketAddress().getPort(), (long)this.startcode);
                    String expectedHostName = this.rpcServices.getSocketAddress().getHostName();
                    if (StringUtils.isBlank((CharSequence)this.useThisHostnameInstead) && this.getActiveMaster().isPresent() && InetAddresses.isInetAddress((String)this.getActiveMaster().get().getHostname())) {
                        expectedHostName = this.rpcServices.getSocketAddress().getAddress().getHostAddress();
                    }
                    if (isHostnameConsist = StringUtils.isBlank((CharSequence)this.useThisHostnameInstead) ? hostnameFromMasterPOV.equals(expectedHostName) : hostnameFromMasterPOV.equals(this.useThisHostnameInstead)) continue;
                    String msg = "Master passed us a different hostname to use; was=" + (StringUtils.isBlank((CharSequence)this.useThisHostnameInstead) ? expectedHostName : this.useThisHostnameInstead) + ", but now=" + hostnameFromMasterPOV;
                    LOG.error(msg);
                    throw new IOException(msg);
                }
                String value = e.getValue();
                if (key.equals("hbase.rootdir") && value != null && !value.equals(this.conf.get("hbase.rootdir"))) {
                    updateRootDir = true;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Config from master: " + key + "=" + value);
                }
                this.conf.set(key, value);
            }
            this.createMyEphemeralNode();
            if (updateRootDir) {
                this.initializeFileSystem();
            }
            if (this.conf.get("mapreduce.task.attempt.id") == null) {
                this.conf.set("mapreduce.task.attempt.id", "hb_rs_" + this.serverName.toString());
            }
            ZNodeClearer.writeMyEphemeralNodeOnDisk(this.getMyEphemeralNodePath());
            this.setupWALAndReplication();
            MetricsTable metricsTable = new MetricsTable(new MetricsTableWrapperAggregateImpl(this));
            this.metricsRegionServerImpl = new MetricsRegionServerWrapperImpl(this);
            this.metricsRegionServer = new MetricsRegionServer(this.metricsRegionServerImpl, this.conf, metricsTable);
            this.pauseMonitor = new JvmPauseMonitor(this.conf, (JvmPauseMonitorSource)this.getMetrics().getMetricsSource());
            this.pauseMonitor.start();
            if (this.getConfiguration().getBoolean("hbase.regionserver.workers", true)) {
                this.startServices();
            }
            this.startReplicationService();
            LOG.info("Serving as " + this.serverName + ", RpcServer on " + this.rpcServices.isa + ", sessionid=0x" + Long.toHexString(this.zooKeeper.getRecoverableZooKeeper().getSessionId()));
            AtomicBoolean atomicBoolean = this.online;
            synchronized (atomicBoolean) {
                this.online.set(true);
                this.online.notifyAll();
            }
        }
        catch (Throwable e) {
            this.stop("Failed initialization");
            throw this.convertThrowableToIOE(this.cleanup(e, "Failed init"), "Region server startup failed");
        }
        finally {
            this.sleeper.skipSleepCycle();
        }
    }

    protected void initializeMemStoreChunkCreator() {
        if (MemStoreLAB.isEnabled(this.conf)) {
            Pair<Long, MemoryType> pair = MemorySizeUtil.getGlobalMemStoreSize(this.conf);
            long globalMemStoreSize = (Long)pair.getFirst();
            boolean offheap = this.regionServerAccounting.isOffheap();
            float poolSizePercentage = offheap ? 1.0f : this.conf.getFloat("hbase.hregion.memstore.chunkpool.maxsize", 1.0f);
            float initialCountPercentage = this.conf.getFloat("hbase.hregion.memstore.chunkpool.initialsize", 0.0f);
            int chunkSize = this.conf.getInt("hbase.hregion.memstore.mslab.chunksize", 0x200000);
            float indexChunkSizePercent = this.conf.getFloat("hbase.hregion.memstore.mslab.indexchunksize.percent", 0.1f);
            ChunkCreator.initialize(chunkSize, offheap, globalMemStoreSize, poolSizePercentage, initialCountPercentage, this.hMemManager, indexChunkSizePercent);
        }
    }

    private void startHeapMemoryManager() {
        if (this.blockCache != null) {
            this.hMemManager = new HeapMemoryManager(this.blockCache, this.cacheFlusher, this, this.regionServerAccounting);
            this.hMemManager.start(this.getChoreService());
        }
    }

    private void createMyEphemeralNode() throws KeeperException {
        HBaseProtos.RegionServerInfo.Builder rsInfo = HBaseProtos.RegionServerInfo.newBuilder();
        rsInfo.setInfoPort(this.infoServer != null ? this.infoServer.getPort() : -1);
        rsInfo.setVersionInfo(ProtobufUtil.getVersionInfo());
        byte[] data = ProtobufUtil.prependPBMagic((byte[])rsInfo.build().toByteArray());
        ZKUtil.createEphemeralNodeAndWatch((ZKWatcher)this.zooKeeper, (String)this.getMyEphemeralNodePath(), (byte[])data);
    }

    private void deleteMyEphemeralNode() throws KeeperException {
        ZKUtil.deleteNode((ZKWatcher)this.zooKeeper, (String)this.getMyEphemeralNodePath());
    }

    @Override
    public RegionServerAccounting getRegionServerAccounting() {
        return this.regionServerAccounting;
    }

    private static int roundSize(long sizeInByte, int sizeUnit) {
        if (sizeInByte == 0L) {
            return 0;
        }
        if (sizeInByte < (long)sizeUnit) {
            return 1;
        }
        return (int)Math.min(sizeInByte / (long)sizeUnit, Integer.MAX_VALUE);
    }

    private void computeIfPersistentBucketCache(Consumer<BucketCache> computation) {
        BlockCache l2;
        if (this.blockCache instanceof CombinedBlockCache && (l2 = ((CombinedBlockCache)this.blockCache).getSecondLevelCache()) instanceof BucketCache && ((BucketCache)l2).isCachePersistent()) {
            computation.accept((BucketCache)l2);
        }
    }

    ClusterStatusProtos.RegionLoad createRegionLoad(HRegion r, ClusterStatusProtos.RegionLoad.Builder regionLoadBldr, HBaseProtos.RegionSpecifier.Builder regionSpecifier) throws IOException {
        byte[] name = r.getRegionInfo().getRegionName();
        String regionEncodedName = r.getRegionInfo().getEncodedName();
        int stores = 0;
        int storefiles = 0;
        int storeRefCount = 0;
        int maxCompactedStoreFileRefCount = 0;
        long storeUncompressedSize = 0L;
        long storefileSize = 0L;
        long storefileIndexSize = 0L;
        long rootLevelIndexSize = 0L;
        long totalStaticIndexSize = 0L;
        long totalStaticBloomSize = 0L;
        long totalCompactingKVs = 0L;
        long currentCompactedKVs = 0L;
        long totalRegionSize = 0L;
        List<HStore> storeList = r.getStores();
        stores += storeList.size();
        for (HStore store : storeList) {
            storefiles += store.getStorefilesCount();
            int currentStoreRefCount = store.getStoreRefCount();
            storeRefCount += currentStoreRefCount;
            int currentMaxCompactedStoreFileRefCount = store.getMaxCompactedStoreFileRefCount();
            maxCompactedStoreFileRefCount = Math.max(maxCompactedStoreFileRefCount, currentMaxCompactedStoreFileRefCount);
            storeUncompressedSize += store.getStoreSizeUncompressed();
            storefileSize += store.getStorefilesSize();
            totalRegionSize += store.getHFilesSize();
            storefileIndexSize += store.getStorefilesRootLevelIndexSize();
            CompactionProgress progress = store.getCompactionProgress();
            if (progress != null) {
                totalCompactingKVs += progress.getTotalCompactingKVs();
                currentCompactedKVs += progress.currentCompactedKVs;
            }
            rootLevelIndexSize += store.getStorefilesRootLevelIndexSize();
            totalStaticIndexSize += store.getTotalStaticIndexSize();
            totalStaticBloomSize += store.getTotalStaticBloomSize();
        }
        int memstoreSizeMB = HRegionServer.roundSize(r.getMemStoreDataSize(), this.unitMB);
        int storeUncompressedSizeMB = HRegionServer.roundSize(storeUncompressedSize, this.unitMB);
        int storefileSizeMB = HRegionServer.roundSize(storefileSize, this.unitMB);
        int storefileIndexSizeKB = HRegionServer.roundSize(storefileIndexSize, this.unitKB);
        int rootLevelIndexSizeKB = HRegionServer.roundSize(rootLevelIndexSize, this.unitKB);
        int totalStaticIndexSizeKB = HRegionServer.roundSize(totalStaticIndexSize, this.unitKB);
        int totalStaticBloomSizeKB = HRegionServer.roundSize(totalStaticBloomSize, this.unitKB);
        int regionSizeMB = HRegionServer.roundSize(totalRegionSize, this.unitMB);
        MutableFloat currentRegionCachedRatio = new MutableFloat(0.0f);
        this.getBlockCache().ifPresent(bc -> bc.getRegionCachedInfo().ifPresent(regionCachedInfo -> {
            if (regionCachedInfo.containsKey(regionEncodedName)) {
                currentRegionCachedRatio.setValue(regionSizeMB == 0 ? 0.0f : (float)HRegionServer.roundSize((Long)regionCachedInfo.get(regionEncodedName), this.unitMB) / (float)regionSizeMB);
            }
        }));
        HDFSBlocksDistribution hdfsBd = r.getHDFSBlocksDistribution();
        float dataLocality = hdfsBd.getBlockLocalityIndex(this.serverName.getHostname());
        float dataLocalityForSsd = hdfsBd.getBlockLocalityIndexForSsd(this.serverName.getHostname());
        long blocksTotalWeight = hdfsBd.getUniqueBlocksTotalWeight();
        long blocksLocalWeight = hdfsBd.getBlocksLocalWeight(this.serverName.getHostname());
        long blocksLocalWithSsdWeight = hdfsBd.getBlocksLocalWithSsdWeight(this.serverName.getHostname());
        if (regionLoadBldr == null) {
            regionLoadBldr = ClusterStatusProtos.RegionLoad.newBuilder();
        }
        if (regionSpecifier == null) {
            regionSpecifier = HBaseProtos.RegionSpecifier.newBuilder();
        }
        regionSpecifier.setType(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME);
        regionSpecifier.setValue(UnsafeByteOperations.unsafeWrap((byte[])name));
        regionLoadBldr.setRegionSpecifier(regionSpecifier.build()).setStores(stores).setStorefiles(storefiles).setStoreRefCount(storeRefCount).setMaxCompactedStoreFileRefCount(maxCompactedStoreFileRefCount).setStoreUncompressedSizeMB(storeUncompressedSizeMB).setStorefileSizeMB(storefileSizeMB).setMemStoreSizeMB(memstoreSizeMB).setStorefileIndexSizeKB((long)storefileIndexSizeKB).setRootIndexSizeKB(rootLevelIndexSizeKB).setTotalStaticIndexSizeKB(totalStaticIndexSizeKB).setTotalStaticBloomSizeKB(totalStaticBloomSizeKB).setReadRequestsCount(r.getReadRequestsCount()).setFilteredReadRequestsCount(r.getFilteredReadRequestsCount()).setWriteRequestsCount(r.getWriteRequestsCount()).setTotalCompactingKVs(totalCompactingKVs).setCurrentCompactedKVs(currentCompactedKVs).setDataLocality(dataLocality).setDataLocalityForSsd(dataLocalityForSsd).setBlocksLocalWeight(blocksLocalWeight).setBlocksLocalWithSsdWeight(blocksLocalWithSsdWeight).setBlocksTotalWeight(blocksTotalWeight).setCompactionState(ProtobufUtil.createCompactionStateForRegionLoad((CompactionState)r.getCompactionState())).setLastMajorCompactionTs(r.getOldestHfileTs(true)).setRegionSizeMB(regionSizeMB).setCurrentRegionCachedRatio(currentRegionCachedRatio.floatValue());
        r.setCompleteSequenceId(regionLoadBldr);
        return regionLoadBldr.build();
    }

    private ClusterStatusProtos.UserLoad createUserLoad(String user, MetricsUserSource userSource) {
        ClusterStatusProtos.UserLoad.Builder userLoadBldr = ClusterStatusProtos.UserLoad.newBuilder();
        userLoadBldr.setUserName(user);
        userSource.getClientMetrics().values().stream().map(clientMetrics -> ClusterStatusProtos.ClientMetrics.newBuilder().setHostName(clientMetrics.getHostName()).setWriteRequestsCount(clientMetrics.getWriteRequestsCount()).setFilteredRequestsCount(clientMetrics.getFilteredReadRequests()).setReadRequestsCount(clientMetrics.getReadRequestsCount()).build()).forEach(arg_0 -> ((ClusterStatusProtos.UserLoad.Builder)userLoadBldr).addClientMetrics(arg_0));
        return userLoadBldr.build();
    }

    public ClusterStatusProtos.RegionLoad createRegionLoad(String encodedRegionName) throws IOException {
        HRegion r = this.onlineRegions.get(encodedRegionName);
        return r != null ? this.createRegionLoad(r, null, null) : null;
    }

    public boolean isOnline() {
        return this.online.get();
    }

    private void setupWALAndReplication() throws IOException {
        WALFactory factory = new WALFactory(this.conf, this.serverName.toString(), this);
        Path oldLogDir = new Path(this.walRootDir, "oldWALs");
        String logName = AbstractFSWALProvider.getWALDirectoryName(this.serverName.toString());
        Path logDir = new Path(this.walRootDir, logName);
        LOG.debug("logDir={}", (Object)logDir);
        if (this.walFs.exists(logDir)) {
            throw new RegionServerRunningException("Region server has already created directory at " + this.serverName.toString());
        }
        if (!this.walFs.mkdirs(logDir)) {
            throw new IOException("Can not create wal directory " + logDir);
        }
        HRegionServer.createNewReplicationInstance(this.conf, this, (FileSystem)this.walFs, logDir, oldLogDir, factory);
        WALActionsListener walEventListener = this.getWALEventTrackerListener(this.conf);
        if (walEventListener != null && factory.getWALProvider() != null) {
            factory.getWALProvider().addWALActionsListener(walEventListener);
        }
        this.walFactory = factory;
    }

    private WALActionsListener getWALEventTrackerListener(Configuration conf) {
        if (conf.getBoolean("hbase.regionserver.wal.event.tracker.enabled", false)) {
            WALEventTrackerListener listener = new WALEventTrackerListener(conf, this.getNamedQueueRecorder(), this.getServerName());
            return listener;
        }
        return null;
    }

    private void startReplicationService() throws IOException {
        if (this.replicationSourceHandler == this.replicationSinkHandler && this.replicationSourceHandler != null) {
            this.replicationSourceHandler.startReplicationService();
        } else {
            if (this.replicationSourceHandler != null) {
                this.replicationSourceHandler.startReplicationService();
            }
            if (this.replicationSinkHandler != null) {
                this.replicationSinkHandler.startReplicationService();
            }
        }
    }

    public MasterAddressTracker getMasterAddressTracker() {
        return this.masterAddressTracker;
    }

    private void startServices() throws IOException {
        if (!this.isStopped() && !this.isAborted()) {
            this.initializeThreads();
        }
        this.secureBulkLoadManager = new SecureBulkLoadManager(this.conf, (Connection)this.clusterConnection);
        this.secureBulkLoadManager.start();
        if (this.isHealthCheckerConfigured()) {
            int sleepTime = this.conf.getInt("hbase.node.health.script.frequency", 10000);
            this.healthCheckChore = new HealthCheckChore(sleepTime, this, this.getConfiguration());
        }
        this.walRoller = new LogRoller(this);
        this.flushThroughputController = FlushThroughputControllerFactory.create(this, this.conf);
        this.procedureResultReporter = new RemoteProcedureResultReporter(this);
        int cleanerInterval = this.conf.getInt("hbase.hfile.compaction.discharger.interval", 120000);
        this.compactedFileDischarger = new CompactedHFilesDischarger(cleanerInterval, this, this);
        this.choreService.scheduleChore((ScheduledChore)this.compactedFileDischarger);
        int openRegionThreads = this.conf.getInt("hbase.regionserver.executor.openregion.threads", 3);
        this.executorService.startExecutorService(this.executorService.new ExecutorService.ExecutorConfig().setExecutorType(ExecutorType.RS_OPEN_REGION).setCorePoolSize(openRegionThreads));
        int openMetaThreads = this.conf.getInt("hbase.regionserver.executor.openmeta.threads", 1);
        this.executorService.startExecutorService(this.executorService.new ExecutorService.ExecutorConfig().setExecutorType(ExecutorType.RS_OPEN_META).setCorePoolSize(openMetaThreads));
        int openPriorityRegionThreads = this.conf.getInt("hbase.regionserver.executor.openpriorityregion.threads", 3);
        this.executorService.startExecutorService(this.executorService.new ExecutorService.ExecutorConfig().setExecutorType(ExecutorType.RS_OPEN_PRIORITY_REGION).setCorePoolSize(openPriorityRegionThreads));
        int closeRegionThreads = this.conf.getInt("hbase.regionserver.executor.closeregion.threads", 3);
        this.executorService.startExecutorService(this.executorService.new ExecutorService.ExecutorConfig().setExecutorType(ExecutorType.RS_CLOSE_REGION).setCorePoolSize(closeRegionThreads));
        int closeMetaThreads = this.conf.getInt("hbase.regionserver.executor.closemeta.threads", 1);
        this.executorService.startExecutorService(this.executorService.new ExecutorService.ExecutorConfig().setExecutorType(ExecutorType.RS_CLOSE_META).setCorePoolSize(closeMetaThreads));
        if (this.conf.getBoolean("hbase.storescanner.parallel.seek.enable", false)) {
            int storeScannerParallelSeekThreads = this.conf.getInt("hbase.storescanner.parallel.seek.threads", 10);
            this.executorService.startExecutorService(this.executorService.new ExecutorService.ExecutorConfig().setExecutorType(ExecutorType.RS_PARALLEL_SEEK).setCorePoolSize(storeScannerParallelSeekThreads).setAllowCoreThreadTimeout(true));
        }
        int logReplayOpsThreads = this.conf.getInt("hbase.regionserver.wal.max.splitters", 2);
        this.executorService.startExecutorService(this.executorService.new ExecutorService.ExecutorConfig().setExecutorType(ExecutorType.RS_LOG_REPLAY_OPS).setCorePoolSize(logReplayOpsThreads).setAllowCoreThreadTimeout(true));
        int compactionDischargerThreads = this.conf.getInt("hbase.hfile.compaction.discharger.thread.count", 10);
        this.executorService.startExecutorService(this.executorService.new ExecutorService.ExecutorConfig().setExecutorType(ExecutorType.RS_COMPACTED_FILES_DISCHARGER).setCorePoolSize(compactionDischargerThreads));
        if (ServerRegionReplicaUtil.isRegionReplicaWaitForPrimaryFlushEnabled(this.conf)) {
            int regionReplicaFlushThreads = this.conf.getInt("hbase.regionserver.region.replica.flusher.threads", this.conf.getInt("hbase.regionserver.executor.openregion.threads", 3));
            this.executorService.startExecutorService(this.executorService.new ExecutorService.ExecutorConfig().setExecutorType(ExecutorType.RS_REGION_REPLICA_FLUSH_OPS).setCorePoolSize(regionReplicaFlushThreads));
        }
        int refreshPeerThreads = this.conf.getInt("hbase.regionserver.executor.refresh.peer.threads", 2);
        this.executorService.startExecutorService(this.executorService.new ExecutorService.ExecutorConfig().setExecutorType(ExecutorType.RS_REFRESH_PEER).setCorePoolSize(refreshPeerThreads));
        int switchRpcThrottleThreads = this.conf.getInt("hbase.regionserver.executor.switch.rpc.throttle.threads", 1);
        this.executorService.startExecutorService(this.executorService.new ExecutorService.ExecutorConfig().setExecutorType(ExecutorType.RS_SWITCH_RPC_THROTTLE).setCorePoolSize(switchRpcThrottleThreads));
        int claimReplicationQueueThreads = this.conf.getInt("hbase.regionserver.executor.claim.replication.queue.threads", 1);
        this.executorService.startExecutorService(this.executorService.new ExecutorService.ExecutorConfig().setExecutorType(ExecutorType.RS_CLAIM_REPLICATION_QUEUE).setCorePoolSize(claimReplicationQueueThreads));
        int rsSnapshotOperationThreads = this.conf.getInt("hbase.regionserver.executor.snapshot.operations.threads", 3);
        this.executorService.startExecutorService(this.executorService.new ExecutorService.ExecutorConfig().setExecutorType(ExecutorType.RS_SNAPSHOT_OPERATIONS).setCorePoolSize(rsSnapshotOperationThreads));
        int rsFlushOperationThreads = this.conf.getInt("hbase.regionserver.executor.flush.operations.threads", 3);
        this.executorService.startExecutorService(this.executorService.new ExecutorService.ExecutorConfig().setExecutorType(ExecutorType.RS_FLUSH_OPERATIONS).setCorePoolSize(rsFlushOperationThreads));
        Threads.setDaemonThreadRunning((Thread)this.walRoller, (String)(this.getName() + ".logRoller"), (Thread.UncaughtExceptionHandler)this.uncaughtExceptionHandler);
        if (this.cacheFlusher != null) {
            this.cacheFlusher.start(this.uncaughtExceptionHandler);
        }
        Threads.setDaemonThreadRunning((Thread)this.procedureResultReporter, (String)(this.getName() + ".procedureResultReporter"), (Thread.UncaughtExceptionHandler)this.uncaughtExceptionHandler);
        if (this.compactionChecker != null) {
            this.choreService.scheduleChore(this.compactionChecker);
        }
        if (this.periodicFlusher != null) {
            this.choreService.scheduleChore(this.periodicFlusher);
        }
        if (this.healthCheckChore != null) {
            this.choreService.scheduleChore((ScheduledChore)this.healthCheckChore);
        }
        if (this.nonceManagerChore != null) {
            this.choreService.scheduleChore(this.nonceManagerChore);
        }
        if (this.storefileRefresher != null) {
            this.choreService.scheduleChore((ScheduledChore)this.storefileRefresher);
        }
        if (this.fsUtilizationChore != null) {
            this.choreService.scheduleChore((ScheduledChore)this.fsUtilizationChore);
        }
        if (this.namedQueueServiceChore != null) {
            this.choreService.scheduleChore((ScheduledChore)this.namedQueueServiceChore);
        }
        if (this.brokenStoreFileCleaner != null) {
            this.choreService.scheduleChore((ScheduledChore)this.brokenStoreFileCleaner);
        }
        if (this.rsMobFileCleanerChore != null) {
            this.choreService.scheduleChore((ScheduledChore)this.rsMobFileCleanerChore);
        }
        if (this.replicationMarkerChore != null) {
            LOG.info("Starting replication marker chore");
            this.choreService.scheduleChore((ScheduledChore)this.replicationMarkerChore);
        }
        Threads.setDaemonThreadRunning((Thread)this.leaseManager, (String)(this.getName() + ".leaseChecker"), (Thread.UncaughtExceptionHandler)this.uncaughtExceptionHandler);
        Configuration sinkConf = HBaseConfiguration.create((Configuration)this.conf);
        sinkConf.setInt("hbase.client.retries.number", this.conf.getInt("hbase.log.replay.retries.number", 8));
        sinkConf.setInt("hbase.rpc.timeout", this.conf.getInt("hbase.log.replay.rpc.timeout", 30000));
        sinkConf.setInt("hbase.client.serverside.retries.multiplier", 1);
        if (this.csm != null && this.conf.getBoolean("hbase.split.wal.zk.coordinated", false)) {
            this.splitLogWorker = new SplitLogWorker(sinkConf, this, this, this.walFactory);
            this.splitLogWorker.start();
            LOG.debug("SplitLogWorker started");
        }
        this.startHeapMemoryManager();
        this.initializeMemStoreChunkCreator();
    }

    private void initializeThreads() {
        this.cacheFlusher = new MemStoreFlusher(this.conf, this);
        this.compactSplitThread = new CompactSplit(this);
        this.prefetchExecutorNotifier = new PrefetchExecutorNotifier(this.conf);
        this.compactionChecker = new CompactionChecker(this, this.compactionCheckFrequency, this);
        this.periodicFlusher = new PeriodicMemStoreFlusher(this.flushCheckFrequency, this);
        this.leaseManager = new LeaseManager(this.threadWakeFrequency);
        boolean isSlowLogTableEnabled = this.conf.getBoolean("hbase.regionserver.slowlog.systable.enabled", false);
        boolean walEventTrackerEnabled = this.conf.getBoolean("hbase.regionserver.wal.event.tracker.enabled", false);
        if (isSlowLogTableEnabled || walEventTrackerEnabled) {
            int slowLogChoreDuration = this.conf.getInt("hbase.slowlog.systable.chore.duration", 600000);
            int namedQueueChoreDuration = this.conf.getInt("hbase.regionserver.named.queue.chore.duration", 600000);
            int choreDuration = Math.min(slowLogChoreDuration, namedQueueChoreDuration);
            this.namedQueueServiceChore = new NamedQueueServiceChore(this, choreDuration, this.namedQueueRecorder, this.getConnection());
        }
        if (this.nonceManager != null) {
            this.nonceManagerChore = this.nonceManager.createCleanupScheduledChore(this);
        }
        this.rsQuotaManager = new RegionServerRpcQuotaManager(this);
        this.rsSpaceQuotaManager = new RegionServerSpaceQuotaManager(this);
        if (QuotaUtil.isQuotaEnabled(this.conf)) {
            this.fsUtilizationChore = new FileSystemUtilizationChore(this);
        }
        boolean onlyMetaRefresh = false;
        int storefileRefreshPeriod = this.conf.getInt("hbase.regionserver.storefile.refresh.period", 0);
        if (storefileRefreshPeriod == 0) {
            storefileRefreshPeriod = this.conf.getInt("hbase.regionserver.meta.storefile.refresh.period", 0);
            onlyMetaRefresh = true;
        }
        if (storefileRefreshPeriod > 0) {
            this.storefileRefresher = new StorefileRefresherChore(storefileRefreshPeriod, onlyMetaRefresh, this, this);
        }
        int brokenStoreFileCleanerPeriod = this.conf.getInt("hbase.region.broken.storefilecleaner.period", 21600000);
        int brokenStoreFileCleanerDelay = this.conf.getInt("hbase.region.broken.storefilecleaner.delay", 0x6DDD00);
        double brokenStoreFileCleanerDelayJitter = this.conf.getDouble("hbase.region.broken.storefilecleaner.delay.jitter", 0.25);
        double jitterRate = (ThreadLocalRandom.current().nextDouble() - 0.5) * brokenStoreFileCleanerDelayJitter;
        long jitterValue = Math.round((double)brokenStoreFileCleanerDelay * jitterRate);
        this.brokenStoreFileCleaner = new BrokenStoreFileCleaner((int)((long)brokenStoreFileCleanerDelay + jitterValue), brokenStoreFileCleanerPeriod, this, this.conf, this);
        this.rsMobFileCleanerChore = new RSMobFileCleanerChore(this);
        this.registerConfigurationObservers();
        this.initializeReplicationMarkerChore();
    }

    private void registerConfigurationObservers() {
        if (this.replicationSourceHandler instanceof ConfigurationObserver) {
            this.configurationManager.registerObserver((ConfigurationObserver)this.replicationSourceHandler);
        }
        if (this.replicationSourceHandler != this.replicationSinkHandler && this.replicationSinkHandler instanceof ConfigurationObserver) {
            this.configurationManager.registerObserver((ConfigurationObserver)this.replicationSinkHandler);
        }
        this.configurationManager.registerObserver((ConfigurationObserver)this.compactSplitThread);
        this.configurationManager.registerObserver((ConfigurationObserver)this.cacheFlusher);
        this.configurationManager.registerObserver((ConfigurationObserver)this.rpcServices);
        this.configurationManager.registerObserver((ConfigurationObserver)this.prefetchExecutorNotifier);
        this.configurationManager.registerObserver((ConfigurationObserver)this);
    }

    private void putUpWebUI() throws IOException {
        int port = this.conf.getInt("hbase.regionserver.info.port", 16030);
        String addr = this.conf.get("hbase.regionserver.info.bindAddress", "0.0.0.0");
        boolean isMaster = false;
        if (this instanceof HMaster) {
            port = this.conf.getInt("hbase.master.info.port", 16010);
            addr = this.conf.get("hbase.master.info.bindAddress", "0.0.0.0");
            isMaster = true;
        }
        if (port < 0) {
            return;
        }
        if (!Addressing.isLocalAddress((InetAddress)InetAddress.getByName(addr))) {
            String msg = "Failed to start http info server. Address " + addr + " does not belong to this host. Correct configuration parameter: " + (isMaster ? "hbase.master.info.bindAddress" : "hbase.regionserver.info.bindAddress");
            LOG.error(msg);
            throw new IOException(msg);
        }
        boolean auto = this.conf.getBoolean("hbase.regionserver.info.port.auto", false);
        while (true) {
            try {
                this.infoServer = new InfoServer(this.getProcessName(), addr, port, false, this.conf);
                this.infoServer.addPrivilegedServlet("dump", "/dump", this.getDumpServlet());
                this.configureInfoServer();
                this.infoServer.start();
            }
            catch (BindException e) {
                if (!auto) {
                    LOG.error("Failed binding http info server to port: " + port);
                    throw e;
                }
                LOG.info("Failed binding http info server to port: " + port);
                LOG.info("Retry starting http info server with port: " + ++port);
                continue;
            }
            break;
        }
        port = this.infoServer.getPort();
        this.conf.setInt("hbase.regionserver.info.port", port);
        int masterInfoPort = this.conf.getInt("hbase.master.info.port", 16010);
        this.conf.setInt("hbase.master.info.port.orig", masterInfoPort);
        this.conf.setInt("hbase.master.info.port", port);
    }

    private boolean isHealthy() {
        boolean healthy;
        if (!this.dataFsOk) {
            return false;
        }
        boolean bl = healthy = !(this.leaseManager != null && !this.leaseManager.isAlive() || this.cacheFlusher != null && !this.cacheFlusher.isAlive() || this.walRoller != null && !this.walRoller.isAlive() || this.compactionChecker != null && !this.compactionChecker.isScheduled() || this.periodicFlusher != null && !this.periodicFlusher.isScheduled());
        if (!healthy) {
            this.stop("One or more threads are no longer alive -- stop");
        }
        return healthy;
    }

    @Override
    public List<WAL> getWALs() {
        return this.walFactory.getWALs();
    }

    @Override
    public WAL getWAL(RegionInfo regionInfo) throws IOException {
        try {
            WAL wal = this.walFactory.getWAL(regionInfo);
            if (this.walRoller != null) {
                this.walRoller.addWAL(wal);
            }
            return wal;
        }
        catch (FailedCloseWALAfterInitializedErrorException ex) {
            this.abort("WAL can not clean up after init failed", ex);
            throw ex;
        }
    }

    public LogRoller getWalRoller() {
        return this.walRoller;
    }

    WALFactory getWalFactory() {
        return this.walFactory;
    }

    @Override
    public Connection getConnection() {
        return this.getClusterConnection();
    }

    @Override
    public ClusterConnection getClusterConnection() {
        return this.clusterConnection;
    }

    public void stop(String msg) {
        this.stop(msg, false, RpcServer.getRequestUser().orElse(null));
    }

    public void stop(String msg, boolean force, User user) {
        if (!this.stopped) {
            LOG.info("***** STOPPING region server '" + this + "' *****");
            if (this.rsHost != null) {
                try {
                    this.rsHost.preStop(msg, user);
                }
                catch (IOException ioe) {
                    if (!force) {
                        LOG.warn("The region server did not stop", (Throwable)ioe);
                        return;
                    }
                    LOG.warn("Skipping coprocessor exception on preStop() due to forced shutdown", (Throwable)ioe);
                }
            }
            this.stopped = true;
            LOG.info("STOPPED: " + msg);
            this.sleeper.skipSleepCycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForServerOnline() {
        while (!this.isStopped() && !this.isOnline()) {
            AtomicBoolean atomicBoolean = this.online;
            synchronized (atomicBoolean) {
                try {
                    this.online.wait(this.msgInterval);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
    }

    @Override
    public void postOpenDeployTasks(RegionServerServices.PostOpenDeployContext context) throws IOException {
        HRegion r = context.getRegion();
        long openProcId = context.getOpenProcId();
        long masterSystemTime = context.getMasterSystemTime();
        long initiatingMasterActiveTime = context.getInitiatingMasterActiveTime();
        this.rpcServices.checkOpen();
        LOG.info("Post open deploy tasks for {}, pid={}, masterSystemTime={}", new Object[]{r.getRegionInfo().getRegionNameAsString(), openProcId, masterSystemTime});
        for (HStore s : r.stores.values()) {
            if (!s.hasReferences() && !s.needsCompaction()) continue;
            this.compactSplitThread.requestSystemCompaction(r, s, "Opening Region");
        }
        long openSeqNum = r.getOpenSeqNum();
        if (openSeqNum == -1L) {
            LOG.error("No sequence number found when opening " + r.getRegionInfo().getRegionNameAsString());
            openSeqNum = 0L;
        }
        if (!this.reportRegionStateTransition(new RegionServerServices.RegionStateTransitionContext(RegionServerStatusProtos.RegionStateTransition.TransitionCode.OPENED, openSeqNum, openProcId, masterSystemTime, r.getRegionInfo(), initiatingMasterActiveTime))) {
            throw new IOException("Failed to report opened region to master: " + r.getRegionInfo().getRegionNameAsString());
        }
        this.triggerFlushInPrimaryRegion(r);
        LOG.debug("Finished post open deploy task for " + r.getRegionInfo().getRegionNameAsString());
    }

    private boolean skipReportingTransition(RegionServerServices.RegionStateTransitionContext context) {
        RegionServerStatusProtos.RegionStateTransition.TransitionCode code = context.getCode();
        long openSeqNum = context.getOpenSeqNum();
        long masterSystemTime = context.getMasterSystemTime();
        RegionInfo[] hris = context.getHris();
        if (code == RegionServerStatusProtos.RegionStateTransition.TransitionCode.OPENED) {
            Preconditions.checkArgument((hris != null && hris.length == 1 ? 1 : 0) != 0);
            if (hris[0].isMetaRegion()) {
                LOG.warn("meta table location is stored in master local store, so we can not skip reporting");
                return false;
            }
            try {
                MetaTableAccessor.updateRegionLocation((Connection)this.clusterConnection, (RegionInfo)hris[0], (ServerName)this.serverName, (long)openSeqNum, (long)masterSystemTime);
            }
            catch (IOException e) {
                LOG.info("Failed to update meta", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    private RegionServerStatusProtos.ReportRegionStateTransitionRequest createReportRegionStateTransitionRequest(RegionServerServices.RegionStateTransitionContext context) {
        RegionServerStatusProtos.RegionStateTransition.TransitionCode code = context.getCode();
        long openSeqNum = context.getOpenSeqNum();
        RegionInfo[] hris = context.getHris();
        long[] procIds = context.getProcIds();
        RegionServerStatusProtos.ReportRegionStateTransitionRequest.Builder builder = RegionServerStatusProtos.ReportRegionStateTransitionRequest.newBuilder();
        builder.setServer(ProtobufUtil.toServerName((ServerName)this.serverName));
        RegionServerStatusProtos.RegionStateTransition.Builder transition = builder.addTransitionBuilder();
        transition.setTransitionCode(code);
        if (code == RegionServerStatusProtos.RegionStateTransition.TransitionCode.OPENED && openSeqNum >= 0L) {
            transition.setOpenSeqNum(openSeqNum);
        }
        for (RegionInfo hri : hris) {
            transition.addRegionInfo(ProtobufUtil.toRegionInfo((RegionInfo)hri));
        }
        for (long procId : procIds) {
            transition.addProcId(procId);
        }
        transition.setInitiatingMasterActiveTime(context.getInitiatingMasterActiveTime());
        return builder.build();
    }

    @Override
    public boolean reportRegionStateTransition(RegionServerServices.RegionStateTransitionContext context) {
        if (TEST_SKIP_REPORTING_TRANSITION) {
            return this.skipReportingTransition(context);
        }
        RegionServerStatusProtos.ReportRegionStateTransitionRequest request = this.createReportRegionStateTransitionRequest(context);
        int tries = 0;
        long pauseTime = this.retryPauseTime;
        while (this.clusterConnection != null && !this.clusterConnection.isClosed()) {
            RegionServerStatusProtos.RegionServerStatusService.BlockingInterface rss = this.rssStub;
            try {
                if (rss == null) {
                    this.createRegionServerStatusStub();
                    continue;
                }
                RegionServerStatusProtos.ReportRegionStateTransitionResponse response = rss.reportRegionStateTransition(null, request);
                if (!response.hasErrorMessage()) {
                    if (tries > 0 || LOG.isTraceEnabled()) {
                        LOG.info("TRANSITION REPORTED " + request);
                    }
                    return true;
                }
                LOG.info("TRANSITION FAILED " + request + ": " + response.getErrorMessage());
                break;
            }
            catch (ServiceException se) {
                IOException ioe = ProtobufUtil.getRemoteException((ServiceException)se);
                boolean pause = ioe instanceof ServerNotRunningYetException || ioe instanceof PleaseHoldException || ioe instanceof CallQueueTooBigException;
                pauseTime = pause ? ConnectionUtils.getPauseTime((long)this.retryPauseTime, (int)tries) : this.retryPauseTime;
                LOG.info("Failed report transition " + TextFormat.shortDebugString((MessageOrBuilder)request) + "; retry (#" + tries + ")" + (pause ? " after " + pauseTime + "ms delay (Master is coming online...)." : " immediately."), (Throwable)ioe);
                if (pause) {
                    Threads.sleep((long)pauseTime);
                }
                ++tries;
                if (this.rssStub != rss) continue;
                this.rssStub = null;
            }
        }
        return false;
    }

    private void triggerFlushInPrimaryRegion(HRegion region) {
        if (ServerRegionReplicaUtil.isDefaultReplica((RegionInfo)region.getRegionInfo())) {
            return;
        }
        TableName tn = region.getTableDescriptor().getTableName();
        if (!(ServerRegionReplicaUtil.isRegionReplicaReplicationEnabled(region.conf, tn) && ServerRegionReplicaUtil.isRegionReplicaWaitForPrimaryFlushEnabled(region.conf) && region.getTableDescriptor().hasRegionMemStoreReplication())) {
            region.setReadsEnabled(true);
            return;
        }
        region.setReadsEnabled(false);
        if (this.executorService != null) {
            this.executorService.submit(new RegionReplicaFlushHandler(this, this.clusterConnection, this.rpcRetryingCallerFactory, this.rpcControllerFactory, this.operationTimeout, region));
        } else {
            LOG.info("Executor is null; not running flush of primary region replica for {}", (Object)region.getRegionInfo());
        }
    }

    @Override
    public RpcServerInterface getRpcServer() {
        return this.rpcServices.rpcServer;
    }

    @InterfaceAudience.Private
    public RSRpcServices getRSRpcServices() {
        return this.rpcServices;
    }

    public void abort(String reason, Throwable cause) {
        if (!this.setAbortRequested()) {
            LOG.debug("Abort already in progress. Ignoring the current request with reason: {}", (Object)reason);
            return;
        }
        String msg = "***** ABORTING region server " + this + ": " + reason + " *****";
        if (cause != null) {
            LOG.error(HBaseMarkers.FATAL, msg, cause);
        } else {
            LOG.error(HBaseMarkers.FATAL, msg);
        }
        LOG.error(HBaseMarkers.FATAL, "RegionServer abort: loaded coprocessors are: " + CoprocessorHost.getLoadedCoprocessors());
        try {
            LOG.info("Dump of metrics as JSON on abort: " + DumpRegionServerMetrics.dumpMetrics());
        }
        catch (IOException | MalformedObjectNameException e) {
            LOG.warn("Failed dumping metrics", (Throwable)e);
        }
        try {
            RegionServerStatusProtos.RegionServerStatusService.BlockingInterface rss;
            if (cause != null) {
                msg = msg + "\nCause:\n" + Throwables.getStackTraceAsString((Throwable)cause);
            }
            if ((rss = this.rssStub) != null && this.serverName != null) {
                RegionServerStatusProtos.ReportRSFatalErrorRequest.Builder builder = RegionServerStatusProtos.ReportRSFatalErrorRequest.newBuilder();
                builder.setServer(ProtobufUtil.toServerName((ServerName)this.serverName));
                builder.setErrorMessage(msg);
                rss.reportRSFatalError(null, builder.build());
            }
        }
        catch (Throwable t) {
            LOG.warn("Unable to report fatal error to master", t);
        }
        this.scheduleAbortTimer();
        this.stop(reason, true, null);
    }

    protected boolean setAbortRequested() {
        return this.abortRequested.compareAndSet(false, true);
    }

    public boolean isAborted() {
        return this.abortRequested.get();
    }

    @InterfaceAudience.Private
    protected void kill() {
        this.killed = true;
        this.abort("Simulated kill");
    }

    private void scheduleAbortTimer() {
        if (this.abortMonitor == null) {
            this.abortMonitor = new Timer("Abort regionserver monitor", true);
            TimerTask abortTimeoutTask = null;
            try {
                Constructor<TimerTask> timerTaskCtor = Class.forName(this.conf.get(ABORT_TIMEOUT_TASK, SystemExitWhenAbortTimeout.class.getName())).asSubclass(TimerTask.class).getDeclaredConstructor(new Class[0]);
                timerTaskCtor.setAccessible(true);
                abortTimeoutTask = timerTaskCtor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                LOG.warn("Initialize abort timeout task failed", (Throwable)e);
            }
            if (abortTimeoutTask != null) {
                this.abortMonitor.schedule(abortTimeoutTask, this.conf.getLong(ABORT_TIMEOUT, 1200000L));
            }
        }
    }

    protected final void shutdownChore(ScheduledChore chore) {
        if (chore != null) {
            chore.shutdown();
        }
    }

    protected void stopServiceThreads() {
        if (this.choreService != null) {
            this.shutdownChore(this.nonceManagerChore);
            this.shutdownChore(this.compactionChecker);
            this.shutdownChore(this.compactedFileDischarger);
            this.shutdownChore(this.periodicFlusher);
            this.shutdownChore(this.healthCheckChore);
            this.shutdownChore(this.storefileRefresher);
            this.shutdownChore(this.fsUtilizationChore);
            this.shutdownChore(this.namedQueueServiceChore);
            this.shutdownChore(this.replicationMarkerChore);
            this.shutdownChore(this.rsMobFileCleanerChore);
            this.choreService.shutdown();
        }
        if (this.bootstrapNodeManager != null) {
            this.bootstrapNodeManager.stop();
        }
        if (this.cacheFlusher != null) {
            this.cacheFlusher.shutdown();
        }
        if (this.walRoller != null) {
            this.walRoller.close();
        }
        if (this.compactSplitThread != null) {
            this.compactSplitThread.join();
        }
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        if (this.replicationSourceHandler != null && this.replicationSourceHandler == this.replicationSinkHandler) {
            this.replicationSourceHandler.stopReplicationService();
        } else {
            if (this.replicationSourceHandler != null) {
                this.replicationSourceHandler.stopReplicationService();
            }
            if (this.replicationSinkHandler != null) {
                this.replicationSinkHandler.stopReplicationService();
            }
        }
    }

    @InterfaceAudience.Private
    public ReplicationSourceService getReplicationSourceService() {
        return this.replicationSourceHandler;
    }

    ReplicationSinkService getReplicationSinkService() {
        return this.replicationSinkHandler;
    }

    private synchronized ServerName createRegionServerStatusStub() {
        return this.createRegionServerStatusStub(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    protected synchronized ServerName createRegionServerStatusStub(boolean refresh) {
        if (this.rssStub != null) {
            return this.masterAddressTracker.getMasterAddress();
        }
        ServerName sn = null;
        long previousLogTime = 0L;
        MasterRpcServices intRssStub = null;
        MasterRpcServices intLockStub = null;
        boolean interrupted = false;
        try {
            while (this.keepLooping()) {
                sn = this.masterAddressTracker.getMasterAddress(refresh);
                if (sn == null) {
                    if (!this.keepLooping()) {
                        LOG.debug("No master found and cluster is stopped; bailing out");
                        ServerName serverName = null;
                        return serverName;
                    }
                    if (EnvironmentEdgeManager.currentTime() > previousLogTime + 1000L) {
                        LOG.debug("No master found; retry");
                        previousLogTime = EnvironmentEdgeManager.currentTime();
                    }
                    refresh = true;
                    if (!HRegionServer.sleepInterrupted(200L)) continue;
                    interrupted = true;
                    continue;
                }
                if (this instanceof HMaster && sn.equals((Object)this.getServerName())) {
                    intRssStub = ((HMaster)this).getMasterRpcServices();
                    intLockStub = ((HMaster)this).getMasterRpcServices();
                    break;
                }
                try {
                    BlockingRpcChannel channel = this.rpcClient.createBlockingRpcChannel(sn, this.userProvider.getCurrent(), this.shortOperationTimeout);
                    intRssStub = RegionServerStatusProtos.RegionServerStatusService.newBlockingStub((BlockingRpcChannel)channel);
                    intLockStub = LockServiceProtos.LockService.newBlockingStub((BlockingRpcChannel)channel);
                    break;
                }
                catch (IOException e) {
                    if (EnvironmentEdgeManager.currentTime() > previousLogTime + 1000L) {
                        IOException iOException = e = e instanceof RemoteException ? ((RemoteException)((Object)e)).unwrapRemoteException() : e;
                        if (e instanceof ServerNotRunningYetException) {
                            LOG.info("Master isn't available yet, retrying");
                        } else {
                            LOG.warn("Unable to connect to master. Retrying. Error was:", (Throwable)e);
                        }
                        previousLogTime = EnvironmentEdgeManager.currentTime();
                    }
                    if (!HRegionServer.sleepInterrupted(200L)) continue;
                    interrupted = true;
                }
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        this.rssStub = intRssStub;
        this.lockStub = intLockStub;
        return sn;
    }

    private boolean keepLooping() {
        return !this.stopped && this.isClusterUp();
    }

    private RegionServerStatusProtos.RegionServerStartupResponse reportForDuty() throws IOException {
        if (this.masterless) {
            return RegionServerStatusProtos.RegionServerStartupResponse.getDefaultInstance();
        }
        ServerName masterServerName = this.createRegionServerStatusStub(true);
        RegionServerStatusProtos.RegionServerStatusService.BlockingInterface rss = this.rssStub;
        if (masterServerName == null || rss == null) {
            return null;
        }
        RegionServerStatusProtos.RegionServerStartupResponse result = null;
        try {
            this.rpcServices.requestCount.reset();
            this.rpcServices.rpcGetRequestCount.reset();
            this.rpcServices.rpcScanRequestCount.reset();
            this.rpcServices.rpcFullScanRequestCount.reset();
            this.rpcServices.rpcMultiRequestCount.reset();
            this.rpcServices.rpcMutateRequestCount.reset();
            LOG.info("reportForDuty to master=" + masterServerName + " with isa=" + this.rpcServices.isa + ", startcode=" + this.startcode);
            long now = EnvironmentEdgeManager.currentTime();
            int port = this.rpcServices.isa.getPort();
            RegionServerStatusProtos.RegionServerStartupRequest.Builder request = RegionServerStatusProtos.RegionServerStartupRequest.newBuilder();
            if (!StringUtils.isBlank((CharSequence)this.useThisHostnameInstead)) {
                request.setUseThisHostnameInstead(this.useThisHostnameInstead);
            }
            request.setPort(port);
            request.setServerStartCode(this.startcode);
            request.setServerCurrentTime(now);
            result = rss.regionServerStartup(null, request.build());
        }
        catch (ServiceException se) {
            IOException ioe = ProtobufUtil.getRemoteException((ServiceException)se);
            if (ioe instanceof ClockOutOfSyncException) {
                LOG.error(HBaseMarkers.FATAL, "Master rejected startup because clock is out of sync", (Throwable)ioe);
                throw ioe;
            }
            if (ioe instanceof DecommissionedHostRejectedException) {
                LOG.error(HBaseMarkers.FATAL, "Master rejected startup because the host is considered decommissioned", (Throwable)ioe);
                throw ioe;
            }
            if (ioe instanceof ServerNotRunningYetException) {
                LOG.debug("Master is not running yet");
            } else {
                LOG.warn("error telling master we are up", (Throwable)se);
            }
            this.rssStub = null;
        }
        return result;
    }

    @Override
    public ClusterStatusProtos.RegionStoreSequenceIds getLastSequenceId(byte[] encodedRegionName) {
        try {
            RegionServerStatusProtos.GetLastFlushedSequenceIdRequest req = RequestConverter.buildGetLastFlushedSequenceIdRequest((byte[])encodedRegionName);
            RegionServerStatusProtos.RegionServerStatusService.BlockingInterface rss = this.rssStub;
            if (rss == null) {
                this.createRegionServerStatusStub();
                rss = this.rssStub;
                if (rss == null) {
                    LOG.warn("Unable to connect to the master to check the last flushed sequence id");
                    return ClusterStatusProtos.RegionStoreSequenceIds.newBuilder().setLastFlushedSequenceId(-1L).build();
                }
            }
            RegionServerStatusProtos.GetLastFlushedSequenceIdResponse resp = rss.getLastFlushedSequenceId(null, req);
            return ClusterStatusProtos.RegionStoreSequenceIds.newBuilder().setLastFlushedSequenceId(resp.getLastFlushedSequenceId()).addAllStoreSequenceId((Iterable)resp.getStoreLastFlushedSequenceIdList()).build();
        }
        catch (ServiceException e) {
            LOG.warn("Unable to connect to the master to check the last flushed sequence id", (Throwable)e);
            return ClusterStatusProtos.RegionStoreSequenceIds.newBuilder().setLastFlushedSequenceId(-1L).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeMetaTableRegions(boolean abort) {
        HRegion meta = null;
        this.onlineRegionsLock.writeLock().lock();
        try {
            for (Map.Entry<String, HRegion> e : this.onlineRegions.entrySet()) {
                RegionInfo hri = e.getValue().getRegionInfo();
                if (hri.isMetaRegion()) {
                    meta = e.getValue();
                }
                if (meta == null) continue;
                break;
            }
        }
        finally {
            this.onlineRegionsLock.writeLock().unlock();
        }
        if (meta != null) {
            this.closeRegionIgnoreErrors(meta.getRegionInfo(), abort);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeUserRegions(boolean abort) {
        this.onlineRegionsLock.writeLock().lock();
        try {
            for (Map.Entry<String, HRegion> e : this.onlineRegions.entrySet()) {
                HRegion r = e.getValue();
                if (r.getRegionInfo().isMetaRegion() || !r.isAvailable()) continue;
                this.closeRegionIgnoreErrors(r.getRegionInfo(), abort);
            }
        }
        finally {
            this.onlineRegionsLock.writeLock().unlock();
        }
    }

    public InfoServer getInfoServer() {
        return this.infoServer;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    public boolean isStopping() {
        return this.stopping;
    }

    @Override
    public Configuration getConfiguration() {
        return this.conf;
    }

    protected Map<String, HRegion> getOnlineRegions() {
        return this.onlineRegions;
    }

    public int getNumberOfOnlineRegions() {
        return this.onlineRegions.size();
    }

    public Collection<HRegion> getOnlineRegionsLocalContext() {
        Collection<HRegion> regions = this.onlineRegions.values();
        return Collections.unmodifiableCollection(regions);
    }

    @Override
    public void addRegion(HRegion region) {
        this.onlineRegions.put(region.getRegionInfo().getEncodedName(), region);
        this.configurationManager.registerObserver((ConfigurationObserver)region);
    }

    SortedMap<Long, HRegion> getCopyOfOnlineRegionsSortedByOffHeapSize() {
        TreeMap<Long, HRegion> sortedRegions = new TreeMap<Long, HRegion>(Comparator.reverseOrder());
        for (HRegion region : this.onlineRegions.values()) {
            sortedRegions.put(region.getMemStoreOffHeapSize(), region);
        }
        return sortedRegions;
    }

    SortedMap<Long, HRegion> getCopyOfOnlineRegionsSortedByOnHeapSize() {
        TreeMap<Long, HRegion> sortedRegions = new TreeMap<Long, HRegion>(Comparator.reverseOrder());
        for (HRegion region : this.onlineRegions.values()) {
            sortedRegions.put(region.getMemStoreHeapSize(), region);
        }
        return sortedRegions;
    }

    public long getStartcode() {
        return this.startcode;
    }

    @Override
    public FlushRequester getFlushRequester() {
        return this.cacheFlusher;
    }

    @Override
    public CompactionRequester getCompactionRequestor() {
        return this.compactSplitThread;
    }

    @Override
    public LeaseManager getLeaseManager() {
        return this.leaseManager;
    }

    protected Path getDataRootDir() {
        return this.dataRootDir;
    }

    @Override
    public FileSystem getFileSystem() {
        return this.dataFs;
    }

    boolean isDataFileSystemOk() {
        return this.dataFsOk;
    }

    public Path getWALRootDir() {
        return this.walRootDir;
    }

    public FileSystem getWALFileSystem() {
        return this.walFs;
    }

    @Override
    public String toString() {
        return this.getServerName().toString();
    }

    @Override
    public ZKWatcher getZooKeeper() {
        return this.zooKeeper;
    }

    @Override
    public CoordinatedStateManager getCoordinatedStateManager() {
        return this.csm;
    }

    @Override
    public ServerName getServerName() {
        return this.serverName;
    }

    public RegionServerCoprocessorHost getRegionServerCoprocessorHost() {
        return this.rsHost;
    }

    @Override
    public ConcurrentMap<byte[], Boolean> getRegionsInTransitionInRS() {
        return this.regionsInTransitionInRS;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public ChoreService getChoreService() {
        return this.choreService;
    }

    @Override
    public RegionServerRpcQuotaManager getRegionServerRpcQuotaManager() {
        return this.rsQuotaManager;
    }

    private static void createNewReplicationInstance(Configuration conf, HRegionServer server, FileSystem walFs, Path walDir, Path oldWALDir, WALFactory walFactory) throws IOException {
        String sinkClassname;
        if (server instanceof HMaster && (!LoadBalancer.isTablesOnMaster(conf) || LoadBalancer.isSystemTablesOnlyOnMaster(conf))) {
            return;
        }
        String sourceClassname = conf.get("hbase.replication.source.service", "org.apache.hadoop.hbase.replication.regionserver.Replication");
        if (sourceClassname.equals(sinkClassname = conf.get("hbase.replication.sink.service", "org.apache.hadoop.hbase.replication.regionserver.Replication"))) {
            server.replicationSourceHandler = HRegionServer.newReplicationInstance(sourceClassname, ReplicationSourceService.class, conf, server, walFs, walDir, oldWALDir, walFactory);
            server.replicationSinkHandler = (ReplicationSinkService)((Object)server.replicationSourceHandler);
        } else {
            server.replicationSourceHandler = HRegionServer.newReplicationInstance(sourceClassname, ReplicationSourceService.class, conf, server, walFs, walDir, oldWALDir, walFactory);
            server.replicationSinkHandler = HRegionServer.newReplicationInstance(sinkClassname, ReplicationSinkService.class, conf, server, walFs, walDir, oldWALDir, walFactory);
        }
    }

    private static <T extends ReplicationService> T newReplicationInstance(String classname, Class<T> xface, Configuration conf, HRegionServer server, FileSystem walFs, Path logDir, Path oldLogDir, WALFactory walFactory) throws IOException {
        Class<T> clazz;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            clazz = Class.forName(classname, true, classLoader).asSubclass(xface);
        }
        catch (ClassNotFoundException nfe) {
            throw new IOException("Could not find class for " + classname);
        }
        ReplicationService service = (ReplicationService)ReflectionUtils.newInstance(clazz, (Configuration)conf);
        service.initialize(server, walFs, logDir, oldLogDir, walFactory);
        return (T)service;
    }

    public Map<String, ReplicationStatus> getWalGroupsReplicationStatus() {
        TreeMap<String, ReplicationStatus> walGroupsReplicationStatus = new TreeMap<String, ReplicationStatus>();
        if (!this.isOnline()) {
            return walGroupsReplicationStatus;
        }
        ArrayList<ReplicationSourceInterface> allSources = new ArrayList<ReplicationSourceInterface>();
        allSources.addAll(this.replicationSourceHandler.getReplicationManager().getSources());
        allSources.addAll(this.replicationSourceHandler.getReplicationManager().getOldSources());
        for (ReplicationSourceInterface source : allSources) {
            walGroupsReplicationStatus.putAll(source.getWalGroupStatus());
        }
        return walGroupsReplicationStatus;
    }

    static HRegionServer constructRegionServer(Class<? extends HRegionServer> regionServerClass, Configuration conf) {
        try {
            Constructor<? extends HRegionServer> c = regionServerClass.getConstructor(Configuration.class);
            return c.newInstance(conf);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed construction of Regionserver: " + regionServerClass.toString(), e);
        }
    }

    public static void main(String[] args) {
        LOG.info("STARTING executorService " + HRegionServer.class.getSimpleName());
        VersionInfo.logVersion();
        Configuration conf = HBaseConfiguration.create();
        Class regionServerClass = conf.getClass("hbase.regionserver.impl", HRegionServer.class);
        new HRegionServerCommandLine(regionServerClass).doMain(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HRegion> getRegions(TableName tableName) {
        ArrayList<HRegion> tableRegions = new ArrayList<HRegion>();
        Map<String, HRegion> map = this.onlineRegions;
        synchronized (map) {
            for (HRegion region : this.onlineRegions.values()) {
                RegionInfo regionInfo = region.getRegionInfo();
                if (!regionInfo.getTable().equals((Object)tableName)) continue;
                tableRegions.add(region);
            }
        }
        return tableRegions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HRegion> getRegions() {
        ArrayList<HRegion> allRegions;
        Map<String, HRegion> map = this.onlineRegions;
        synchronized (map) {
            allRegions = new ArrayList<HRegion>(this.onlineRegions.values());
        }
        return allRegions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<TableName> getOnlineTables() {
        HashSet<TableName> tables = new HashSet<TableName>();
        Map<String, HRegion> map = this.onlineRegions;
        synchronized (map) {
            for (Region region : this.onlineRegions.values()) {
                tables.add(region.getTableDescriptor().getTableName());
            }
        }
        return tables;
    }

    public String[] getRegionServerCoprocessors() {
        TreeSet<String> coprocessors = new TreeSet<String>();
        try {
            coprocessors.addAll(this.getWAL(null).getCoprocessorHost().getCoprocessors());
        }
        catch (IOException exception) {
            LOG.warn("Exception attempting to fetch wal coprocessor information for the common wal; skipping.");
            LOG.debug("Exception details for failure to fetch wal coprocessor information.", (Throwable)exception);
        }
        Collection<HRegion> regions = this.getOnlineRegionsLocalContext();
        for (HRegion region : regions) {
            coprocessors.addAll(region.getCoprocessorHost().getCoprocessors());
            try {
                coprocessors.addAll(this.getWAL(region.getRegionInfo()).getCoprocessorHost().getCoprocessors());
            }
            catch (IOException exception) {
                LOG.warn("Exception attempting to fetch wal coprocessor information for region " + region + "; skipping.");
                LOG.debug("Exception details for failure to fetch wal coprocessor information.", (Throwable)exception);
            }
        }
        coprocessors.addAll(this.rsHost.getCoprocessors());
        return coprocessors.toArray(new String[0]);
    }

    private void closeRegionIgnoreErrors(RegionInfo region, boolean abort) {
        try {
            if (!this.closeRegion(region.getEncodedName(), abort, null)) {
                LOG.warn("Failed to close " + region.getRegionNameAsString() + " - ignoring and continuing");
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to close " + region.getRegionNameAsString() + " - ignoring and continuing", (Throwable)e);
        }
    }

    protected boolean closeRegion(String encodedName, boolean abort, ServerName destination) throws NotServingRegionException {
        Boolean previous;
        HRegion actualRegion = this.getRegion(encodedName);
        if (actualRegion != null && actualRegion.getCoprocessorHost() != null) {
            try {
                actualRegion.getCoprocessorHost().preClose(false);
            }
            catch (IOException exp) {
                LOG.warn("Unable to close region: the coprocessor launched an error ", (Throwable)exp);
                return false;
            }
        }
        if (Boolean.TRUE.equals(previous = this.regionsInTransitionInRS.putIfAbsent(Bytes.toBytes((String)encodedName), Boolean.FALSE))) {
            LOG.info("Received CLOSE for the region:" + encodedName + " , which we are already trying to OPEN. Cancelling OPENING.");
            if (!this.regionsInTransitionInRS.replace(Bytes.toBytes((String)encodedName), previous, Boolean.FALSE)) {
                LOG.warn("The opening for region " + encodedName + " was done before we could cancel it. Doing a standard close now");
                return this.closeRegion(encodedName, abort, destination);
            }
            actualRegion = this.getRegion(encodedName);
            if (actualRegion == null) {
                LOG.info("The opening previously in progress has been cancelled by a CLOSE request.");
                throw new NotServingRegionException("The region " + encodedName + " was opening but not yet served. Opening is cancelled.");
            }
        } else if (previous == null) {
            LOG.info("Received CLOSE for {}", (Object)encodedName);
        } else if (Boolean.FALSE.equals(previous)) {
            LOG.info("Received CLOSE for the region: " + encodedName + ", which we are already trying to CLOSE, but not completed yet");
            return true;
        }
        if (actualRegion == null) {
            LOG.debug("Received CLOSE for a region which is not online, and we're not opening.");
            this.regionsInTransitionInRS.remove(Bytes.toBytes((String)encodedName));
            throw new NotServingRegionException("The region " + encodedName + " is not online, and is not opening.");
        }
        RegionInfo hri = actualRegion.getRegionInfo();
        CloseRegionHandler crh = hri.isMetaRegion() ? new CloseMetaHandler(this, this, hri, abort) : new CloseRegionHandler(this, this, hri, abort, destination);
        this.executorService.submit(crh);
        return true;
    }

    public HRegion getOnlineRegion(byte[] regionName) {
        String encodedRegionName = RegionInfo.encodeRegionName((byte[])regionName);
        return this.onlineRegions.get(encodedRegionName);
    }

    @Override
    public HRegion getRegion(String encodedRegionName) {
        return this.onlineRegions.get(encodedRegionName);
    }

    @Override
    public boolean removeRegion(HRegion r, ServerName destination) {
        HRegion toReturn = this.onlineRegions.remove(r.getRegionInfo().getEncodedName());
        this.metricsRegionServerImpl.requestsCountCache.remove(r.getRegionInfo().getEncodedName());
        if (destination != null) {
            long closeSeqNum = r.getMaxFlushedSeqId();
            if (closeSeqNum == -1L && (closeSeqNum = r.getOpenSeqNum()) == -1L) {
                closeSeqNum = 0L;
            }
            boolean selfMove = ServerName.isSameAddress((ServerName)destination, (ServerName)this.getServerName());
            this.addToMovedRegions(r.getRegionInfo().getEncodedName(), destination, closeSeqNum, selfMove);
            if (selfMove) {
                this.regionServerAccounting.getRetainedRegionRWRequestsCnt().put(r.getRegionInfo().getEncodedName(), (Pair<Long, Long>)new Pair((Object)r.getReadRequestsCount(), (Object)r.getWriteRequestsCount()));
            }
        }
        this.regionFavoredNodesMap.remove(r.getRegionInfo().getEncodedName());
        return toReturn != null;
    }

    protected HRegion getRegion(byte[] regionName) throws NotServingRegionException {
        String encodedRegionName = RegionInfo.encodeRegionName((byte[])regionName);
        return this.getRegionByEncodedName(regionName, encodedRegionName);
    }

    public HRegion getRegionByEncodedName(String encodedRegionName) throws NotServingRegionException {
        return this.getRegionByEncodedName(null, encodedRegionName);
    }

    private HRegion getRegionByEncodedName(byte[] regionName, String encodedRegionName) throws NotServingRegionException {
        HRegion region = this.onlineRegions.get(encodedRegionName);
        if (region == null) {
            String regionNameStr;
            MovedRegionInfo moveInfo = this.getMovedRegion(encodedRegionName);
            if (moveInfo != null) {
                throw new RegionMovedException(moveInfo.getServerName(), moveInfo.getSeqNum());
            }
            Boolean isOpening = (Boolean)this.regionsInTransitionInRS.get(Bytes.toBytes((String)encodedRegionName));
            String string = regionNameStr = regionName == null ? encodedRegionName : Bytes.toStringBinary((byte[])regionName);
            if (isOpening != null && isOpening.booleanValue()) {
                throw new RegionOpeningException("Region " + regionNameStr + " is opening on " + this.serverName);
            }
            throw new NotServingRegionException("" + regionNameStr + " is not online on " + this.serverName);
        }
        return region;
    }

    private Throwable cleanup(Throwable t, String msg) {
        Throwable e;
        if (t instanceof NotServingRegionException) {
            LOG.debug("NotServingRegionException; " + t.getMessage());
            return t;
        }
        Throwable throwable = e = t instanceof RemoteException ? ((RemoteException)t).unwrapRemoteException() : t;
        if (msg == null) {
            LOG.error("", e);
        } else {
            LOG.error(msg, e);
        }
        if (!this.rpcServices.checkOOME(t)) {
            this.checkFileSystem();
        }
        return t;
    }

    private IOException convertThrowableToIOE(Throwable t, String msg) {
        return t instanceof IOException ? (IOException)t : (msg == null || msg.length() == 0 ? new IOException(t) : new IOException(msg, t));
    }

    boolean checkFileSystem() {
        if (this.dataFsOk && this.dataFs != null) {
            try {
                FSUtils.checkFileSystemAvailable((FileSystem)this.dataFs);
            }
            catch (IOException e) {
                this.abort("File System not available", e);
                this.dataFsOk = false;
            }
        }
        return this.dataFsOk;
    }

    @Override
    public void updateRegionFavoredNodesMapping(String encodedRegionName, List<HBaseProtos.ServerName> favoredNodes) {
        Address[] addr = new Address[favoredNodes.size()];
        for (int i = 0; i < favoredNodes.size(); ++i) {
            addr[i] = Address.fromParts((String)favoredNodes.get(i).getHostName(), (int)favoredNodes.get(i).getPort());
        }
        this.regionFavoredNodesMap.put(encodedRegionName, addr);
    }

    @Override
    public InetSocketAddress[] getFavoredNodesForRegion(String encodedRegionName) {
        return Address.toSocketAddress((Address[])this.regionFavoredNodesMap.get(encodedRegionName));
    }

    @Override
    public ServerNonceManager getNonceManager() {
        return this.nonceManager;
    }

    private void addToMovedRegions(String encodedName, ServerName destination, long closeSeqNum, boolean selfMove) {
        if (selfMove) {
            LOG.warn("Not adding moved region record: " + encodedName + " to self.");
            return;
        }
        LOG.info("Adding " + encodedName + " move to " + destination + " record at close sequenceid=" + closeSeqNum);
        this.movedRegionInfoCache.put((Object)encodedName, (Object)new MovedRegionInfo(destination, closeSeqNum));
    }

    void removeFromMovedRegions(String encodedName) {
        this.movedRegionInfoCache.invalidate((Object)encodedName);
    }

    @InterfaceAudience.Private
    public MovedRegionInfo getMovedRegion(String encodedRegionName) {
        return (MovedRegionInfo)this.movedRegionInfoCache.getIfPresent((Object)encodedRegionName);
    }

    @InterfaceAudience.Private
    public int movedRegionCacheExpiredTime() {
        return 120000;
    }

    private String getMyEphemeralNodePath() {
        return this.zooKeeper.getZNodePaths().getRsPath(this.serverName);
    }

    private boolean isHealthCheckerConfigured() {
        String healthScriptLocation = this.conf.get("hbase.node.health.script.location");
        return StringUtils.isNotBlank((CharSequence)healthScriptLocation);
    }

    public CompactSplit getCompactSplitThread() {
        return this.compactSplitThread;
    }

    ClientProtos.CoprocessorServiceResponse execRegionServerService(RpcController controller, ClientProtos.CoprocessorServiceRequest serviceRequest) throws ServiceException {
        try {
            String methodName;
            ServerRpcController serviceController = new ServerRpcController();
            ClientProtos.CoprocessorServiceCall call = serviceRequest.getCall();
            String serviceName = call.getServiceName();
            Service service = this.coprocessorServiceHandlers.get(serviceName);
            if (service == null) {
                throw new UnknownProtocolException(null, "No registered coprocessor executorService found for " + serviceName);
            }
            Descriptors.ServiceDescriptor serviceDesc = service.getDescriptorForType();
            Descriptors.MethodDescriptor methodDesc = serviceDesc.findMethodByName(methodName = call.getMethodName());
            if (methodDesc == null) {
                throw new UnknownProtocolException(service.getClass(), "Unknown method " + methodName + " called on executorService " + serviceName);
            }
            Message request = CoprocessorRpcUtils.getRequest((Service)service, (Descriptors.MethodDescriptor)methodDesc, (ByteString)call.getRequest());
            Message.Builder responseBuilder = service.getResponsePrototype(methodDesc).newBuilderForType();
            service.callMethod(methodDesc, (com.google.protobuf.RpcController)serviceController, request, message -> {
                if (message != null) {
                    responseBuilder.mergeFrom(message);
                }
            });
            IOException exception = CoprocessorRpcUtils.getControllerException((com.google.protobuf.RpcController)serviceController);
            if (exception != null) {
                throw exception;
            }
            return CoprocessorRpcUtils.getResponse((Message)responseBuilder.build(), (byte[])HConstants.EMPTY_BYTE_ARRAY);
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    @Override
    public Optional<BlockCache> getBlockCache() {
        return Optional.ofNullable(this.blockCache);
    }

    @Override
    public Optional<MobFileCache> getMobFileCache() {
        return Optional.ofNullable(this.mobFileCache);
    }

    @Override
    public AccessChecker getAccessChecker() {
        return this.rpcServices.getAccessChecker();
    }

    @Override
    public ZKPermissionWatcher getZKPermissionWatcher() {
        return this.rpcServices.getZkPermissionWatcher();
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*/src/test/.*")
    public ConfigurationManager getConfigurationManager() {
        return this.configurationManager;
    }

    @Override
    public TableDescriptors getTableDescriptors() {
        return this.tableDescriptors;
    }

    void updateConfiguration() throws IOException {
        LOG.info("Reloading the configuration from disk.");
        this.preUpdateConfiguration();
        this.conf.reloadConfiguration();
        this.configurationManager.notifyAllObservers(this.conf);
        this.postUpdateConfiguration();
    }

    protected void preUpdateConfiguration() throws IOException {
        if (this.rsHost != null) {
            this.rsHost.preUpdateConfiguration(this.conf);
        }
    }

    protected void postUpdateConfiguration() throws IOException {
        if (this.rsHost != null) {
            this.rsHost.postUpdateConfiguration(this.conf);
        }
    }

    CacheEvictionStats clearRegionBlockCache(Region region) {
        long evictedBlocks = 0L;
        for (Store store : region.getStores()) {
            for (StoreFile storeFile : store.getStorefiles()) {
                evictedBlocks += (long)this.blockCache.evictBlocksByHfileName(storeFile.getPath().getName());
            }
        }
        return CacheEvictionStats.builder().withEvictedBlocks(evictedBlocks).build();
    }

    @Override
    public double getCompactionPressure() {
        double max = 0.0;
        for (Region region : this.onlineRegions.values()) {
            for (Store store : region.getStores()) {
                double normCount = store.getCompactionPressure();
                if (!(normCount > max)) continue;
                max = normCount;
            }
        }
        return max;
    }

    @Override
    public HeapMemoryManager getHeapMemoryManager() {
        return this.hMemManager;
    }

    public MemStoreFlusher getMemStoreFlusher() {
        return this.cacheFlusher;
    }

    @InterfaceAudience.Private
    public boolean walRollRequestFinished() {
        return this.walRoller.walRollFinished();
    }

    @Override
    public ThroughputController getFlushThroughputController() {
        return this.flushThroughputController;
    }

    @Override
    public double getFlushPressure() {
        if (this.getRegionServerAccounting() == null || this.cacheFlusher == null) {
            return 0.0;
        }
        return this.getRegionServerAccounting().getFlushPressure();
    }

    public void onConfigurationChange(Configuration newConf) {
        ThroughputController old = this.flushThroughputController;
        if (old != null) {
            old.stop("configuration change");
        }
        this.flushThroughputController = FlushThroughputControllerFactory.create(this, newConf);
        try {
            Superusers.initialize((Configuration)newConf);
        }
        catch (IOException e) {
            LOG.warn("Failed to initialize SuperUsers on reloading of the configuration");
        }
        if (CoprocessorConfigurationUtil.checkConfigurationChange(this.getConfiguration(), newConf, "hbase.coprocessor.regionserver.classes")) {
            LOG.info("Update region server coprocessors because the configuration has changed");
            this.rsHost = new RegionServerCoprocessorHost(this, newConf);
        }
    }

    @Override
    public MetricsRegionServer getMetrics() {
        return this.metricsRegionServer;
    }

    @Override
    public SecureBulkLoadManager getSecureBulkLoadManager() {
        return this.secureBulkLoadManager;
    }

    @Override
    public EntityLock regionLock(List<RegionInfo> regionInfos, String description, Abortable abort) {
        return new LockServiceClient(this.conf, this.lockStub, this.clusterConnection.getNonceGenerator()).regionLock(regionInfos, description, abort);
    }

    @Override
    public void unassign(byte[] regionName) throws IOException {
        this.clusterConnection.getAdmin().unassign(regionName, false);
    }

    @Override
    public RegionServerSpaceQuotaManager getRegionServerSpaceQuotaManager() {
        return this.rsSpaceQuotaManager;
    }

    @Override
    public boolean reportFileArchivalForQuotas(TableName tableName, Collection<Map.Entry<String, Long>> archivedFiles) {
        if (TEST_SKIP_REPORTING_TRANSITION) {
            return false;
        }
        RegionServerStatusProtos.RegionServerStatusService.BlockingInterface rss = this.rssStub;
        if (rss == null || this.rsSpaceQuotaManager == null) {
            LOG.trace("Skipping file archival reporting to HMaster as stub is null");
            return false;
        }
        try {
            RegionServerStatusProtos.FileArchiveNotificationRequest request = this.rsSpaceQuotaManager.buildFileArchiveRequest(tableName, archivedFiles);
            rss.reportFileArchival(null, request);
        }
        catch (ServiceException se) {
            IOException ioe = ProtobufUtil.getRemoteException((ServiceException)se);
            if (ioe instanceof PleaseHoldException) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Failed to report file archival(s) to Master because it is initializing. This will be retried.", (Throwable)ioe);
                }
                return false;
            }
            if (this.rssStub == rss) {
                this.rssStub = null;
            }
            this.createRegionServerStatusStub(true);
            LOG.debug("Failed to report file archival(s) to Master. This will be retried.", (Throwable)ioe);
            return false;
        }
        return true;
    }

    public NettyEventLoopGroupConfig getEventLoopGroupConfig() {
        return this.eventLoopGroupConfig;
    }

    @Override
    public Connection createConnection(Configuration conf) throws IOException {
        User user = UserProvider.instantiate((Configuration)conf).getCurrent();
        return ServerConnectionUtils.createShortCircuitConnection(conf, user, this.serverName, this.rpcServices, this.rpcServices, new RegionServerRegistry(this));
    }

    void executeProcedure(long procId, long initiatingMasterActiveTime, RSProcedureCallable callable) {
        this.executorService.submit(new RSProcedureHandler(this, procId, initiatingMasterActiveTime, callable));
    }

    public void remoteProcedureComplete(long procId, long initiatingMasterActiveTime, Throwable error) {
        this.procedureResultReporter.complete(procId, initiatingMasterActiveTime, error);
    }

    void reportProcedureDone(RegionServerStatusProtos.ReportProcedureDoneRequest request) throws IOException {
        RegionServerStatusProtos.RegionServerStatusService.BlockingInterface rss;
        while ((rss = this.rssStub) == null) {
            this.createRegionServerStatusStub();
        }
        try {
            rss.reportProcedureDone(null, request);
        }
        catch (ServiceException se) {
            if (this.rssStub == rss) {
                this.rssStub = null;
            }
            throw ProtobufUtil.getRemoteException((ServiceException)se);
        }
    }

    boolean submitRegionProcedure(long procId) {
        if (procId == -1L) {
            return true;
        }
        Long previous = this.submittedRegionProcedures.putIfAbsent(procId, procId);
        if (previous != null) {
            LOG.warn("Received procedure pid={}, which already submitted, just ignore it", (Object)procId);
            return false;
        }
        if (this.executedRegionProcedures.getIfPresent((Object)procId) != null) {
            LOG.warn("Received procedure pid={}, which already executed, just ignore it", (Object)procId);
            return false;
        }
        return true;
    }

    public void finishRegionProcedure(long procId) {
        this.executedRegionProcedures.put((Object)procId, (Object)procId);
        this.submittedRegionProcedures.remove(procId);
    }

    public boolean isShutDown() {
        return this.shutDown;
    }

    @InterfaceAudience.Private
    public CompactedHFilesDischarger getCompactedHFilesDischarger() {
        return this.compactedFileDischarger;
    }

    @InterfaceAudience.Private
    public long getRetryPauseTime() {
        return this.retryPauseTime;
    }

    public Optional<ServerName> getActiveMaster() {
        return Optional.ofNullable(this.masterAddressTracker.getMasterAddress());
    }

    public List<ServerName> getBackupMasters() {
        return this.masterAddressTracker.getBackupMasters();
    }

    public Iterator<ServerName> getBootstrapNodes() {
        return this.bootstrapNodeManager.getBootstrapNodes().iterator();
    }

    public MetaRegionLocationCache getMetaRegionLocationCache() {
        return this.metaRegionLocationCache;
    }

    @InterfaceAudience.Private
    public BrokenStoreFileCleaner getBrokenStoreFileCleaner() {
        return this.brokenStoreFileCleaner;
    }

    @InterfaceAudience.Private
    public RSMobFileCleanerChore getRSMobFileCleanerChore() {
        return this.rsMobFileCleanerChore;
    }

    RSSnapshotVerifier getRsSnapshotVerifier() {
        return this.rsSnapshotVerifier;
    }

    private static class SystemExitWhenAbortTimeout
    extends TimerTask {
        @Override
        public void run() {
            LOG.warn("Aborting region server timed out, terminating forcibly and does not wait for any running shutdown hooks or finalizers to finish their work. Thread dump to stdout.");
            Threads.printThreadInfo((PrintStream)System.out, (String)"Zombie HRegionServer");
            Runtime.getRuntime().halt(1);
        }
    }

    private static class MovedRegionInfo {
        private final ServerName serverName;
        private final long seqNum;

        MovedRegionInfo(ServerName serverName, long closeSeqNum) {
            this.serverName = serverName;
            this.seqNum = closeSeqNum;
        }

        public ServerName getServerName() {
            return this.serverName;
        }

        public long getSeqNum() {
            return this.seqNum;
        }
    }

    private static class PeriodicMemStoreFlusher
    extends ScheduledChore {
        private final HRegionServer server;
        private static final int RANGE_OF_DELAY = 300;
        private static final int MIN_DELAY_TIME = 0;
        private final long rangeOfDelayMs;

        PeriodicMemStoreFlusher(int cacheFlushInterval, HRegionServer server) {
            super("MemstoreFlusherChore", (Stoppable)server, cacheFlushInterval);
            this.server = server;
            long configuredRangeOfDelay = server.getConfiguration().getInt("hbase.regionserver.periodicmemstoreflusher.rangeofdelayseconds", 300);
            this.rangeOfDelayMs = TimeUnit.SECONDS.toMillis(configuredRangeOfDelay);
        }

        protected void chore() {
            StringBuilder whyFlush = new StringBuilder();
            for (HRegion r : this.server.onlineRegions.values()) {
                long delay;
                FlushRequester requester;
                if (r == null || !r.shouldFlush(whyFlush) || (requester = this.server.getFlushRequester()) == null || !requester.requestDelayedFlush(r, delay = ThreadLocalRandom.current().nextLong(this.rangeOfDelayMs) + 0L)) continue;
                LOG.info("{} requesting flush of {} because {} after random delay {} ms", new Object[]{this.getName(), r.getRegionInfo().getRegionNameAsString(), whyFlush.toString(), delay});
            }
        }
    }

    private static class CompactionChecker
    extends ScheduledChore {
        private final HRegionServer instance;
        private final int majorCompactPriority;
        private static final int DEFAULT_PRIORITY = Integer.MAX_VALUE;
        private long iteration = 1L;

        CompactionChecker(HRegionServer h, int sleepTime, Stoppable stopper) {
            super("CompactionChecker", stopper, sleepTime);
            this.instance = h;
            LOG.info(this.getName() + " runs every " + Duration.ofMillis(sleepTime));
            this.majorCompactPriority = this.instance.conf.getInt("hbase.regionserver.compactionChecker.majorCompactPriority", Integer.MAX_VALUE);
        }

        protected void chore() {
            for (HRegion hr : this.instance.onlineRegions.values()) {
                if (hr == null || hr.isReadOnly() || !hr.getTableDescriptor().isCompactionEnabled()) continue;
                for (HStore s : hr.stores.values()) {
                    try {
                        long multiplier = s.getCompactionCheckMultiplier();
                        assert (multiplier > 0L);
                        if (this.iteration % multiplier != 0L) continue;
                        if (s.needsCompaction()) {
                            this.instance.compactSplitThread.requestSystemCompaction(hr, s, this.getName() + " requests compaction");
                            continue;
                        }
                        if (!s.shouldPerformMajorCompaction()) continue;
                        s.triggerMajorCompaction();
                        if (this.majorCompactPriority == Integer.MAX_VALUE || this.majorCompactPriority > hr.getCompactPriority()) {
                            this.instance.compactSplitThread.requestCompaction(hr, s, this.getName() + " requests major compaction; use default priority", Integer.MIN_VALUE, CompactionLifeCycleTracker.DUMMY, null);
                            continue;
                        }
                        this.instance.compactSplitThread.requestCompaction(hr, s, this.getName() + " requests major compaction; use configured priority", this.majorCompactPriority, CompactionLifeCycleTracker.DUMMY, null);
                    }
                    catch (IOException e) {
                        LOG.warn("Failed major compaction check on " + hr, (Throwable)e);
                    }
                }
            }
            this.iteration = this.iteration == Long.MAX_VALUE ? 0L : this.iteration + 1L;
        }
    }
}

