/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import org.apache.http.config.MessageConstraints;
import org.apache.http.impl.io.HttpTransportMetricsImpl;
import org.apache.http.impl.io.SessionInputBufferImpl;

public class SessionInputBufferMock
extends SessionInputBufferImpl {
    public static final int BUFFER_SIZE = 16;

    public SessionInputBufferMock(InputStream instream, int buffersize, MessageConstraints constrains, CharsetDecoder decoder) {
        super(new HttpTransportMetricsImpl(), buffersize, -1, constrains, decoder);
        this.bind(instream);
    }

    public SessionInputBufferMock(InputStream instream, int buffersize) {
        this(instream, buffersize, null, null);
    }

    public SessionInputBufferMock(byte[] bytes, int buffersize, MessageConstraints constrains, CharsetDecoder decoder) {
        this(new ByteArrayInputStream(bytes), buffersize, constrains, decoder);
    }

    public SessionInputBufferMock(byte[] bytes, int buffersize, MessageConstraints constrains) {
        this(new ByteArrayInputStream(bytes), buffersize, constrains, null);
    }

    public SessionInputBufferMock(byte[] bytes, int buffersize) {
        this(new ByteArrayInputStream(bytes), buffersize);
    }

    public SessionInputBufferMock(byte[] bytes) {
        this(bytes, 16);
    }

    public SessionInputBufferMock(byte[] bytes, Charset charset) {
        this(bytes, 16, null, charset != null ? charset.newDecoder() : null);
    }

    public SessionInputBufferMock(byte[] bytes, CharsetDecoder decoder) {
        this(bytes, 16, null, decoder);
    }

    public SessionInputBufferMock(String s, Charset charset) {
        this(s.getBytes(charset), charset);
    }

    public boolean isDataAvailable(int timeout) throws IOException {
        return true;
    }
}

