/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.composition.combinators.sequential;

import java.util.List;
import org.apache.ignite.ml.IgniteModel;
import org.apache.ignite.ml.math.functions.IgniteFunction;

public final class ModelsSequentialComposition<I, O1, O2>
implements IgniteModel<I, O2> {
    private IgniteModel<I, O1> mdl1;
    private IgniteModel<O1, O2> mdl2;

    public static <I, O> ModelsSequentialComposition<I, O, O> ofSame(List<? extends IgniteModel<I, O>> lst, IgniteFunction<O, I> output2Input) {
        assert (lst.size() >= 2);
        if (lst.size() == 2) {
            return new ModelsSequentialComposition<I, O, O>(lst.get(0), lst.get(1).andBefore(output2Input));
        }
        return new ModelsSequentialComposition(lst.get(0), ModelsSequentialComposition.ofSame(lst.subList(1, lst.size()), output2Input).andBefore(output2Input));
    }

    public ModelsSequentialComposition(IgniteModel<I, O1> mdl1, IgniteModel<O1, O2> mdl2) {
        this.mdl1 = mdl1;
        this.mdl2 = mdl2;
    }

    public IgniteModel<I, O1> firstModel() {
        return this.mdl1;
    }

    public IgniteModel<O1, O2> secondModel() {
        return this.mdl2;
    }

    @Override
    public O2 predict(I i1) {
        return (O2)this.mdl1.andThen(this.mdl2).predict(i1);
    }

    @Override
    public void close() {
        this.mdl1.close();
        this.mdl2.close();
    }
}

