/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.dataset.feature.extractor;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.math.primitives.vector.impl.DenseVector;
import org.apache.ignite.ml.structures.LabeledVector;
import org.apache.ignite.ml.trainers.FeatureLabelExtractor;

public abstract class Vectorizer<K, V, C extends Serializable, L>
implements FeatureLabelExtractor<K, V, L> {
    private LabelCoordinate lbCoordinateShortcut;
    private static final long serialVersionUID = 4301406952131379459L;
    private final boolean useAllValues;
    private List<C> extractionCoordinates;
    private C labelCoord;
    private HashSet<C> excludedCoords = new HashSet();

    @Override
    public LabeledVector<L> apply(K key, V value) {
        L lbl = this.isLabeled() ? this.label(this.labelCoord(key, value), key, value) : this.zero();
        List allCoords = null;
        if (this.useAllValues) {
            allCoords = this.allCoords(key, value).stream().filter(coord -> !coord.equals(this.labelCoord) && !this.excludedCoords.contains(coord)).collect(Collectors.toList());
        }
        int vectorLen = this.useAllValues ? allCoords.size() : this.extractionCoordinates.size();
        A.ensure((vectorLen >= 0 ? 1 : 0) != 0, (String)"vectorLength >= 0");
        List<Object> coordinatesForExtraction = this.useAllValues ? allCoords : this.extractionCoordinates;
        Vector vector = this.createVector(vectorLen);
        for (int i = 0; i < coordinatesForExtraction.size(); ++i) {
            Serializable feature = this.feature((Serializable)coordinatesForExtraction.get(i), key, value);
            if (feature == null) continue;
            vector.setRaw(i, feature);
        }
        return new LabeledVector<L>(vector, lbl);
    }

    public Vectorizer(C ... coords) {
        this.extractionCoordinates = Arrays.asList(coords);
        this.useAllValues = coords.length == 0;
    }

    private boolean isLabeled() {
        return this.labelCoord != null || this.lbCoordinateShortcut != null;
    }

    private C labelCoord(K key, V value) {
        A.ensure((boolean)this.isLabeled(), (String)"isLabeled");
        if (this.labelCoord != null) {
            return this.labelCoord;
        }
        List<C> allCoords = this.allCoords(key, value);
        A.ensure((!allCoords.isEmpty() ? 1 : 0) != 0, (String)"!allCoords.isEmpty()");
        switch (this.lbCoordinateShortcut) {
            case FIRST: {
                this.labelCoord = (Serializable)allCoords.get(0);
                break;
            }
            case LAST: {
                this.labelCoord = (Serializable)allCoords.get(allCoords.size() - 1);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this.labelCoord;
    }

    public Vectorizer<K, V, C, L> labeled(C labelCoord) {
        this.labelCoord = labelCoord;
        this.lbCoordinateShortcut = null;
        return this;
    }

    public Vectorizer<K, V, C, L> labeled(LabelCoordinate labelCoord) {
        this.lbCoordinateShortcut = labelCoord;
        this.labelCoord = null;
        return this;
    }

    public Vectorizer<K, V, C, L> exclude(C ... coords) {
        this.excludedCoords.addAll(Arrays.asList(coords));
        return this;
    }

    @Override
    public LabeledVector<L> extract(K k, V v) {
        return this.apply((Object)k, (Object)v);
    }

    protected abstract Serializable feature(C var1, K var2, V var3);

    protected abstract L label(C var1, K var2, V var3);

    protected abstract L zero();

    protected abstract List<C> allCoords(K var1, V var2);

    protected Vector createVector(int size) {
        return new DenseVector(size);
    }

    public static abstract class VectorizerAdapter<K, V, C extends Serializable, L>
    extends Vectorizer<K, V, C, L> {
        public VectorizerAdapter() {
            super(new Serializable[0]);
        }

        @Override
        protected Double feature(C coord, K key, V value) {
            throw new IllegalStateException();
        }

        @Override
        protected L label(C coord, K key, V value) {
            throw new IllegalStateException();
        }

        @Override
        protected L zero() {
            throw new IllegalStateException();
        }

        @Override
        protected List<C> allCoords(K key, V value) {
            throw new IllegalStateException();
        }
    }

    public static enum LabelCoordinate {
        FIRST,
        LAST;

    }
}

