/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.distances;

import org.apache.ignite.ml.math.distances.DistanceMeasure;
import org.apache.ignite.ml.math.exceptions.math.CardinalityException;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.math.util.MatrixUtil;

public class CanberraDistance
implements DistanceMeasure {
    private static final long serialVersionUID = 1771556549784040092L;

    @Override
    public double compute(Vector a, Vector b) throws CardinalityException {
        Vector top = MatrixUtil.localCopyOf(a).minus(b).map(Math::abs);
        Vector down = MatrixUtil.localCopyOf(a).map(Math::abs).plus(MatrixUtil.localCopyOf(b).map(Math::abs)).map(value -> value != 0.0 ? 1.0 / value : 0.0);
        return top.times(down).sum();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj != null && this.getClass() == obj.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

