/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.distances;

import org.apache.ignite.ml.math.distances.DistanceMeasure;
import org.apache.ignite.ml.math.exceptions.math.CardinalityException;
import org.apache.ignite.ml.math.functions.Functions;
import org.apache.ignite.ml.math.functions.IgniteDoubleFunction;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.math.util.MatrixUtil;

public class HammingDistance
implements DistanceMeasure {
    private static final long serialVersionUID = 1771556549784040098L;

    @Override
    public double compute(Vector a, Vector b) throws CardinalityException {
        IgniteDoubleFunction fun = value -> value == 0.0 ? 0.0 : 1.0;
        return MatrixUtil.localCopyOf(a).minus(b).foldMap(Functions.PLUS, fun, 0.0);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj != null && this.getClass() == obj.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

