/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.distances;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import org.apache.ignite.ml.math.distances.DistanceMeasure;
import org.apache.ignite.ml.math.exceptions.math.CardinalityException;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.math.primitives.vector.VectorUtils;
import org.apache.ignite.ml.math.util.MatrixUtil;

public class WeightedMinkowskiDistance
implements DistanceMeasure {
    private static final long serialVersionUID = 1771556549784040096L;
    private int p = 1;
    private final double[] weights;
    @JsonIgnore
    private final Vector internalWeights;

    @JsonCreator
    public WeightedMinkowskiDistance(@JsonProperty(value="p") int p, @JsonProperty(value="weights") double[] weights) {
        this.p = p;
        this.weights = (double[])weights.clone();
        this.internalWeights = VectorUtils.of(weights).copy().map(x -> Math.pow(Math.abs(x), p));
    }

    @Override
    public double compute(Vector a, Vector b) throws CardinalityException {
        return Math.pow(MatrixUtil.localCopyOf(a).minus(b).map(x -> Math.pow(Math.abs(x), this.p)).times(this.internalWeights).sum(), 1.0 / (double)this.p);
    }

    public int getP() {
        return this.p;
    }

    public double[] getWeights() {
        return (double[])this.weights.clone();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj != null && this.getClass() == obj.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public String toString() {
        return "WeightedMinkowskiDistance{p=" + this.p + ", weights=" + Arrays.toString(this.weights) + '}';
    }
}

