/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.naivebayes.discrete;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.ml.Exporter;
import org.apache.ignite.ml.environment.deploy.DeployableObject;
import org.apache.ignite.ml.inference.json.JSONModelMixIn;
import org.apache.ignite.ml.inference.json.JSONWritable;
import org.apache.ignite.ml.inference.json.JacksonHelper;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.naivebayes.BayesModel;
import org.apache.ignite.ml.naivebayes.discrete.DiscreteNaiveBayesSumsHolder;

public class DiscreteNaiveBayesModel
implements BayesModel<DiscreteNaiveBayesModel, Vector, Double>,
JSONWritable,
DeployableObject {
    private static final long serialVersionUID = -127386523291350345L;
    private double[][][] probabilities;
    private double[] clsProbabilities;
    private double[] labels;
    private double[][] bucketThresholds;
    private DiscreteNaiveBayesSumsHolder sumsHolder;

    public DiscreteNaiveBayesModel(double[][][] probabilities, double[] clsProbabilities, double[] labels, double[][] bucketThresholds, DiscreteNaiveBayesSumsHolder sumsHolder) {
        this.probabilities = (double[][][])probabilities.clone();
        this.clsProbabilities = (double[])clsProbabilities.clone();
        this.labels = (double[])labels.clone();
        this.bucketThresholds = (double[][])bucketThresholds.clone();
        this.sumsHolder = sumsHolder;
    }

    public DiscreteNaiveBayesModel() {
    }

    @Override
    public <P> void saveModel(Exporter<DiscreteNaiveBayesModel, P> exporter, P path) {
        exporter.save(this, path);
    }

    @Override
    public Double predict(Vector vector) {
        double[] probapilityPowers = this.probabilityPowers(vector);
        int maxLbIdx = 0;
        for (int i = 0; i < probapilityPowers.length; ++i) {
            int n = i;
            probapilityPowers[n] = probapilityPowers[n] + Math.log(this.clsProbabilities[i]);
            if (!(probapilityPowers[i] > probapilityPowers[maxLbIdx])) continue;
            maxLbIdx = i;
        }
        return this.labels[maxLbIdx];
    }

    @Override
    public double[] probabilityPowers(Vector vector) {
        double[] probapilityPowers = new double[this.clsProbabilities.length];
        for (int i = 0; i < this.clsProbabilities.length; ++i) {
            for (int j = 0; j < this.probabilities[0].length; ++j) {
                int x = this.toBucketNumber(vector.get(j), this.bucketThresholds[j]);
                double p = this.probabilities[i][j][x];
                int n = i;
                probapilityPowers[n] = probapilityPowers[n] + (p > 0.0 ? Math.log(p) : 0.0);
            }
        }
        return probapilityPowers;
    }

    public double[][][] getProbabilities() {
        return (double[][][])this.probabilities.clone();
    }

    public double[] getClsProbabilities() {
        return (double[])this.clsProbabilities.clone();
    }

    public double[][] getBucketThresholds() {
        return (double[][])this.bucketThresholds.clone();
    }

    public double[] getLabels() {
        return (double[])this.labels.clone();
    }

    public DiscreteNaiveBayesSumsHolder getSumsHolder() {
        return this.sumsHolder;
    }

    private int toBucketNumber(double val, double[] thresholds) {
        for (int i = 0; i < thresholds.length; ++i) {
            if (!(val < thresholds[i])) continue;
            return i;
        }
        return thresholds.length;
    }

    @Override
    @JsonIgnore
    public List<Object> getDependencies() {
        return Collections.emptyList();
    }

    @Override
    public void toJSON(Path path) {
        ObjectMapper mapper = new ObjectMapper().configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.addMixIn(DiscreteNaiveBayesModel.class, JSONModelMixIn.class);
        ObjectWriter writer = mapper.writerFor(DiscreteNaiveBayesModel.class).withAttribute((Object)"formatVersion", (Object)"1").withAttribute((Object)"timestamp", (Object)System.currentTimeMillis()).withAttribute((Object)"uid", (Object)("dt_" + UUID.randomUUID().toString())).withAttribute((Object)"modelClass", (Object)DiscreteNaiveBayesModel.class.getSimpleName());
        try {
            File file = new File(path.toAbsolutePath().toString());
            writer.writeValue(file, (Object)this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static DiscreteNaiveBayesModel fromJSON(Path path) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            JacksonHelper.readAndValidateBasicJsonModelProperties(path, mapper, DiscreteNaiveBayesModel.class.getSimpleName());
            DiscreteNaiveBayesModel mdl = (DiscreteNaiveBayesModel)mapper.readValue(new File(path.toAbsolutePath().toString()), DiscreteNaiveBayesModel.class);
            return mdl;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

