/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.optimization;

import org.apache.ignite.ml.math.functions.IgniteDifferentiableVectorToDoubleFunction;
import org.apache.ignite.ml.math.functions.IgniteFunction;
import org.apache.ignite.ml.math.primitives.vector.Vector;

public class LossFunctions {
    public static IgniteFunction<Vector, IgniteDifferentiableVectorToDoubleFunction> MSE = groundTruth -> new IgniteDifferentiableVectorToDoubleFunction((Vector)groundTruth){
        final /* synthetic */ Vector val$groundTruth;
        {
            this.val$groundTruth = vector;
        }

        @Override
        public Vector differential(Vector pnt) {
            double multiplier = 2.0 / (double)pnt.size();
            return pnt.minus(this.val$groundTruth).times(multiplier);
        }

        @Override
        public Double apply(Vector vector) {
            return this.val$groundTruth.copy().map(vector, (a, b) -> {
                double diff = a - b;
                return diff * diff;
            }).sum() / (double)vector.size();
        }
    };
    public static IgniteFunction<Vector, IgniteDifferentiableVectorToDoubleFunction> LOG = groundTruth -> new IgniteDifferentiableVectorToDoubleFunction((Vector)groundTruth){
        final /* synthetic */ Vector val$groundTruth;
        {
            this.val$groundTruth = vector;
        }

        @Override
        public Vector differential(Vector pnt) {
            double multiplier = 2.0 / (double)pnt.size();
            return pnt.minus(this.val$groundTruth).times(multiplier);
        }

        @Override
        public Double apply(Vector vector) {
            return this.val$groundTruth.copy().map(vector, (a, b) -> a == 1.0 ? -Math.log(b) : -Math.log(1.0 - b)).sum();
        }
    };
    public static IgniteFunction<Vector, IgniteDifferentiableVectorToDoubleFunction> L2 = groundTruth -> new IgniteDifferentiableVectorToDoubleFunction((Vector)groundTruth){
        final /* synthetic */ Vector val$groundTruth;
        {
            this.val$groundTruth = vector;
        }

        @Override
        public Vector differential(Vector pnt) {
            double multiplier = 2.0 / (double)pnt.size();
            return pnt.minus(this.val$groundTruth).times(multiplier);
        }

        @Override
        public Double apply(Vector vector) {
            return this.val$groundTruth.copy().map(vector, (a, b) -> {
                double diff = a - b;
                return diff * diff;
            }).sum();
        }
    };
    public static IgniteFunction<Vector, IgniteDifferentiableVectorToDoubleFunction> L1 = groundTruth -> new IgniteDifferentiableVectorToDoubleFunction((Vector)groundTruth){
        final /* synthetic */ Vector val$groundTruth;
        {
            this.val$groundTruth = vector;
        }

        @Override
        public Vector differential(Vector pnt) {
            double multiplier = 2.0 / (double)pnt.size();
            return pnt.minus(this.val$groundTruth).times(multiplier);
        }

        @Override
        public Double apply(Vector vector) {
            return this.val$groundTruth.copy().map(vector, (a, b) -> {
                double diff = a - b;
                return Math.abs(diff);
            }).sum();
        }
    };
    public static IgniteFunction<Vector, IgniteDifferentiableVectorToDoubleFunction> HINGE = groundTruth -> new IgniteDifferentiableVectorToDoubleFunction((Vector)groundTruth){
        final /* synthetic */ Vector val$groundTruth;
        {
            this.val$groundTruth = vector;
        }

        @Override
        public Vector differential(Vector pnt) {
            double multiplier = 2.0 / (double)pnt.size();
            return pnt.minus(this.val$groundTruth).times(multiplier);
        }

        @Override
        public Double apply(Vector vector) {
            return Math.max(0.0, 1.0 - this.val$groundTruth.dot(vector));
        }
    };
}

