/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.regressions.linear;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.ml.Exportable;
import org.apache.ignite.ml.Exporter;
import org.apache.ignite.ml.IgniteModel;
import org.apache.ignite.ml.inference.json.JSONModel;
import org.apache.ignite.ml.inference.json.JSONWritable;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.math.primitives.vector.VectorUtils;

public final class LinearRegressionModel
implements IgniteModel<Vector, Double>,
Exportable<LinearRegressionModel>,
JSONWritable {
    private static final long serialVersionUID = -105984600091550226L;
    private Vector weights;
    private double intercept;

    public LinearRegressionModel(Vector weights, double intercept) {
        this.weights = weights;
        this.intercept = intercept;
    }

    private LinearRegressionModel() {
    }

    public Vector weights() {
        return this.weights;
    }

    public double intercept() {
        return this.intercept;
    }

    public LinearRegressionModel withWeights(Vector weights) {
        this.weights = weights;
        return this;
    }

    public LinearRegressionModel withIntercept(double intercept) {
        this.intercept = intercept;
        return this;
    }

    @Override
    public Double predict(Vector input) {
        return input.dot(this.weights) + this.intercept;
    }

    @Override
    public <P> void saveModel(Exporter<LinearRegressionModel, P> exporter, P path) {
        exporter.save(this, path);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinearRegressionModel mdl = (LinearRegressionModel)o;
        return Double.compare(mdl.intercept, this.intercept) == 0 && Objects.equals(this.weights, mdl.weights);
    }

    public int hashCode() {
        return Objects.hash(this.weights, this.intercept);
    }

    public String toString() {
        if (this.weights.size() < 10) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < this.weights.size(); ++i) {
                double nextItem = i == this.weights.size() - 1 ? this.intercept : this.weights.get(i + 1);
                builder.append(String.format("%.4f", Math.abs(this.weights.get(i)))).append("*x").append(i).append(nextItem > 0.0 ? " + " : " - ");
            }
            builder.append(String.format("%.4f", Math.abs(this.intercept)));
            return builder.toString();
        }
        return "LinearRegressionModel [weights=" + this.weights + ", intercept=" + this.intercept + ']';
    }

    @Override
    public String toString(boolean pretty) {
        return this.toString();
    }

    public static LinearRegressionModel fromJSON(Path path) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            LinearRegressionModelJSONExportModel linearRegressionJSONExportModel = (LinearRegressionModelJSONExportModel)mapper.readValue(new File(path.toAbsolutePath().toString()), LinearRegressionModelJSONExportModel.class);
            return linearRegressionJSONExportModel.convert();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void toJSON(Path path) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            LinearRegressionModelJSONExportModel exportModel = new LinearRegressionModelJSONExportModel(System.currentTimeMillis(), "linreg_" + UUID.randomUUID().toString(), LinearRegressionModel.class.getSimpleName());
            exportModel.intercept = this.intercept;
            exportModel.weights = this.weights.asArray();
            File file = new File(path.toAbsolutePath().toString());
            mapper.writeValue(file, (Object)exportModel);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class LinearRegressionModelJSONExportModel
    extends JSONModel {
        public double[] weights;
        public double intercept;

        public LinearRegressionModelJSONExportModel(Long timestamp, String uid, String modelClass) {
            super(timestamp, uid, modelClass);
        }

        @JsonCreator
        public LinearRegressionModelJSONExportModel() {
        }

        @Override
        public LinearRegressionModel convert() {
            LinearRegressionModel linRegMdl = new LinearRegressionModel();
            linRegMdl.withWeights(VectorUtils.of(this.weights));
            linRegMdl.withIntercept(this.intercept);
            return linRegMdl;
        }
    }
}

