/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.selection.split.mapper;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.ignite.ml.selection.split.mapper.UniformMapper;

public class SHA256UniformMapper<K, V>
implements UniformMapper<K, V> {
    private static final long serialVersionUID = -8179630783617088803L;
    private static final String HASHING_ALGORITHM = "SHA-256";
    private static final ThreadLocal<MessageDigest> digest = new ThreadLocal();
    private final List<Integer> shuffleStgy = Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7);

    public SHA256UniformMapper() {
    }

    public SHA256UniformMapper(Random random) {
        Collections.shuffle(this.shuffleStgy, random);
    }

    @Override
    public double map(K key, V val) {
        int h = Math.abs(key.hashCode());
        String str = String.valueOf(key.hashCode());
        byte[] hash = this.getDigest().digest(str.getBytes(StandardCharsets.UTF_8));
        byte hashByte = hash[h % hash.length];
        int resByte = 0;
        for (int i = 0; i < 8; ++i) {
            resByte = (byte)(resByte << 1 | hashByte >> this.shuffleStgy.get(i) & 1);
        }
        return 1.0 * (double)(resByte & 0xFF) / 256.0;
    }

    private MessageDigest getDigest() {
        if (digest.get() == null) {
            try {
                digest.set(MessageDigest.getInstance(HASHING_ALGORITHM));
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        return digest.get();
    }
}

