/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.tree;

import java.util.Map;
import java.util.NavigableMap;
import org.apache.ignite.ml.tree.DecisionTreeConditionalNode;
import org.apache.ignite.ml.tree.DecisionTreeLeafNode;
import org.apache.ignite.ml.tree.DecisionTreeModel;
import org.apache.ignite.ml.tree.DecisionTreeNode;

public class NodeData {
    public int id;
    public double prediction;
    public int leftChildId;
    public int rightChildId;
    public double threshold;
    public int featureIdx;
    public boolean isLeafNode;

    public String toString() {
        return "NodeData{id=" + this.id + ", prediction=" + this.prediction + ", leftChildId=" + this.leftChildId + ", rightChildId=" + this.rightChildId + ", threshold=" + this.threshold + ", featureIdx=" + this.featureIdx + ", isLeafNode=" + this.isLeafNode + '}';
    }

    public static DecisionTreeNode buildTree(Map<Integer, NodeData> nodes, NodeData rootNodeData) {
        return rootNodeData.isLeafNode ? new DecisionTreeLeafNode(rootNodeData.prediction) : new DecisionTreeConditionalNode(rootNodeData.featureIdx, rootNodeData.threshold, NodeData.buildTree(nodes, nodes.get(rootNodeData.rightChildId)), NodeData.buildTree(nodes, nodes.get(rootNodeData.leftChildId)), null);
    }

    public static DecisionTreeModel buildDecisionTreeModel(Map<Integer, NodeData> nodes) {
        DecisionTreeModel mdl = null;
        if (!nodes.isEmpty()) {
            NodeData rootNodeData = (NodeData)((NavigableMap)nodes).firstEntry().getValue();
            mdl = new DecisionTreeModel(NodeData.buildTree(nodes, rootNodeData));
            return mdl;
        }
        return mdl;
    }
}

