/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.util.generators.primitives.scalar;

import java.util.Arrays;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.ml.math.functions.IgniteFunction;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.math.primitives.vector.VectorUtils;
import org.apache.ignite.ml.util.generators.primitives.vector.VectorGenerator;

public interface RandomProducer
extends Supplier<Double> {
    default public VectorGenerator vectorize(int vectorSize) {
        return () -> VectorUtils.of(IntStream.range(0, vectorSize).mapToDouble(x -> (Double)this.get()).toArray());
    }

    default public IgniteFunction<Double, Double> noizify(IgniteFunction<Double, Double> f) {
        return t -> (Double)f.apply((Double)t) + (Double)this.get();
    }

    default public Vector noizify(Vector vector) {
        Vector cp = vector.copy();
        for (int i = 0; i < vector.size(); ++i) {
            cp.set(i, cp.get(i) + (Double)this.get());
        }
        return cp;
    }

    public static VectorGenerator vectorize(RandomProducer ... producers) {
        A.notEmpty((Object[])producers, (String)"producers");
        return () -> VectorUtils.of(Arrays.stream(producers).mapToDouble(Supplier::get).toArray());
    }
}

