/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.util.generators.standard;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.ml.math.functions.IgniteFunction;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.structures.LabeledVector;
import org.apache.ignite.ml.util.generators.DataStreamGenerator;
import org.apache.ignite.ml.util.generators.primitives.vector.VectorGenerator;
import org.apache.ignite.ml.util.generators.primitives.vector.VectorGeneratorPrimitives;
import org.apache.ignite.ml.util.generators.primitives.vector.VectorGeneratorsFamily;

public class GaussianMixtureDataStream
implements DataStreamGenerator {
    private final List<IgniteFunction<Long, VectorGenerator>> componentGenerators;
    private long seed;

    private GaussianMixtureDataStream(List<IgniteFunction<Long, VectorGenerator>> componentGenerators, long seed) {
        this.componentGenerators = componentGenerators;
        this.seed = seed;
    }

    @Override
    public Stream<LabeledVector<Double>> labeled() {
        VectorGeneratorsFamily.Builder builder = new VectorGeneratorsFamily.Builder();
        for (int i = 0; i < this.componentGenerators.size(); ++i) {
            builder = builder.add((VectorGenerator)this.componentGenerators.get(i).apply(this.seed), 1.0);
            this.seed *= 2L;
        }
        return builder.build().asDataStream().labeled();
    }

    public static class Builder {
        private List<IgniteFunction<Long, VectorGenerator>> componentGenerators = new ArrayList<IgniteFunction<Long, VectorGenerator>>();

        public Builder add(Vector mean, Vector variance) {
            this.componentGenerators.add(seed -> VectorGeneratorPrimitives.gauss(mean, variance, seed));
            return this;
        }

        public GaussianMixtureDataStream build() {
            return this.build(System.currentTimeMillis());
        }

        public GaussianMixtureDataStream build(long seed) {
            A.notEmpty(this.componentGenerators, (String)"this.means.size()");
            return new GaussianMixtureDataStream(this.componentGenerators, seed);
        }
    }
}

