/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.util.genetic;

import org.jetbrains.annotations.NotNull;

public class Chromosome
implements Comparable {
    private Double[] genes;
    private Double fitness = Double.NaN;

    public Chromosome(int size) {
        this.genes = new Double[size];
    }

    public Chromosome(Double[] doubles) {
        this.genes = (Double[])doubles.clone();
    }

    public Double[] toDoubleArray() {
        return this.genes;
    }

    public Double getFitness() {
        return this.fitness;
    }

    public void setFitness(Double fitness) {
        this.fitness = fitness;
    }

    public int size() {
        return this.genes.length;
    }

    public double getGene(int idx) {
        return this.genes[idx];
    }

    public void setGene(int idx, double geneValue) {
        this.genes[idx] = geneValue;
    }

    public Chromosome copy() {
        Chromosome cp = new Chromosome(this.genes);
        cp.fitness = this.fitness;
        return cp;
    }

    public int compareTo(@NotNull Object o) {
        return (int)Math.signum(this.getFitness() - ((Chromosome)o).getFitness());
    }
}

