/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.isis.applib.NameUtils;

public class Identifier
implements Comparable<Identifier> {
    private static final List<String> EMPTY_LIST_OF_STRINGS = Collections.emptyList();
    public static Depth CLASS = Depth.CLASS;
    public static Depth CLASS_MEMBERNAME = Depth.CLASS_MEMBERNAME;
    public static Depth CLASS_MEMBERNAME_PARAMETERS = Depth.CLASS_MEMBERNAME_PARAMETERS;
    public static Depth MEMBERNAME_ONLY = Depth.MEMBERNAME_ONLY;
    public static Depth PARAMETERS_ONLY = Depth.PARAMETERS_ONLY;
    private final String className;
    private final String memberName;
    private final List<String> parameterNames;
    private final Type type;
    private String identityString;
    private String asString = null;

    public static Identifier classIdentifier(Class<?> cls) {
        return Identifier.classIdentifier(cls.getName());
    }

    public static Identifier classIdentifier(String className) {
        return new Identifier(className, "", EMPTY_LIST_OF_STRINGS, Type.CLASS);
    }

    public static Identifier propertyOrCollectionIdentifier(Class<?> declaringClass, String propertyOrCollectionName) {
        return Identifier.propertyOrCollectionIdentifier(declaringClass.getCanonicalName(), propertyOrCollectionName);
    }

    public static Identifier propertyOrCollectionIdentifier(String declaringClassName, String propertyOrCollectionName) {
        return new Identifier(declaringClassName, propertyOrCollectionName, EMPTY_LIST_OF_STRINGS, Type.PROPERTY_OR_COLLECTION);
    }

    public static Identifier actionIdentifier(Class<?> declaringClass, String actionName, Class<?> ... parameterClasses) {
        return Identifier.actionIdentifier(declaringClass.getCanonicalName(), actionName, Identifier.classNamesOf(parameterClasses));
    }

    public static Identifier actionIdentifier(String declaringClassName, String actionName, Class<?> ... parameterClasses) {
        return Identifier.actionIdentifier(declaringClassName, actionName, Identifier.classNamesOf(parameterClasses));
    }

    public static Identifier actionIdentifier(String declaringClassName, String actionName, List<String> parameterClassNames) {
        return new Identifier(declaringClassName, actionName, parameterClassNames, Type.ACTION);
    }

    private static List<String> classNamesOf(Class<?>[] parameterClasses) {
        if (parameterClasses == null) {
            return EMPTY_LIST_OF_STRINGS;
        }
        ArrayList parameterClassNames = Lists.newArrayList();
        for (Class<?> parameterClass : parameterClasses) {
            parameterClassNames.add(parameterClass.getName());
        }
        return parameterClassNames;
    }

    private Identifier(String className, String memberName, List<String> parameterNames, Type type) {
        this.className = className;
        this.memberName = memberName;
        this.parameterNames = Collections.unmodifiableList(parameterNames);
        this.type = type;
    }

    public String getClassName() {
        return this.className;
    }

    public String getClassNaturalName() {
        String className = this.getClassName();
        String isolatedName = className.substring(className.lastIndexOf(46) + 1);
        return NameUtils.naturalName(isolatedName);
    }

    public String getMemberName() {
        return this.memberName;
    }

    public String getMemberNaturalName() {
        return NameUtils.naturalName(this.memberName);
    }

    public List<String> getMemberParameterNames() {
        return this.parameterNames;
    }

    public List<String> getMemberParameterNaturalNames() {
        return NameUtils.naturalNames(this.parameterNames);
    }

    public Type getType() {
        return this.type;
    }

    public boolean isPropertyOrCollection() {
        return this.type == Type.PROPERTY_OR_COLLECTION;
    }

    public String toIdentityString(Depth depth) {
        return depth.toIdentityString(this);
    }

    public String toClassIdentityString() {
        return this.toClassIdentityString(new StringBuilder()).toString();
    }

    public StringBuilder toClassIdentityString(StringBuilder buf) {
        return buf.append(this.className);
    }

    public String toNameIdentityString() {
        return this.toNameIdentityString(new StringBuilder()).toString();
    }

    public StringBuilder toNameIdentityString(StringBuilder buf) {
        return buf.append(this.memberName);
    }

    public String toClassAndNameIdentityString() {
        return this.toClassAndNameIdentityString(new StringBuilder()).toString();
    }

    public StringBuilder toClassAndNameIdentityString(StringBuilder buf) {
        StringBuilder builder = this.toClassIdentityString(buf).append("#").append(this.memberName);
        if (this.type == Type.ACTION) {
            builder.append("()");
        }
        return builder;
    }

    public String toParmsIdentityString() {
        return this.toParmsIdentityString(new StringBuilder()).toString();
    }

    public StringBuilder toParmsIdentityString(StringBuilder buf) {
        if (this.type == Type.ACTION) {
            this.appendParameterNamesTo(buf);
        }
        return buf;
    }

    private void appendParameterNamesTo(StringBuilder buf) {
        buf.append('(');
        Joiner.on((char)',').appendTo(buf, this.parameterNames);
        buf.append(')');
    }

    public String toNameParmsIdentityString() {
        return this.getMemberName() + this.toParmsIdentityString();
    }

    public StringBuilder toNameParmsIdentityString(StringBuilder buf) {
        buf.append(this.getMemberName());
        this.toParmsIdentityString(buf);
        return buf;
    }

    public String toFullIdentityString() {
        if (this.identityString == null) {
            if (this.memberName.length() == 0) {
                this.identityString = this.toClassIdentityString();
            } else {
                StringBuilder buf = new StringBuilder();
                this.toClassIdentityString(buf).append("#").append(this.memberName);
                this.toParmsIdentityString(buf);
                this.identityString = buf.toString();
            }
        }
        return this.identityString;
    }

    @Override
    public int compareTo(Identifier o2) {
        return this.toString().compareTo(o2.toString());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Identifier)) {
            return false;
        }
        Identifier other = (Identifier)obj;
        return this.equals(other);
    }

    public boolean equals(Identifier other) {
        return this.equals(other.className, this.className) && this.equals(other.memberName, other.memberName) && this.equals(other.parameterNames, this.parameterNames);
    }

    private boolean equals(String a, String b) {
        if (a == b) {
            return true;
        }
        return a != null && a.equals(b);
    }

    private boolean equals(List<String> a, List<String> b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null && b != null) {
            return false;
        }
        if (a != null && b == null) {
            return false;
        }
        if (a != null && b != null) {
            return ((Object)a).equals(b);
        }
        return true;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        if (this.asString == null) {
            StringBuilder buf = new StringBuilder();
            buf.append(this.className);
            buf.append('#');
            buf.append(this.memberName);
            this.appendParameterNamesTo(buf);
            this.asString = buf.toString();
        }
        return this.asString;
    }

    public static Identifier fromIdentityString(String asString) {
        if (asString == null) {
            throw new IllegalArgumentException("expected: non-null identity string");
        }
        int indexOfHash = asString.indexOf("#");
        int indexOfOpenBracket = asString.indexOf("(");
        int indexOfCloseBracket = asString.indexOf(")");
        String className = asString.substring(0, indexOfHash == -1 ? asString.length() : indexOfHash);
        if (indexOfHash == -1 || indexOfHash == asString.length() - 1) {
            return Identifier.classIdentifier(className);
        }
        String name = null;
        if (indexOfOpenBracket == -1) {
            name = asString.substring(indexOfHash + 1);
            return Identifier.propertyOrCollectionIdentifier(className, name);
        }
        ArrayList<String> parmList = new ArrayList<String>();
        name = asString.substring(indexOfHash + 1, indexOfOpenBracket);
        String allParms = asString.substring(indexOfOpenBracket + 1, indexOfCloseBracket).trim();
        if (allParms.length() > 0) {
            StringTokenizer tokens = new StringTokenizer(allParms, ",", false);
            while (tokens.hasMoreTokens()) {
                String nextParam = tokens.nextToken();
                parmList.add(nextParam);
            }
        }
        return Identifier.actionIdentifier(className, name, parmList);
    }

    public static enum Depth {
        CLASS{

            @Override
            public String toIdentityString(Identifier identifier) {
                return identifier.toClassIdentityString();
            }
        }
        ,
        CLASS_MEMBERNAME{

            @Override
            public String toIdentityString(Identifier identifier) {
                return identifier.toClassAndNameIdentityString();
            }
        }
        ,
        CLASS_MEMBERNAME_PARAMETERS{

            @Override
            public String toIdentityString(Identifier identifier) {
                return identifier.toFullIdentityString();
            }
        }
        ,
        MEMBERNAME_ONLY{

            @Override
            public String toIdentityString(Identifier identifier) {
                return identifier.toNameIdentityString();
            }
        }
        ,
        PARAMETERS_ONLY{

            @Override
            public String toIdentityString(Identifier identifier) {
                return identifier.toParmsIdentityString();
            }
        };


        public abstract String toIdentityString(Identifier var1);
    }

    public static enum Type {
        CLASS,
        PROPERTY_OR_COLLECTION,
        ACTION;

    }
}

