/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.filter;

import org.apache.isis.applib.filter.Filter;

public final class Filters {
    private Filters() {
    }

    public static <T> Filter<T> and(final Filter<T> f1, final Filter<T> f2) {
        return new Filter<T>(){

            @Override
            public boolean accept(T f) {
                return f1.accept(f) && f2.accept(f);
            }
        };
    }

    public static <T> Filter<T> or(final Filter<T> f1, final Filter<T> f2) {
        return new Filter<T>(){

            @Override
            public boolean accept(T f) {
                return f1.accept(f) || f2.accept(f);
            }
        };
    }

    public static <T> Filter<T> not(final Filter<T> f1) {
        return new Filter<T>(){

            @Override
            public boolean accept(T f) {
                return !f1.accept(f);
            }
        };
    }

    public static <T> Filter<T> any() {
        return new Filter<T>(){

            @Override
            public boolean accept(T t) {
                return true;
            }
        };
    }

    public static final <T> Filter<T> anyOfType(Class<T> clazz) {
        return Filters.any();
    }

    public static <T> Filter<T> none() {
        return new Filter<T>(){

            @Override
            public boolean accept(T f) {
                return false;
            }
        };
    }

    public static <T> Filter<T> noneOfType(Class<T> clazz) {
        return Filters.none();
    }
}

