/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.fixtures;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.isis.applib.fixtures.BaseFixture;
import org.apache.isis.applib.fixtures.CompositeFixture;
import org.apache.isis.applib.fixtures.FixtureType;
import org.apache.isis.applib.fixtures.switchuser.SwitchUserService;
import org.apache.isis.applib.fixtures.switchuser.SwitchUserServiceAware;

public abstract class AbstractFixture
extends BaseFixture
implements CompositeFixture,
SwitchUserServiceAware {
    private final List<Object> fixtures = new ArrayList<Object>();
    private SwitchUserService switchUserService;

    public AbstractFixture() {
        this(FixtureType.DOMAIN_OBJECTS);
    }

    public AbstractFixture(FixtureType fixtureType) {
        super(fixtureType);
    }

    @Override
    public void install() {
    }

    protected void addFixture(Object fixture) {
        this.fixtures.add(fixture);
    }

    @Override
    public List<Object> getFixtures() {
        return Collections.unmodifiableList(this.fixtures);
    }

    public void earlierDate(int years, int months, int days) {
        if (this.shouldIgnoreCallBecauseNoClockSetup("earlierDate()")) {
            return;
        }
        this.clock.addDate(-years, -months, -days);
    }

    public void earlierTime(int hours, int minutes) {
        if (this.shouldIgnoreCallBecauseNoClockSetup("earlierTime()")) {
            return;
        }
        this.clock.addTime(-hours, -minutes);
    }

    public void laterDate(int years, int months, int days) {
        if (this.shouldIgnoreCallBecauseNoClockSetup("laterDate()")) {
            return;
        }
        this.clock.addDate(years, months, days);
    }

    public void laterTime(int hours, int minutes) {
        if (this.shouldIgnoreCallBecauseNoClockSetup("laterTime()")) {
            return;
        }
        this.clock.addTime(hours, minutes);
    }

    protected void switchUser(String username, String ... roles) {
        this.switchUserService.switchUser(username, roles);
    }

    @Override
    public void setService(SwitchUserService fixtureService) {
        this.switchUserService = fixtureService;
    }
}

