/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.fixtures;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.isis.applib.fixtures.FixtureType;
import org.apache.isis.applib.fixtures.InstallableFixture;

public class LogonFixture
implements InstallableFixture {
    private final String username;
    private final List<String> roles;

    public LogonFixture(String username, String ... roles) {
        this(username, Lists.newArrayList((Object[])roles));
    }

    public LogonFixture(String username, List<String> roles) {
        this.username = username;
        this.roles = ImmutableList.copyOf(roles);
    }

    public String getUsername() {
        return this.username;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    @Override
    public final void install() {
    }

    @Override
    public FixtureType getType() {
        return FixtureType.OTHER;
    }

    public String toString() {
        return "LogonFixture [user: " + this.getUsername() + ", roles: " + this.getRoles() + "]";
    }
}

