/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.fixtures;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.isis.applib.fixtures.BaseFixture;
import org.apache.isis.applib.fixtures.FixtureType;
import org.apache.isis.applib.fixtures.switchuser.SwitchUserService;
import org.apache.isis.applib.fixtures.switchuser.SwitchUserServiceAware;

public class SwitchUserFixture
extends BaseFixture
implements SwitchUserServiceAware {
    private final String username;
    private final List<String> roles;
    private SwitchUserService switchUserService;

    public SwitchUserFixture(String username, String ... roles) {
        this(username, Lists.newArrayList((Object[])roles));
    }

    public SwitchUserFixture(String username, List<String> roles) {
        super(FixtureType.OTHER);
        this.username = username;
        this.roles = ImmutableList.copyOf(roles);
    }

    public String getUsername() {
        return this.username;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    @Override
    public void install() {
        this.switchUserService.switchUser(this.username, this.roles.toArray(new String[0]));
    }

    @Override
    public void setService(SwitchUserService switchUserService) {
        this.switchUserService = switchUserService;
    }
}

