/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.value;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.isis.applib.Defaults;
import org.apache.isis.applib.annotation.Value;
import org.apache.isis.applib.clock.Clock;
import org.apache.isis.applib.value.Magnitude;
import org.apache.isis.applib.value.Time;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;

@Value(semanticsProviderName="org.apache.isis.core.progmodel.facets.value.datetime.DateTimeValueSemanticsProvider")
public class DateTime
extends Magnitude<DateTime> {
    private static final long serialVersionUID = 1L;
    private final org.joda.time.DateTime dateTime;

    public DateTime() {
        org.joda.time.DateTime d;
        this.dateTime = d = new org.joda.time.DateTime(Clock.getTime(), Defaults.getTimeZone());
    }

    public DateTime(Date date) {
        this.dateTime = new org.joda.time.DateTime((Object)date, Defaults.getTimeZone());
    }

    public DateTime(long millisSinceEpoch) {
        this.dateTime = new org.joda.time.DateTime(millisSinceEpoch, Defaults.getTimeZone());
    }

    public DateTime(Date date, TimeZone timeZone) {
        DateTimeZone tz = DateTimeZone.forTimeZone((TimeZone)timeZone);
        this.dateTime = new org.joda.time.DateTime((Object)date, tz);
    }

    public DateTime(org.joda.time.DateTime dateTime) {
        this.dateTime = new org.joda.time.DateTime((Object)dateTime);
    }

    public DateTime(int year, int month, int day) {
        Time time = new Time();
        this.checkTime(year, month, day, 0, 0);
        this.dateTime = new org.joda.time.DateTime(year, month, day, time.getHour(), time.getMinute(), time.getSecond(), 0, Defaults.getTimeZone());
    }

    public DateTime(int year, int month, int day, int hour, int minute) {
        this(year, month, day, hour, minute, 0);
    }

    public DateTime(int year, int month, int day, int hour, int minute, int second) {
        this.checkTime(year, month, day, hour, minute);
        this.dateTime = new org.joda.time.DateTime(year, month, day, hour, minute, second, 0, Defaults.getTimeZone());
    }

    private void checkTime(int year, int month, int day, int hour, int minute) {
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("Month must be in the range 1 - 12 inclusive " + month);
        }
        org.joda.time.DateTime dateTime = new org.joda.time.DateTime(year, month, 1, 0, 0, 0, 0);
        int lastDayOfMonth = dateTime.dayOfMonth().getMaximumValue();
        if (day < 1 || day > lastDayOfMonth) {
            throw new IllegalArgumentException("Day must be in the range 1 - " + lastDayOfMonth + " inclusive " + day);
        }
        if (hour < 0 || hour > 23) {
            throw new IllegalArgumentException("Hour must be in the range 0 - 23 inclusive " + hour);
        }
        if (minute < 0 || minute > 59) {
            throw new IllegalArgumentException("Minute must be in the range 0 - 59 inclusive " + minute);
        }
    }

    public DateTime add(int years, int months, int days, int hours, int minutes) {
        Period period = new Period(years, months, 0, days, hours, minutes, 0, 0);
        org.joda.time.DateTime dateTime = this.dateTime.plus((ReadablePeriod)period);
        return new DateTime(dateTime);
    }

    public DateTime add(int years, int months, int days) {
        return this.add(years, months, days, 0, 0);
    }

    public Calendar calendarValue() {
        return this.dateTime.toGregorianCalendar();
    }

    protected DateTime createDateTime(Date date) {
        return new DateTime(date);
    }

    public Date dateValue() {
        return new Date(this.dateTime.getMillis());
    }

    public int getSeconds() {
        return this.dateTime.getSecondOfMinute();
    }

    public int getMinute() {
        return this.dateTime.getMinuteOfHour();
    }

    public int getHour() {
        return this.dateTime.getHourOfDay();
    }

    public int getDay() {
        return this.dateTime.getDayOfMonth();
    }

    public int getMonth() {
        return this.dateTime.getMonthOfYear();
    }

    public int getYear() {
        return this.dateTime.getYear();
    }

    public int getDayOfYear() {
        return this.dateTime.getDayOfYear();
    }

    public DateTime startOfWeek() {
        return new DateTime(this.dateTime.withDayOfWeek(1));
    }

    public DateTime startOfMonth() {
        return new DateTime(this.dateTime.withDayOfMonth(1));
    }

    public DateTime startOfYear() {
        return new DateTime(this.dateTime.withDayOfYear(1));
    }

    @Override
    public boolean isEqualTo(DateTime timeStamp) {
        return this.dateTime.equals((Object)timeStamp.dateTime);
    }

    @Override
    public boolean isLessThan(DateTime timeStamp) {
        return this.dateTime.isBefore((ReadableInstant)timeStamp.dateTime);
    }

    public boolean isSameDayAs(DateTime dateTime2) {
        return dateTime2 == null ? false : this.getDayOfYear() == dateTime2.getDayOfYear();
    }

    public boolean sameDayOfWeekAs(DateTime dateTime2) {
        return dateTime2 == null ? false : this.dateTime.getDayOfWeek() == dateTime2.dateTime.getDayOfWeek();
    }

    public boolean sameDayOfMonthAs(DateTime dateTime2) {
        return dateTime2 == null ? false : this.dateTime.getDayOfMonth() == dateTime2.dateTime.getDayOfMonth();
    }

    public boolean sameDayOfYearAs(DateTime dateTime2) {
        return dateTime2 == null ? false : this.dateTime.getDayOfYear() == dateTime2.dateTime.getDayOfYear();
    }

    public boolean sameWeekAs(DateTime dateTime2) {
        return dateTime2 == null ? false : this.dateTime.getWeekOfWeekyear() == dateTime2.dateTime.getWeekOfWeekyear();
    }

    public boolean sameMonthAs(DateTime dateTime2) {
        return dateTime2 == null ? false : this.getMonth() == dateTime2.getMonth();
    }

    public boolean sameYearAs(DateTime dateTime2) {
        return dateTime2 == null ? false : this.getYear() == dateTime2.getYear();
    }

    @Deprecated
    public long longValue() {
        return this.millisSinceEpoch();
    }

    public long millisSinceEpoch() {
        return this.dateTime.getMillis();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DateTime other = (DateTime)obj;
        return !(this.dateTime == null ? other.dateTime != null : !this.dateTime.equals((Object)other.dateTime));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dateTime == null ? 0 : this.dateTime.hashCode());
        return result;
    }

    public String toString() {
        return String.format("%04d-%02d-%02d %02d:%02d", this.getYear(), this.getMonth(), this.getDay(), this.getHour(), this.getMinute());
    }
}

