/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.commons.btree;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.base._Either;

public class Compound<T> {
    private final _Either<T, Compound<T>> left;
    private final _Either<T, Compound<T>> right;
    private final int elementCount;
    private static final Compound<?> NIL = new Compound(null, null, 0);

    public static <T> Compound<T> of(@NonNull T left) {
        if (left == null) {
            throw new NullPointerException("left is marked non-null but is null");
        }
        return new Compound<T>(_Either.left(left), _Either.right(Compound.nil()), 1);
    }

    public static <T> Compound<T> of(@NonNull T left, @NonNull T right) {
        if (left == null) {
            throw new NullPointerException("left is marked non-null but is null");
        }
        if (right == null) {
            throw new NullPointerException("right is marked non-null but is null");
        }
        return new Compound<T>(_Either.left(left), _Either.left(right), 2);
    }

    public static <T> Compound<T> of(@NonNull T left, @NonNull Compound<T> right) {
        if (left == null) {
            throw new NullPointerException("left is marked non-null but is null");
        }
        if (right == null) {
            throw new NullPointerException("right is marked non-null but is null");
        }
        return new Compound<T>(_Either.left(left), _Either.right(right), 1 + right.elementCount);
    }

    public static <T> Compound<T> of(@NonNull Compound<T> left, @NonNull T right) {
        if (left == null) {
            throw new NullPointerException("left is marked non-null but is null");
        }
        if (right == null) {
            throw new NullPointerException("right is marked non-null but is null");
        }
        return new Compound(_Either.right(left), _Either.left(right), left.elementCount + 1);
    }

    public static <T> Compound<T> of(@NonNull Compound<T> left, @NonNull Compound<T> right) {
        if (left == null) {
            throw new NullPointerException("left is marked non-null but is null");
        }
        if (right == null) {
            throw new NullPointerException("right is marked non-null but is null");
        }
        return new Compound(_Either.right(left), _Either.right(right), left.elementCount + right.elementCount);
    }

    public int size() {
        return this.elementCount;
    }

    public Stream<T> streamDepthFirstPostorder() {
        return this.elementCount != 0 ? Stream.concat(this.left.fold(Stream::of, Compound::streamDepthFirstPostorder), this.right.fold(Stream::of, Compound::streamDepthFirstPostorder)) : Stream.empty();
    }

    public List<T> flatten() {
        return this.streamDepthFirstPostorder().collect(Collectors.toCollection(() -> new ArrayList(this.elementCount)));
    }

    public <X> Compound<X> map(Function<T, X> mapper) {
        return new MappedStruct<T, X>(this, mapper);
    }

    public static <T> Compound<T> nil() {
        return (Compound)_Casts.uncheckedCast(NIL);
    }

    protected Compound(_Either<T, Compound<T>> left, _Either<T, Compound<T>> right, int elementCount) {
        this.left = left;
        this.right = right;
        this.elementCount = elementCount;
    }

    public String toString() {
        return "Compound(left=" + this.left + ", right=" + this.right + ", elementCount=" + this.elementCount + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Compound)) {
            return false;
        }
        Compound other = (Compound)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.elementCount != other.elementCount) {
            return false;
        }
        _Either<T, Compound<T>> this$left = this.left;
        _Either<T, Compound<T>> other$left = other.left;
        if (this$left == null ? other$left != null : !((Object)this$left).equals(other$left)) {
            return false;
        }
        _Either<T, Compound<T>> this$right = this.right;
        _Either<T, Compound<T>> other$right = other.right;
        return !(this$right == null ? other$right != null : !((Object)this$right).equals(other$right));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Compound;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.elementCount;
        _Either<T, Compound<T>> $left = this.left;
        result = result * 59 + ($left == null ? 43 : ((Object)$left).hashCode());
        _Either<T, Compound<T>> $right = this.right;
        result = result * 59 + ($right == null ? 43 : ((Object)$right).hashCode());
        return result;
    }

    static final class MappedStruct<A, B>
    extends Compound<B> {
        final Compound<A> origin;
        final Function<A, B> mapper;

        protected MappedStruct(Compound<A> origin, Function<A, B> mapper) {
            super(null, null, origin.elementCount);
            this.origin = origin;
            this.mapper = mapper;
        }

        @Override
        public Stream<B> streamDepthFirstPostorder() {
            return this.origin.streamDepthFirstPostorder().map(this.mapper);
        }
    }
}

