/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.commons.btree;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.isis.commons.btree.Compound;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.base._Either;

public class FunCompound<T, R> {
    private final _Either<Function<T, R>, FunCompound<T, R>> left;
    private final _Either<Function<T, R>, FunCompound<T, R>> right;
    private final int elementCount;
    private static final FunCompound<?, ?> NIL = new FunCompound(null, null, 0);

    public static <T, R> FunCompound<T, R> of(@NonNull Function<T, R> left) {
        if (left == null) {
            throw new NullPointerException("left is marked non-null but is null");
        }
        return new FunCompound<T, R>(_Either.left(left), _Either.right(FunCompound.nil()), 1);
    }

    public static <T, R> FunCompound<T, R> of(@NonNull Function<T, R> left, @NonNull Function<T, R> right) {
        if (left == null) {
            throw new NullPointerException("left is marked non-null but is null");
        }
        if (right == null) {
            throw new NullPointerException("right is marked non-null but is null");
        }
        return new FunCompound<T, R>(_Either.left(left), _Either.left(right), 2);
    }

    public static <T, R> FunCompound<T, R> of(@NonNull Function<T, R> left, @NonNull FunCompound<T, R> right) {
        if (left == null) {
            throw new NullPointerException("left is marked non-null but is null");
        }
        if (right == null) {
            throw new NullPointerException("right is marked non-null but is null");
        }
        return new FunCompound<T, R>(_Either.left(left), _Either.right(right), 1 + right.elementCount);
    }

    public static <T, R> FunCompound<T, R> of(@NonNull FunCompound<T, R> left, @NonNull Function<T, R> right) {
        if (left == null) {
            throw new NullPointerException("left is marked non-null but is null");
        }
        if (right == null) {
            throw new NullPointerException("right is marked non-null but is null");
        }
        return new FunCompound<T, R>(_Either.right(left), _Either.left(right), left.elementCount + 1);
    }

    public static <T, R> FunCompound<T, R> of(@NonNull FunCompound<T, R> left, @NonNull FunCompound<T, R> right) {
        if (left == null) {
            throw new NullPointerException("left is marked non-null but is null");
        }
        if (right == null) {
            throw new NullPointerException("right is marked non-null but is null");
        }
        return new FunCompound<T, R>(_Either.right(left), _Either.right(right), left.elementCount + right.elementCount);
    }

    public int size() {
        return this.elementCount;
    }

    public Stream<Function<T, R>> streamDepthFirstPostorder() {
        return this.elementCount != 0 ? Stream.concat(this.left.fold(Stream::of, FunCompound::streamDepthFirstPostorder), this.right.fold(Stream::of, FunCompound::streamDepthFirstPostorder)) : Stream.empty();
    }

    public List<Function<T, R>> flatten() {
        return this.streamDepthFirstPostorder().collect(Collectors.toCollection(() -> new ArrayList(this.elementCount)));
    }

    public Compound<R> apply(T value) {
        return new AppliedStruct(this, value);
    }

    public <X> FunCompound<T, X> map(Function<R, X> mapper) {
        return new MappedFunStruct(this, mapper);
    }

    public <X> FunCompound<T, X> compose(FunCompound<R, X> other) {
        return new ComposedFunStruct(this, other);
    }

    public static <T, R> FunCompound<T, R> nil() {
        return (FunCompound)_Casts.uncheckedCast(NIL);
    }

    protected FunCompound(_Either<Function<T, R>, FunCompound<T, R>> left, _Either<Function<T, R>, FunCompound<T, R>> right, int elementCount) {
        this.left = left;
        this.right = right;
        this.elementCount = elementCount;
    }

    public String toString() {
        return "FunCompound(left=" + this.left + ", right=" + this.right + ", elementCount=" + this.elementCount + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FunCompound)) {
            return false;
        }
        FunCompound other = (FunCompound)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.elementCount != other.elementCount) {
            return false;
        }
        _Either<Function<T, R>, FunCompound<T, R>> this$left = this.left;
        _Either<Function<T, R>, FunCompound<T, R>> other$left = other.left;
        if (this$left == null ? other$left != null : !((Object)this$left).equals(other$left)) {
            return false;
        }
        _Either<Function<T, R>, FunCompound<T, R>> this$right = this.right;
        _Either<Function<T, R>, FunCompound<T, R>> other$right = other.right;
        return !(this$right == null ? other$right != null : !((Object)this$right).equals(other$right));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FunCompound;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.elementCount;
        _Either<Function<T, R>, FunCompound<T, R>> $left = this.left;
        result = result * 59 + ($left == null ? 43 : ((Object)$left).hashCode());
        _Either<Function<T, R>, FunCompound<T, R>> $right = this.right;
        result = result * 59 + ($right == null ? 43 : ((Object)$right).hashCode());
        return result;
    }

    static final class ComposedFunStruct<A, B, C>
    extends FunCompound<A, C> {
        final FunCompound<A, B> origin;
        final FunCompound<B, C> other;

        protected ComposedFunStruct(FunCompound<A, B> origin, FunCompound<B, C> other) {
            super(null, null, origin.elementCount);
            this.origin = origin;
            this.other = other;
        }

        @Override
        public Stream<Function<A, C>> streamDepthFirstPostorder() {
            return this.origin.streamDepthFirstPostorder().flatMap(fun -> this.other.streamDepthFirstPostorder().map((? super T otherFun) -> fun.andThen(otherFun)));
        }
    }

    static final class MappedFunStruct<A, B, C>
    extends FunCompound<A, C> {
        final FunCompound<A, B> origin;
        final Function<B, C> mapper;

        protected MappedFunStruct(FunCompound<A, B> origin, Function<B, C> mapper) {
            super(null, null, origin.elementCount);
            this.origin = origin;
            this.mapper = mapper;
        }

        @Override
        public Stream<Function<A, C>> streamDepthFirstPostorder() {
            return this.origin.streamDepthFirstPostorder().map((? super T fun) -> fun.andThen(this.mapper));
        }
    }

    static final class AppliedStruct<A, B>
    extends Compound<B> {
        final FunCompound<A, B> origin;
        final A value;

        protected AppliedStruct(FunCompound<A, B> origin, A value) {
            super(null, null, origin.elementCount);
            this.origin = origin;
            this.value = value;
        }

        @Override
        public Stream<B> streamDepthFirstPostorder() {
            return this.origin.streamDepthFirstPostorder().map((? super T fun) -> fun.apply(this.value));
        }
    }
}

