/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.commons.collections;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;
import lombok.NonNull;
import org.apache.isis.commons.collections.Can;

public final class CanVector<T>
implements Iterable<Can<T>>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final int size;
    private final List<Can<T>> cans;

    public CanVector(int size) {
        this.size = size;
        this.cans = new ArrayList<Can<T>>(size);
        IntStream.range(0, size).forEach((int __) -> this.cans.add(Can.empty()));
    }

    public int size() {
        return this.size;
    }

    @Override
    public Iterator<Can<T>> iterator() {
        return this.cans.iterator();
    }

    public Can<T> get(int index) {
        return this.cans.get(index);
    }

    public CanVector<T> set(int index, @NonNull Can<T> can) {
        if (can == null) {
            throw new NullPointerException("can is marked non-null but is null");
        }
        this.cans.set(index, can);
        return this;
    }

    public static <T> CanVector<T> empty() {
        return new CanVector<T>(0);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof CanVector ? this.cans.equals(((CanVector)obj).cans) : false;
    }

    public int hashCode() {
        return this.cans.hashCode();
    }
}

