/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.commons.collections;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.isis.commons.collections.Can;
import org.apache.isis.commons.collections.Cardinality;
import org.apache.isis.commons.collections._CanFactory;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.base._Objects;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.springframework.lang.Nullable;

final class Can_Singleton<T>
implements Can<T> {
    private static final long serialVersionUID = 1L;
    private final T element;

    @Override
    public Optional<T> getSingleton() {
        return Optional.of(this.element);
    }

    @Override
    public Cardinality getCardinality() {
        return Cardinality.ONE;
    }

    @Override
    public Stream<T> stream() {
        return Stream.of(this.element);
    }

    @Override
    public Stream<T> parallelStream() {
        return Stream.of(this.element);
    }

    @Override
    public Optional<T> getFirst() {
        return this.getSingleton();
    }

    @Override
    public Optional<T> getLast() {
        return this.getSingleton();
    }

    @Override
    public Optional<T> get(int elementIndex) {
        return this.getSingleton();
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean contains(@Nullable T element) {
        return Objects.equals(this.element, element);
    }

    @Override
    public Iterator<T> iterator(int skip, int limit) {
        return skip < 1 && limit > 0 ? this.iterator() : Collections.emptyList().iterator();
    }

    @Override
    public Iterator<T> iterator() {
        return Collections.singletonList(this.element).iterator();
    }

    @Override
    public Can<T> sorted(@NonNull Comparator<? super T> c) {
        if (c == null) {
            throw new NullPointerException("c is marked non-null but is null");
        }
        return this;
    }

    @Override
    public Can<T> distinct() {
        return this;
    }

    @Override
    public Can<T> distinct(@NonNull BiPredicate<T, T> equality) {
        if (equality == null) {
            throw new NullPointerException("equality is marked non-null but is null");
        }
        return this;
    }

    @Override
    public Can<T> reverse() {
        return this;
    }

    @Override
    public Iterator<T> reverseIterator() {
        return this.iterator();
    }

    @Override
    public void forEach(@NonNull Consumer<? super T> action) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        action.accept(this.element);
    }

    @Override
    public Can<T> filter(@Nullable Predicate<? super T> predicate) {
        if (predicate == null) {
            return this;
        }
        return predicate.test(this.element) ? this : Can.empty();
    }

    @Override
    public <R> void zip(Iterable<R> zippedIn, BiConsumer<? super T, ? super R> action) {
        action.accept(this.element, zippedIn.iterator().next());
    }

    @Override
    public <R, Z> Can<R> zipMap(Iterable<Z> zippedIn, BiFunction<? super T, ? super Z, R> mapper) {
        return Can_Singleton.of(mapper.apply(this.element, zippedIn.iterator().next()));
    }

    @Override
    public Can<T> add(@Nullable T element) {
        return element != null ? Can.ofStream(Stream.of(this.element, element)) : this;
    }

    @Override
    public Can<T> addAll(@Nullable Can<T> other) {
        if (other == null || other.isEmpty()) {
            return this;
        }
        if (other.isCardinalityOne()) {
            return this.add(other.getSingleton().orElseThrow(_Exceptions::unexpectedCodeReach));
        }
        ArrayList<T> newElements = new ArrayList<T>(other.size() + 1);
        newElements.add(this.element);
        other.forEach(newElements::add);
        return _CanFactory.ofNonNullElements(newElements);
    }

    @Override
    public Can<T> add(int index, @Nullable T element) {
        if (element == null) {
            return this;
        }
        if (index == 0) {
            return Can.ofStream(Stream.of(element, this.element));
        }
        if (index == 1) {
            return Can.ofStream(Stream.of(this.element, element));
        }
        throw new IndexOutOfBoundsException("cannot add to singleton with index other than 0 or 1; got " + index);
    }

    @Override
    public Can<T> replace(int index, @Nullable T element) {
        if (index != 0) {
            throw new IndexOutOfBoundsException("cannot replace on singleton with index other than 0; got " + index);
        }
        return element != null ? Can.ofSingleton(element) : Can.empty();
    }

    @Override
    public Can<T> remove(int index) {
        if (index == 0) {
            return Can.empty();
        }
        throw new IndexOutOfBoundsException("cannot remove from singleton with index other than 0; got " + index);
    }

    @Override
    public Can<T> remove(@Nullable T element) {
        if (this.element.equals(element)) {
            return Can.empty();
        }
        return this;
    }

    @Override
    public Can<T> pickByIndex(int ... indices) {
        if (indices == null || indices.length == 0) {
            return Can.empty();
        }
        int pickCount = 0;
        for (int index : indices) {
            if (index != 0) continue;
            ++pickCount;
        }
        if (pickCount == 0) {
            return Can.empty();
        }
        if (pickCount == 1) {
            return this;
        }
        ArrayList<T> newElements = new ArrayList<T>(pickCount);
        for (int i = 0; i < pickCount; ++i) {
            newElements.add(this.element);
        }
        return _CanFactory.ofNonNullElements(newElements);
    }

    @Override
    public int indexOf(@Nullable T element) {
        return this.element.equals(element) ? 0 : -1;
    }

    public String toString() {
        return "Can[" + this.element + "]";
    }

    public boolean equals(Object obj) {
        if (obj instanceof Can) {
            return ((Can)obj).isEqualTo(this);
        }
        return false;
    }

    public int hashCode() {
        return this.element.hashCode();
    }

    @Override
    public int compareTo(@Nullable Can<T> other) {
        if (other == null || other.isEmpty()) {
            return 1;
        }
        int firstElementComparison = _Objects.compareNonNull(this.element, other.getFirstOrFail());
        if (firstElementComparison != 0 || other.isCardinalityOne()) {
            return firstElementComparison;
        }
        return -1;
    }

    @Override
    public List<T> toList() {
        return Collections.singletonList(this.element);
    }

    @Override
    public Set<T> toSet() {
        return Collections.singleton(this.element);
    }

    @Override
    public Set<T> toSet(@NonNull Consumer<T> onDuplicated) {
        if (onDuplicated == null) {
            throw new NullPointerException("onDuplicated is marked non-null but is null");
        }
        return Collections.singleton(this.element);
    }

    @Override
    public <C extends Collection<T>> C toCollection(@NonNull Supplier<C> collectionFactory) {
        if (collectionFactory == null) {
            throw new NullPointerException("collectionFactory is marked non-null but is null");
        }
        Collection collection = (Collection)collectionFactory.get();
        collection.add(this.element);
        return (C)collection;
    }

    @Override
    public T[] toArray(@NonNull Class<T> elementType) {
        if (elementType == null) {
            throw new NullPointerException("elementType is marked non-null but is null");
        }
        Object[] array = (Object[])_Casts.uncheckedCast(Array.newInstance(elementType, 1));
        array[0] = this.element;
        return array;
    }

    private Can_Singleton(T element) {
        this.element = element;
    }

    public static <T> Can_Singleton<T> of(T element) {
        return new Can_Singleton<T>(element);
    }
}

