/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.commons.collections;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.stream.Stream;

public final class ImmutableEnumSet<E extends Enum<E>>
implements Iterable<E>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final EnumSet<E> delegate;

    private ImmutableEnumSet(EnumSet<E> delegate) {
        this.delegate = delegate;
    }

    public static <E extends Enum<E>> ImmutableEnumSet<E> from(EnumSet<E> delegate) {
        return new ImmutableEnumSet<E>(delegate);
    }

    public static <E extends Enum<E>> ImmutableEnumSet<E> noneOf(Class<E> enumType) {
        return ImmutableEnumSet.from(EnumSet.noneOf(enumType));
    }

    public static <E extends Enum<E>> ImmutableEnumSet<E> of(E e1) {
        return ImmutableEnumSet.from(EnumSet.of(e1));
    }

    public static <E extends Enum<E>> ImmutableEnumSet<E> of(E e1, E e2) {
        return ImmutableEnumSet.from(EnumSet.of(e1, e2));
    }

    public static <E extends Enum<E>> ImmutableEnumSet<E> of(E e1, E e2, E e3) {
        return ImmutableEnumSet.from(EnumSet.of(e1, e2, e3));
    }

    public static <E extends Enum<E>> ImmutableEnumSet<E> of(E e1, E e2, E e3, E e4) {
        return ImmutableEnumSet.from(EnumSet.of(e1, e2, e3, e4));
    }

    public static <E extends Enum<E>> ImmutableEnumSet<E> complementOf(ImmutableEnumSet<E> other) {
        return ImmutableEnumSet.from(EnumSet.complementOf(other.delegate));
    }

    public static <E extends Enum<E>> ImmutableEnumSet<E> allOf(Class<E> enumType) {
        return ImmutableEnumSet.from(EnumSet.allOf(enumType));
    }

    public boolean contains(E element) {
        return this.delegate.contains(element);
    }

    public EnumSet<E> toEnumSet() {
        return this.delegate.clone();
    }

    @Override
    public Iterator<E> iterator() {
        return this.delegate.iterator();
    }

    public Stream<E> stream() {
        return this.delegate.stream();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public ImmutableEnumSet<E> add(E entry) {
        if (this.contains(entry)) {
            return this;
        }
        Object newEnumSet = this.delegate.clone();
        ((AbstractCollection)newEnumSet).add(entry);
        return ImmutableEnumSet.from(newEnumSet);
    }
}

