/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.commons.concurrent;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.isis.commons.internal.exceptions._Exceptions;

public final class AwaitableLatch {
    private final CountDownLatch countDownLatch;

    public static AwaitableLatch unlocked() {
        return AwaitableLatch.of(new CountDownLatch(0));
    }

    public void await() {
        try {
            this.countDownLatch.await();
        }
        catch (InterruptedException e) {
            throw _Exceptions.unrecoverable(e);
        }
    }

    public boolean await(long timeout, TimeUnit unit) {
        try {
            return this.countDownLatch.await(timeout, unit);
        }
        catch (InterruptedException e) {
            throw _Exceptions.unrecoverable(e);
        }
    }

    private AwaitableLatch(CountDownLatch countDownLatch) {
        this.countDownLatch = countDownLatch;
    }

    public static AwaitableLatch of(CountDownLatch countDownLatch) {
        return new AwaitableLatch(countDownLatch);
    }
}

