/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.commons.functional;

import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import lombok.NonNull;
import org.springframework.lang.Nullable;

public final class Result<L> {
    private final L value;
    private final Throwable throwable;
    private final boolean isSuccess;

    public static <L> Result<L> of(@NonNull Callable<L> callable) {
        if (callable == null) {
            throw new NullPointerException("callable is marked non-null but is null");
        }
        try {
            return Result.success(callable.call());
        }
        catch (Throwable e) {
            return Result.failure(e);
        }
    }

    public static <L> Result<L> success(@Nullable L value) {
        return Result.of(value, null, true);
    }

    public static <L> Result<L> failure(@NonNull Throwable throwable) {
        if (throwable == null) {
            throw new NullPointerException("throwable is marked non-null but is null");
        }
        return Result.of(null, throwable, false);
    }

    public static <L> Result<L> failure(@NonNull String message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        return Result.failure(new RuntimeException(message));
    }

    public static <L> Result<L> failure(@NonNull String message, @NonNull Throwable cause) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (cause == null) {
            throw new NullPointerException("cause is marked non-null but is null");
        }
        return Result.failure(new RuntimeException(message, cause));
    }

    public boolean isSuccess() {
        return this.isSuccess;
    }

    public boolean isFailure() {
        return !this.isSuccess();
    }

    public Optional<L> getValue() {
        return Optional.ofNullable(this.value);
    }

    public Optional<Throwable> getFailure() {
        return Optional.ofNullable(this.throwable);
    }

    public Result<L> ifSuccess(@NonNull Consumer<L> valueConsumer) {
        if (valueConsumer == null) {
            throw new NullPointerException("valueConsumer is marked non-null but is null");
        }
        if (this.isSuccess()) {
            valueConsumer.accept(this.value);
        }
        return this;
    }

    public Result<L> ifSuccessAndValuePresent(@NonNull Consumer<L> valueConsumer) {
        if (valueConsumer == null) {
            throw new NullPointerException("valueConsumer is marked non-null but is null");
        }
        this.getValue().ifPresent(valueConsumer::accept);
        return this;
    }

    public Result<L> ifFailure(@NonNull Consumer<Throwable> exceptionConsumer) {
        if (exceptionConsumer == null) {
            throw new NullPointerException("exceptionConsumer is marked non-null but is null");
        }
        if (this.isFailure()) {
            exceptionConsumer.accept(this.throwable);
        }
        return this;
    }

    public <E extends Throwable> Result<L> mapSuccessWithEmptyValueToFailure(@NonNull Supplier<E> onNullValue) {
        if (onNullValue == null) {
            throw new NullPointerException("onNullValue is marked non-null but is null");
        }
        return this.isSuccess() && this.value == null ? Result.failure((Throwable)onNullValue.get()) : this;
    }

    public <E extends Throwable> Result<L> mapSuccessWithEmptyValueToNoSuchElement() {
        return this.mapSuccessWithEmptyValueToFailure(NoSuchElementException::new);
    }

    public <T> Result<T> mapSuccess(@NonNull Function<L, T> successMapper) {
        if (successMapper == null) {
            throw new NullPointerException("successMapper is marked non-null but is null");
        }
        return this.isSuccess() ? Result.of(() -> successMapper.apply(this.value)) : Result.failure(this.throwable);
    }

    public Result<L> mapFailure(@NonNull UnaryOperator<Throwable> failureMapper) {
        if (failureMapper == null) {
            throw new NullPointerException("failureMapper is marked non-null but is null");
        }
        if (this.isSuccess()) {
            return this;
        }
        try {
            return Result.failure((Throwable)failureMapper.apply(this.throwable));
        }
        catch (Throwable e) {
            return Result.failure(e);
        }
    }

    public <T> T fold(@NonNull Function<L, T> successMapper, @NonNull Function<Throwable, T> failureMapper) {
        if (successMapper == null) {
            throw new NullPointerException("successMapper is marked non-null but is null");
        }
        if (failureMapper == null) {
            throw new NullPointerException("failureMapper is marked non-null but is null");
        }
        return this.isSuccess() ? successMapper.apply(this.value) : failureMapper.apply(this.throwable);
    }

    public L presentElseFail() {
        if (this.isSuccess()) {
            if (this.value == null) {
                throw new NoSuchElementException();
            }
            return this.value;
        }
        throw this.throwable;
    }

    public Optional<L> optionalElseFail() {
        if (this.isSuccess()) {
            return this.getValue();
        }
        throw this.throwable;
    }

    public L presentElseThrow(@NonNull UnaryOperator<Throwable> toThrowable) {
        if (toThrowable == null) {
            throw new NullPointerException("toThrowable is marked non-null but is null");
        }
        if (this.isSuccess()) {
            if (this.value == null) {
                throw (Throwable)toThrowable.apply(new NoSuchElementException());
            }
            return this.value;
        }
        throw (Throwable)toThrowable.apply(this.throwable);
    }

    public Optional<L> optionalElseThrow(@NonNull UnaryOperator<Throwable> toThrowable) {
        if (toThrowable == null) {
            throw new NullPointerException("toThrowable is marked non-null but is null");
        }
        if (this.isSuccess()) {
            return this.getValue();
        }
        throw (Throwable)toThrowable.apply(this.throwable);
    }

    public L presentElse(@NonNull L defaultValue) {
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        if (this.isSuccess() && this.value != null) {
            return this.value;
        }
        return defaultValue;
    }

    public L presentElseGet(@NonNull Supplier<L> defaultValueSupplier) {
        if (defaultValueSupplier == null) {
            throw new NullPointerException("defaultValueSupplier is marked non-null but is null");
        }
        if (this.isSuccess() && this.value != null) {
            return this.value;
        }
        L defaultValue = defaultValueSupplier.get();
        if (defaultValue != null) {
            return defaultValue;
        }
        throw new NoSuchElementException();
    }

    private Result(L value, Throwable throwable, boolean isSuccess) {
        this.value = value;
        this.throwable = throwable;
        this.isSuccess = isSuccess;
    }

    private static <L> Result<L> of(L value, Throwable throwable, boolean isSuccess) {
        return new Result<L>(value, throwable, isSuccess);
    }

    public String toString() {
        return "Result(value=" + this.getValue() + ", throwable=" + this.throwable + ", isSuccess=" + this.isSuccess() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        Optional<L> this$value = this.getValue();
        Optional<L> other$value = other.getValue();
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        Throwable this$throwable = this.throwable;
        Throwable other$throwable = other.throwable;
        return !(this$throwable == null ? other$throwable != null : !this$throwable.equals(other$throwable));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        Optional<L> $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        Throwable $throwable = this.throwable;
        result = result * 59 + ($throwable == null ? 43 : $throwable.hashCode());
        return result;
    }
}

