/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.commons.functional;

import java.util.concurrent.Callable;
import lombok.NonNull;
import org.apache.isis.commons.functional.Result;

@FunctionalInterface
public interface ThrowingRunnable {
    public void run() throws Exception;

    public static Callable<Void> toCallable(@NonNull ThrowingRunnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("runnable is marked non-null but is null");
        }
        return () -> {
            runnable.run();
            return null;
        };
    }

    public static Result<Void> resultOf(@NonNull ThrowingRunnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("runnable is marked non-null but is null");
        }
        return Result.of(ThrowingRunnable.toCallable(runnable));
    }
}

